/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP1004
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1004(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String httpHeader = entryContext.getMessageEntry().getHTTPHeaders();
        StringTokenizer httpMessageTokenizer = new StringTokenizer(httpHeader, "\n\r\f");
        if (!httpHeader.startsWith("POST")) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(httpHeader, entryContext);
        }
        String line = null;
        while (httpMessageTokenizer.hasMoreTokens() && this.result.equals("passed")) {
            line = httpMessageTokenizer.nextToken();
            if (line == null || !line.startsWith("M-POST") && !line.startsWith("Ext:")) continue;
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(httpHeader, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

