/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.apache.xerces.dom.PSVIElementNSImpl;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementType
extends NodeType {
    private static final String ELEMENT = "element";
    private static final String SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NIL_ATTRIBUTE = "nil";
    private static final String TRUE_VALUE = "true";
    private Element _value;
    private String _string_value;

    public ElementType() {
        this(null, null);
    }

    public ElementType(Element v, TypeModel tm) {
        super(v, tm);
        this._value = v;
        this._string_value = null;
    }

    public Element value() {
        return this._value;
    }

    public String string_type() {
        return ELEMENT;
    }

    public String getStringValue() {
        if (this._string_value != null) {
            return this._string_value;
        }
        this._string_value = ElementType.textnode_strings(this._value);
        return this._string_value;
    }

    public ResultSequence typed_value() {
        TypeDefinition typeDef = this.getType();
        if (!this.isNilled(this._value)) {
            if (typeDef != null) {
                return this.getXDMTypedValue(typeDef, typeDef.getSimpleTypes(this._value));
            }
            return new XSUntypedAtomic(this.getStringValue());
        }
        return ResultBuffer.EMPTY;
    }

    private boolean isNilled(Element _value2) {
        return TRUE_VALUE.equals(_value2.getAttributeNS(SCHEMA_INSTANCE, NIL_ATTRIBUTE));
    }

    public static String textnode_strings(Node node) {
        String result = "";
        if (node.getNodeType() == 3) {
            Text tn = (Text)node;
            result = String.valueOf(result) + tn.getData();
        }
        NodeList nl = node.getChildNodes();
        StringBuffer buf = new StringBuffer(result);
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            buf.append(ElementType.textnode_strings(n));
            ++i;
        }
        result = buf.toString();
        return result;
    }

    public QName node_name() {
        QName name = new QName(this._value.getPrefix(), this._value.getLocalName(), this._value.getNamespaceURI());
        return name;
    }

    public ResultSequence nilled() {
        if (this._value instanceof PSVIElementNSImpl) {
            PSVIElementNSImpl psviElement = (PSVIElementNSImpl)this._value;
            return XSBoolean.valueOf(psviElement.getNil());
        }
        return XSBoolean.FALSE;
    }

    public boolean isID() {
        return this.isElementType("ID");
    }

    public boolean isIDREF() {
        return this.isElementType("IDREF");
    }

    protected boolean isElementType(String typeName) {
        TypeInfo typeInfo = this._value.getSchemaTypeInfo();
        return this.isType(typeInfo, typeName);
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }
}

