/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.jmock.testcases;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EqualsTestCase<T>
extends TestCase {
    private final Class<T> testClass;

    public EqualsTestCase(Class<T> testClass) {
        this(null, testClass);
    }

    public EqualsTestCase(String name, Class<T> testClass) {
        EqualsTestCase.assertNotNull((String)"test class passed in constructor was null", testClass);
        this.testClass = testClass;
    }

    public abstract Iterator<T> newObjectIterator(int var1);

    public abstract T newEqualInstance();

    public abstract T newAncestorEqualInstance();

    public abstract T newNonEqualInstance();

    public abstract void modifyObjectInstance(T var1);

    public int getIterationsForReflixivityTest() {
        return 100;
    }

    public int getIterationsForSymetricityTest() {
        return 1000;
    }

    public int getIterationsForTransitivityTest() {
        return 2000;
    }

    public void testEqulsReflexive() {
        int iterationsForThisTest = this.getIterationsForReflixivityTest();
        Iterator<T> objectTiterator = this.newObjectIterator(iterationsForThisTest);
        while (objectTiterator.hasNext()) {
            T objectT = objectTiterator.next();
            EqualsTestCase.assertTrue((String)"equals is not reflexive", (boolean)objectT.equals(objectT));
            int initialHashCode = objectT.hashCode();
            int i = 0;
            while (i < iterationsForThisTest) {
                EqualsTestCase.assertEquals((String)"hashCode is not stable upon multiple calls", (int)initialHashCode, (int)objectT.hashCode());
                ++i;
            }
            this.modifyObjectInstance(objectT);
            EqualsTestCase.assertEquals((String)"hashCode is not stable upon modification of the object", (int)initialHashCode, (int)objectT.hashCode());
        }
    }

    public void testEqualsSymetric() {
        int iterationsForThisTest = this.getIterationsForSymetricityTest();
        Iterator<T> objectTIterator1 = this.newObjectIterator(iterationsForThisTest);
        Iterator<T> objectTIterator2 = this.newObjectIterator(iterationsForThisTest);
        while (objectTIterator1.hasNext()) {
            EqualsTestCase.assertTrue((String)"The two object iterators don't have equal number of objects", (boolean)objectTIterator2.hasNext());
            T objectT1 = objectTIterator1.next();
            T objectT2 = objectTIterator2.next();
            if (objectT1.equals(objectT2)) {
                EqualsTestCase.assertTrue((String)"Equals is not symetric", (boolean)objectT2.equals(objectT1));
                EqualsTestCase.assertTrue((String)"Hashcode is not the same for equal instances", (objectT1.hashCode() == objectT2.hashCode() ? 1 : 0) != 0);
                continue;
            }
            if (!objectT2.equals(objectT1)) continue;
            EqualsTestCase.fail((String)"Equals is not symetric");
        }
    }

    public void testEqualsTransitive() {
        int iterationsForThisTest = this.getIterationsForTransitivityTest();
        Iterator<T> objectTIterator1 = this.newObjectIterator(iterationsForThisTest);
        Iterator<T> objectTIterator2 = this.newObjectIterator(iterationsForThisTest);
        Iterator<T> objectTIterator3 = this.newObjectIterator(iterationsForThisTest);
        while (objectTIterator1.hasNext()) {
            EqualsTestCase.assertTrue((String)"The three object iterators don't have equal number of objects", (boolean)objectTIterator2.hasNext());
            EqualsTestCase.assertTrue((String)"The three object iterators don't have equal number of objects", (boolean)objectTIterator3.hasNext());
            T objectT1 = objectTIterator1.next();
            T objectT2 = objectTIterator2.next();
            T objectT3 = objectTIterator3.next();
            if (!objectT1.equals(objectT2) || !objectT1.equals(objectT3)) continue;
            EqualsTestCase.assertTrue((String)"equals is not transitive", (boolean)objectT2.equals(objectT3));
        }
    }

    public void testEqualsReturnsFalseIfNullPassed() {
        T objectT = this.newEqualInstanceCheckCorrect();
        EqualsTestCase.assertFalse((String)"equals returned true when null passed for other object", (boolean)objectT.equals(null));
    }

    public void testEqualsReturnsFalseOnNonEquals() {
        T objectT2;
        T objectT1 = this.newEqualInstanceCheckCorrect();
        EqualsTestCase.assertTrue((String)"Equals reported true for instances assumed non equal.", (!objectT1.equals(objectT2 = this.newNonEqualInstanceCheckCorrect()) && !objectT2.equals(objectT1) ? 1 : 0) != 0);
    }

    public void testEqualsReturnsTrueOnEquals() {
        T objectT2;
        T objectT1 = this.newEqualInstanceCheckCorrect();
        EqualsTestCase.assertTrue((String)"Equals reported false for instances assumed equal.", (objectT1.equals(objectT2 = this.newEqualInstanceCheckCorrect()) && objectT2.equals(objectT1) ? 1 : 0) != 0);
    }

    public void testEqualsReturnsFalseIfOtherClassPassed() {
        T objectT = this.newEqualInstanceCheckCorrect();
        Object object = this.newAncestorEqualInstanceCheckCorrect();
        if (object == null) {
            object = new Object();
        }
        EqualsTestCase.assertFalse((String)"equals returned true when object of another type passed", (boolean)objectT.equals(object));
    }

    public void testEqualsSuitableForAncestors() {
        T ancestorT1 = this.newAncestorEqualInstanceCheckCorrect();
        T ancestorT2 = this.newAncestorEqualInstanceCheckCorrect();
        if (ancestorT1 == null) {
            EqualsTestCase.assertNull((String)"The newAncestorInstance() method returned null on the second invocation, while it return a value differet than null from the first", ancestorT2);
            return;
        }
        EqualsTestCase.assertTrue((ancestorT1.equals(ancestorT2) && ancestorT2.equals(ancestorT1) ? 1 : 0) != 0);
    }

    private T newAncestorEqualInstanceCheckCorrect() {
        T ancestorT = this.newAncestorEqualInstance();
        if (ancestorT == null) {
            EqualsTestCase.assertTrue((String)"newAncestorEqualInstance returned null, although the test class ", (boolean)Modifier.isFinal(this.testClass.getModifiers()));
        } else {
            EqualsTestCase.assertTrue((String)("newAncestorEqualInstance returned object of class " + ancestorT.getClass() + ", which is not subtype of " + this.testClass.getName()), (boolean)this.testClass.isAssignableFrom(ancestorT.getClass()));
        }
        return ancestorT;
    }

    private T newEqualInstanceCheckCorrect() {
        T objectT = this.newEqualInstance();
        EqualsTestCase.assertTrue((String)("newEqualInstance returned object of class " + objectT.getClass().getName() + "Expected was class " + this.testClass.getName()), (this.testClass == objectT.getClass() ? 1 : 0) != 0);
        return objectT;
    }

    private T newNonEqualInstanceCheckCorrect() {
        T objectT = this.newNonEqualInstance();
        EqualsTestCase.assertTrue((String)("newNonEqualInstance returned object of class " + objectT.getClass().getName() + "Expected was class " + this.testClass.getName()), (this.testClass == objectT.getClass() ? 1 : 0) != 0);
        return objectT;
    }
}

