/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.wst.sse.ui.internal.actions.ActionContributor;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.actions.GoToMatchingTagAction;

public class ActionContributorXML
extends ActionContributor {
    private static final String[] EDITOR_IDS = new String[]{"org.eclipse.core.runtime.xml.source", "org.eclipse.core.runtime.xml.source2", "org.eclipse.wst.sse.ui.StructuredTextEditor"};
    private static final String GO_TO_MATCHING_TAG_ID = "org.eclipse.wst.xml.ui.gotoMatchingTag";
    protected RetargetTextEditorAction fCleanupDocument = null;
    protected RetargetTextEditorAction fComment = null;
    protected RetargetTextEditorAction fContentAssist = null;
    protected RetargetTextEditorAction fFindOccurrences = null;
    protected RetargetTextEditorAction fFormatActiveElements = null;
    protected RetargetTextEditorAction fFormatDocument = null;
    protected RetargetTextEditorAction fOpenFileAction = null;
    protected RetargetTextEditorAction fUncomment = null;
    private GoToMatchingTagAction fGoToMatchingTagAction;

    public ActionContributorXML() {
        ResourceBundle resourceBundle = XMLUIMessages.getResourceBundle();
        this.fContentAssist = new RetargetTextEditorAction(resourceBundle, "");
        this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fCleanupDocument = new RetargetTextEditorAction(resourceBundle, "");
        this.fCleanupDocument.setActionDefinitionId("org.eclipse.wst.sse.ui.cleanup.document");
        this.fFormatDocument = new RetargetTextEditorAction(resourceBundle, "");
        this.fFormatDocument.setActionDefinitionId("org.eclipse.wst.sse.ui.format.document");
        this.fFormatActiveElements = new RetargetTextEditorAction(resourceBundle, "");
        this.fFormatActiveElements.setActionDefinitionId("org.eclipse.wst.sse.ui.format.active.elements");
        this.fOpenFileAction = new RetargetTextEditorAction(resourceBundle, "");
        this.fOpenFileAction.setActionDefinitionId("org.eclipse.wst.sse.ui.open.file.from.source");
        this.fFindOccurrences = new RetargetTextEditorAction(resourceBundle, "");
        this.fFindOccurrences.setActionDefinitionId("org.eclipse.wst.sse.ui.search.find.occurrences");
        this.fGoToMatchingTagAction = new GoToMatchingTagAction(resourceBundle, "gotoMatchingTag_", null);
        this.fGoToMatchingTagAction.setActionDefinitionId(GO_TO_MATCHING_TAG_ID);
        this.fGoToMatchingTagAction.setId(GO_TO_MATCHING_TAG_ID);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null) {
            navigateMenu.appendToGroup("open.ext", (IContributionItem)this.fCommandsSeparator);
            navigateMenu.appendToGroup("open.ext", (IAction)this.fOpenFileAction);
            IMenuManager gotoGroup = navigateMenu.findMenuUsingPath("goTo");
            if (gotoGroup != null) {
                gotoGroup.appendToGroup("matchingBegin", (IAction)this.fGoToMatchingTagAction);
            }
        }
        super.contributeToMenu(menu);
    }

    protected void addToMenu(IMenuManager menu) {
    }

    protected String[] getExtensionIDs() {
        return EDITOR_IDS;
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        IStatusLineManager statusLineManager;
        if (this.getActiveEditorPart() == activeEditor) {
            return;
        }
        super.setActiveEditor(activeEditor);
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null && (statusLineManager = actionBars.getStatusLineManager()) != null) {
            statusLineManager.setMessage(null);
            statusLineManager.setErrorMessage(null);
        }
        ITextEditor textEditor = this.getTextEditor(activeEditor);
        this.fContentAssist.setAction(this.getAction(textEditor, "ContentAssistProposals"));
        this.fCleanupDocument.setAction(this.getAction(textEditor, "CleanupDocument"));
        this.fFormatDocument.setAction(this.getAction(textEditor, "FormatDocument"));
        this.fFormatActiveElements.setAction(this.getAction(textEditor, "FormatActiveElements"));
        this.fCleanupDocument.setEnabled(textEditor != null && textEditor.isEditable());
        this.fFormatDocument.setEnabled(textEditor != null && textEditor.isEditable());
        this.fFormatActiveElements.setEnabled(textEditor != null && textEditor.isEditable());
        this.fOpenFileAction.setAction(this.getAction(textEditor, "OpenFileFromSource"));
        this.fFindOccurrences.setAction(this.getAction(textEditor, "FindOccurrences"));
        this.fGoToMatchingTagAction.setEditor(textEditor);
        if (textEditor != null && textEditor.getAction(GO_TO_MATCHING_TAG_ID) != this.fGoToMatchingTagAction) {
            textEditor.setAction(GO_TO_MATCHING_TAG_ID, (IAction)this.fGoToMatchingTagAction);
        }
    }

    public void setViewerSpecificContributionsEnabled(boolean enabled) {
        super.setViewerSpecificContributionsEnabled(enabled);
        this.fContentAssist.setEnabled(enabled);
        this.fFormatActiveElements.setEnabled(enabled);
        this.fOpenFileAction.setEnabled(enabled);
        this.fFindOccurrences.setEnabled(enabled);
        this.fGoToMatchingTagAction.setEnabled(enabled);
        this.fGotoMatchingBracketAction.setEnabled(enabled);
    }
}

