/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSNormalizedString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSToken
extends XSNormalizedString {
    private static final String XS_TOKEN = "xs:token";

    public XSToken(String x) {
        super(x);
    }

    public XSToken() {
        this(null);
    }

    public String string_type() {
        return XS_TOKEN;
    }

    public String type_name() {
        return "token";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        String srcString = aat.getStringValue();
        if (!this.isSatisfiesConstraints(srcString)) {
            DynamicError.throw_type_error();
        }
        return new XSToken(srcString);
    }

    protected boolean isSatisfiesConstraints(String srcString) {
        boolean isToken = true;
        if (!super.isSatisfiesConstraints(srcString) || srcString.startsWith(" ") || srcString.endsWith(" ") || srcString.indexOf("  ") != -1) {
            isToken = false;
        }
        return isToken;
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_TOKEN;
    }
}

