/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.comparator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class VersionComparator<T extends Comparable<T>>
implements Comparator<String> {
    private final String delimiters;
    private final SegmentParser<T> segmentParser;

    public VersionComparator(String delimiters, SegmentParser<T> segmentParser) {
        if (delimiters == null || segmentParser == null) {
            throw new NullPointerException();
        }
        this.delimiters = delimiters;
        this.segmentParser = segmentParser;
    }

    @Override
    public int compare(String version1, String version2) {
        ArrayList<T> segments1 = this.parseVersion(version1);
        ArrayList<T> segments2 = this.parseVersion(version2);
        int size1 = segments1.size();
        int size2 = segments2.size();
        int min = Math.min(size1, size2);
        int i = 0;
        while (i < min) {
            int segmentCompare = ((Comparable)segments1.get(i)).compareTo((Comparable)segments2.get(i));
            if (segmentCompare != 0) {
                return segmentCompare;
            }
            ++i;
        }
        if (size1 == size2) {
            return 0;
        }
        int max = Math.max(size1, size2);
        Comparable zero = this.getZero();
        if (size1 < size2) {
            int i2 = min;
            while (i2 < max) {
                int segmentCompare = zero.compareTo((Comparable)((Comparable)segments2.get(i2)));
                if (segmentCompare != 0) {
                    return segmentCompare;
                }
                ++i2;
            }
        } else {
            int i3 = min;
            while (i3 < max) {
                int segmentCompare = ((Comparable)segments1.get(i3)).compareTo(zero);
                if (segmentCompare != 0) {
                    return segmentCompare;
                }
                ++i3;
            }
        }
        return 0;
    }

    protected ArrayList<T> parseVersion(String s) {
        ArrayList<T> segments = new ArrayList<T>();
        int i = 0;
        StringTokenizer stream = new StringTokenizer(s, this.delimiters);
        while (stream.hasMoreTokens()) {
            segments.add(this.segmentParser.parse(i++, stream.nextToken()));
        }
        return segments;
    }

    protected T getZero() {
        return this.segmentParser.getZero();
    }

    public static interface SegmentParser<T extends Comparable<T>> {
        public T parse(int var1, String var2);

        public T getZero();

        public static final class IntegerSegmentParser
        implements SegmentParser<Integer>,
        Serializable {
            public static final SegmentParser<Integer> INSTANCE = new IntegerSegmentParser();
            private static final Integer ZERO = 0;
            private static final long serialVersionUID = 1L;

            public static SegmentParser<Integer> instance() {
                return INSTANCE;
            }

            private IntegerSegmentParser() {
            }

            @Override
            public Integer parse(int segmentIndex, String segment) {
                return Integer.valueOf(segment);
            }

            @Override
            public Integer getZero() {
                return ZERO;
            }

            public String toString() {
                return ObjectTools.singletonToString(this);
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }
}

