/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import org.apache.wsil.util.WSDLDocument;

public class WSDLDocumentIdentifier {
    public static boolean isInterfaceDocument(WSDLDocument wSDLDocument) {
        Definition definition = wSDLDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasMessageElement(definition) && WSDLDocumentIdentifier.hasPortTypeElement(definition) && WSDLDocumentIdentifier.hasBindingElement(definition);
    }

    public static boolean isBindingInterfaceDocument(WSDLDocument wSDLDocument) {
        Definition definition = wSDLDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasBindingElement(definition);
    }

    public static boolean isImplementationDocument(WSDLDocument wSDLDocument) {
        Definition definition = wSDLDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasImportElement(definition) && WSDLDocumentIdentifier.hasServiceElement(definition);
    }

    public static boolean isCompleteDocument(WSDLDocument wSDLDocument) {
        Definition definition = wSDLDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasMessageElement(definition) && WSDLDocumentIdentifier.hasPortTypeElement(definition) && WSDLDocumentIdentifier.hasBindingElement(definition) && WSDLDocumentIdentifier.hasServiceElement(definition);
    }

    private static boolean hasMessageElement(Definition definition) {
        Iterator iterator = definition.getMessages().values().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            if (message.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPortTypeElement(Definition definition) {
        Iterator iterator = definition.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            if (portType.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBindingElement(Definition definition) {
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            if (binding.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasImportElement(Definition definition) {
        return !definition.getImports().isEmpty();
    }

    private static boolean hasServiceElement(Definition definition) {
        return !definition.getServices().isEmpty();
    }
}

