/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.dialogs;

import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TypedFileViewerFilter
extends ViewerFilter {
    private String[] fAcceptedExtensions;
    private Hashtable visitedElements;

    public TypedFileViewerFilter(String[] acceptedExtensions) {
        this.fAcceptedExtensions = acceptedExtensions;
        this.visitedElements = new Hashtable();
    }

    public boolean isFilterProperty(Object element, Object property) {
        return false;
    }

    public boolean isValid(Object element) {
        if (IFile.class.isInstance(element)) {
            return this.isValidFile((IFile)element);
        }
        if (IContainer.class.isInstance(element)) {
            return this.isValidContainer((IContainer)element);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidContainer(IContainer container) {
        Object valid = this.visitedElements.get(container);
        if (valid != null) {
            return (Boolean)valid;
        }
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                if (this.isValid(members[i])) {
                    this.visitedElements.put(container, Boolean.TRUE);
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        this.visitedElements.put(container, Boolean.FALSE);
        return false;
    }

    public boolean isValidFile(IFile file) {
        String ext = file.getFileExtension();
        int i = 0;
        while (i < this.fAcceptedExtensions.length) {
            if (this.fAcceptedExtensions[i].equalsIgnoreCase(ext)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isValid(element);
    }
}

