/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment;

import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentMapper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDAttributeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd.WSDLPartsToXSDTypeMapper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDAttributeUseToFragmentMapper
extends XSDToFragmentMapper {
    public XSDAttributeUseToFragmentMapper(XSDToFragmentController controller, WSDLPartsToXSDTypeMapper wsdlToXSDMapper) {
        super(controller, wsdlToXSDMapper);
    }

    @Override
    public IXSDFragment getFragment(XSDToFragmentConfiguration config, String id, String name) {
        XSDAttributeUse attribute = (XSDAttributeUse)config.getXSDComponent();
        if (attribute != null && attribute.getAttributeDeclaration() != null) {
            XSDAttributeDeclaration resolvedAttribute = this.resolveXSDAttributeDeclaration(attribute.getAttributeDeclaration());
            XSDTypeDefinition typeDef = this.getXSDTypeDefinition(resolvedAttribute);
            XSDAttributeFragment attributeFrag = new XSDAttributeFragment(id, resolvedAttribute.getName(), config);
            attributeFrag.setXSDTypeDefinition(typeDef);
            XSDToFragmentConfiguration attributeTypeConfig = new XSDToFragmentConfiguration();
            attributeTypeConfig.setXSDComponent((XSDComponent)typeDef);
            attributeTypeConfig.setStyle(config.getStyle());
            attributeTypeConfig.setPartEncoding(config.getPartEncoding());
            attributeTypeConfig.setWSDLPartName(config.getWSDLPartName());
            IXSDFragment xsdFragment = this.getController().getFragment(attributeTypeConfig, attributeFrag.genID(), resolvedAttribute.getName());
            attributeFrag.setXSDDelegationFragment(xsdFragment);
            return attributeFrag;
        }
        return this.getXSDDefaultFragment(config, id, name);
    }

    private XSDAttributeDeclaration resolveXSDAttributeDeclaration(XSDAttributeDeclaration attribute) {
        if (attribute.getResolvedAttributeDeclaration() != null) {
            XSDNamedComponent resolvedComponent;
            XSDAttributeDeclaration resolvedAttribute = attribute.getResolvedAttributeDeclaration();
            if (!this.isComponentResolvable((XSDComponent)resolvedAttribute) && (resolvedComponent = this.getWSDLPartsToXSDTypeMapper().resolveXSDNamedComponent((XSDNamedComponent)resolvedAttribute)) != null && resolvedComponent instanceof XSDAttributeDeclaration) {
                resolvedAttribute = (XSDAttributeDeclaration)resolvedComponent;
            }
            return resolvedAttribute;
        }
        return attribute;
    }

    private XSDTypeDefinition getXSDTypeDefinition(XSDAttributeDeclaration attribute) {
        if (attribute.getTypeDefinition() != null) {
            return attribute.getTypeDefinition();
        }
        if (attribute.getAnonymousTypeDefinition() != null) {
            return attribute.getAnonymousTypeDefinition();
        }
        return null;
    }
}

