/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.SystemTools;
import org.eclipse.jpt.common.utility.internal.XMLTools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLToolsWriteTests
extends TestCase {
    private Document testDocument;
    private Node rootNode;
    private static final String CR = System.getProperty("line.separator");

    public XMLToolsWriteTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testDocument = XMLTools.newDocument();
        this.rootNode = this.testDocument.createElement("root-element");
        this.testDocument.appendChild(this.rootNode);
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-0", (String)"foo");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    private void verifyTestDocumentString(String string) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
        XMLTools.print((Document)this.testDocument, (OutputStream)stream);
        ((OutputStream)stream).close();
        StringBuffer sb = new StringBuffer(2000);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"");
        if ((SystemTools.jvmIsOracle() || SystemTools.jvmIsApple()) && SystemTools.javaSpecificationVersionIsGreaterThan((String)"1.5")) {
            sb.append(" standalone=\"no\"");
        }
        sb.append("?>");
        if (SystemTools.osIsMac()) {
            sb.append(' ');
        }
        if (SystemTools.jvmIsOracle() || SystemTools.jvmIsIBM() && SystemTools.javaSpecificationVersionIsLessThanOrEqualTo((String)"1.5")) {
            sb.append(CR);
        }
        sb.append("<root-element>");
        sb.append(CR);
        sb.append("<element-0>");
        sb.append("foo");
        sb.append("</element-0>");
        sb.append(CR);
        sb.append(string);
        sb.append("</root-element>");
        if (SystemTools.osIsMac()) {
            sb.append(' ');
        }
        if (SystemTools.jvmIsOracle() || SystemTools.jvmIsIBM() && SystemTools.javaSpecificationVersionIsLessThanOrEqualTo((String)"1.5")) {
            sb.append(CR);
        }
        String expected = sb.toString();
        String actual = ((Object)stream).toString();
        XMLToolsWriteTests.assertEquals((String)StringTools.compressWhitespace((String)expected), (String)StringTools.compressWhitespace((String)actual));
    }

    public void testAddSimpleTextNode() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (String)"some text");
        this.verifyTestDocumentString("<element-1>some text</element-1>" + CR);
    }

    public void testAddSimpleTextNodeDefaultValue1() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (String)"some text", (String)"some text");
        this.verifyTestDocumentString("");
    }

    public void testAddSimpleTextNodeDefaultValue2() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (String)"some text", (String)"default text");
        this.verifyTestDocumentString("<element-1>some text</element-1>" + CR);
    }

    public void testAddSimpleTextNodeInt() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (int)42);
        this.verifyTestDocumentString("<element-1>42</element-1>" + CR);
    }

    public void testAddSimpleTextNodeIntDefaultValue1() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (int)42, (int)42);
        this.verifyTestDocumentString("");
    }

    public void testAddSimpleTextNodeIntDefaultValue2() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (int)42, (int)43);
        this.verifyTestDocumentString("<element-1>42</element-1>" + CR);
    }

    public void testAddSimpleTextNodeBoolean() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (boolean)true);
        this.verifyTestDocumentString("<element-1>true</element-1>" + CR);
    }

    public void testAddSimpleTextNodeBooleanDefaultValue1() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (boolean)true, (boolean)true);
        this.verifyTestDocumentString("");
    }

    public void testAddSimpleTextNodeBooleanDefaultValue2() throws Exception {
        XMLTools.addSimpleTextNode((Node)this.rootNode, (String)"element-1", (boolean)false, (boolean)true);
        this.verifyTestDocumentString("<element-1>false</element-1>" + CR);
    }

    public void testAddSimpleTextNodes() throws Exception {
        XMLTools.addSimpleTextNodes((Node)this.rootNode, (String)"element-1-collection", (String)"element-1", (String[])new String[]{"text 1", "text 2", "text 3"});
        StringBuffer sb = new StringBuffer(2000);
        sb.append("<element-1-collection>");
        sb.append(CR);
        sb.append("<element-1>text 1</element-1>");
        sb.append(CR);
        sb.append("<element-1>text 2</element-1>");
        sb.append(CR);
        sb.append("<element-1>text 3</element-1>");
        sb.append(CR);
        sb.append("</element-1-collection>");
        sb.append(CR);
        this.verifyTestDocumentString(sb.toString());
    }
}

