/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.pde.AbstractSimpleClassExtensionRegistryReader;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;
import org.eclipse.jst.jsf.common.internal.strategy.AbstractTestableExtensibleDefaultProviderSelectionStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.ISimpleStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.TestableResourceFactoryStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelManagerFactory;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaDataModelManagerFactory
extends ResourceSingletonObjectManager<IMetaDataModelManager, IResource> {
    private static MetaDataModelManagerFactory INSTANCE;
    private IMetaDataModelManagerFactory EXT_PT_BASED_FACTORY;
    public static final QualifiedName TESTABLE_FACTORY_SESSION_KEY;

    static {
        TESTABLE_FACTORY_SESSION_KEY = new QualifiedName("org.eclipse.jst.jsf.common", "MDModelManagerFactoryInstance");
    }

    private MetaDataModelManagerFactory(IWorkspace workspace) {
        super(workspace);
    }

    public static IMetaDataModelManager getMetaDataModelManagerInstance(IProject project) {
        try {
            return (IMetaDataModelManager)MetaDataModelManagerFactory.getMetaDataModelManagerFactoryInstance(project).getInstance(project != null ? project : ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (ObjectManager.ManagedObjectException e) {
            if (project != null) {
                JSFCommonPlugin.log(e, "Cannot create IMetaDataModelManager for " + project.getName() + " (1)");
            } else {
                JSFCommonPlugin.log(e, "Cannot create workspace shared IMetaDataModelManager (1)");
            }
            return null;
        }
    }

    private static synchronized MetaDataModelManagerFactory getMetaDataModelManagerFactoryInstance(IProject project) {
        if (INSTANCE == null) {
            IWorkspace workspace = MetaDataModelManagerFactory.getWorkspace(project);
            INSTANCE = new MetaDataModelManagerFactory(workspace);
            INSTANCE.init();
        }
        return INSTANCE;
    }

    private static IWorkspace getWorkspace(IProject project) {
        if (project != null) {
            return project.getWorkspace();
        }
        return ResourcesPlugin.getWorkspace();
    }

    private void init() {
        MetaDataModelManagerFactoryExtensionPointReader reader = new MetaDataModelManagerFactoryExtensionPointReader();
        List res = reader.getExtensions();
        if (res != null && res.size() > 0) {
            this.EXT_PT_BASED_FACTORY = (IMetaDataModelManagerFactory)res.get(0);
        }
    }

    @Override
    protected IMetaDataModelManager createNewInstance(IResource resource) {
        try {
            IMetaDataModelManagerFactory factory = this.getMetaDataModelManagerFactoryProviderInstances(resource);
            if (factory != null) {
                return factory.getInstance(resource);
            }
        }
        catch (Exception e) {
            if (resource != null) {
                JSFCommonPlugin.log(e, "Cannot create IMetaDataModelManager for " + resource.getName() + " (2)");
            }
            JSFCommonPlugin.log(e, "Cannot create workspace shared IMetaDataModelManager (2)");
        }
        return null;
    }

    private IMetaDataModelManagerFactory getMetaDataModelManagerFactoryProviderInstances(IResource resource) {
        CompositeFactorySelectionStrategyProvider factoryProvider = new CompositeFactorySelectionStrategyProvider();
        return factoryProvider != null ? factoryProvider.getFactoryToUse(resource) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractManagerProviderStrategy
    implements ISimpleStrategy<IResource, IMetaDataModelManagerFactory> {
        private final IMetaDataModelManagerFactory NO_RESULT = null;

        private AbstractManagerProviderStrategy() {
        }

        @Override
        public IMetaDataModelManagerFactory getNoResult() {
            return this.NO_RESULT;
        }
    }

    private class CompositeFactorySelectionStrategyProvider {
        private CompositeFactorySelectionStrategyProvider() {
        }

        public IMetaDataModelManagerFactory getFactoryToUse(IResource resource) {
            MetaDataModelManagerProviderSelectionStrategy providerSelector = new MetaDataModelManagerProviderSelectionStrategy();
            this.addStrategies(providerSelector);
            IMetaDataModelManagerFactory provider = (IMetaDataModelManagerFactory)providerSelector.perform(resource);
            if (provider != providerSelector.getNoResult()) {
                return provider;
            }
            return null;
        }

        private void addStrategies(MetaDataModelManagerProviderSelectionStrategy providerSelector) {
            providerSelector.addDefaultStrategy(new DefaultManagerProviderStrategy());
            providerSelector.addExtensionStrategy(new ExtensionBasedManagerProviderStrategy());
            providerSelector.addTestableStrategy(new TestableManagerProviderStrategy(TESTABLE_FACTORY_SESSION_KEY));
        }
    }

    private static class DefaultManagerProvider
    implements IMetaDataModelManagerFactory {
        private DefaultManagerProvider() {
        }

        public IMetaDataModelManager getInstance(IResource project) {
            if (project != null && project instanceof IProject) {
                return new MetaDataModelManager((IProject)project);
            }
            return MetaDataModelManager.getSharedInstance();
        }
    }

    private class DefaultManagerProviderStrategy
    extends AbstractManagerProviderStrategy {
        private DefaultManagerProviderStrategy() {
        }

        public IMetaDataModelManagerFactory perform(IResource input) throws Exception {
            return new DefaultManagerProvider();
        }
    }

    private class ExtensionBasedManagerProviderStrategy
    extends AbstractManagerProviderStrategy {
        private ExtensionBasedManagerProviderStrategy() {
        }

        public IMetaDataModelManagerFactory perform(IResource input) throws Exception {
            return MetaDataModelManagerFactory.this.EXT_PT_BASED_FACTORY != null ? MetaDataModelManagerFactory.this.EXT_PT_BASED_FACTORY : this.getNoResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaDataModelManagerFactoryExtensionPointReader
    extends AbstractSimpleClassExtensionRegistryReader<IMetaDataModelManagerFactory> {
        private static final String EXT_PT_ID = "mdModelManagerFactory";
        private static final String EXT_PT_ELEMENT = "factory";
        private static final String EXT_PT_ATTR = "class";

        protected MetaDataModelManagerFactoryExtensionPointReader() {
            super("org.eclipse.jst.jsf.common", EXT_PT_ID, EXT_PT_ELEMENT, EXT_PT_ATTR, new AbstractSimpleClassExtensionRegistryReader.CompareOrgEclipseJstContributorsLastComparator());
        }

        @Override
        protected void handleLoadFailure(CoreException ce) {
            JSFCommonPlugin.log((Throwable)ce, "Error loading IMetaDataModelManagerFactory from extension");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaDataModelManagerProviderSelectionStrategy
    extends AbstractTestableExtensibleDefaultProviderSelectionStrategy<IResource, IMetaDataModelManagerFactory> {
        private static final IMetaDataModelManagerFactory NO_RESULT = null;

        private MetaDataModelManagerProviderSelectionStrategy() {
        }

        @Override
        public IMetaDataModelManagerFactory getNoResult() {
            return NO_RESULT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestableManagerProviderStrategy<IMetaDataModelManagerFactory>
    extends TestableResourceFactoryStrategy<IMetaDataModelManagerFactory> {
        public TestableManagerProviderStrategy(QualifiedName testableFactorySessionKey) {
            super(testableFactorySessionKey);
        }
    }
}

