/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.el.DefaultDTMethodResolver;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.osgi.framework.Bundle;

public class TestDefaultDTMethodResolver
extends TestCase {
    private JDTTestEnvironment _jdtTestEnvironment;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private IType _methodBeanType;
    private static final String SRC_FOLDER_NAME = "src";
    private static final String PACKAGE_NAME = "com.test";
    private static final String TESTBEAN1_NAME = "MethodBean";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestDefaultMethodResolver_" + this.getName());
        projectTestEnvironment.createProject(false);
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.1");
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/MethodBean.java.data", (String)TESTBEAN1_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._methodBeanType = this._jdtTestEnvironment.getJavaProject().findType("com.test.MethodBean");
        TestDefaultDTMethodResolver.assertNotNull((Object)this._methodBeanType);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        try {
            IProject project = this._jdtTestEnvironment.getJavaProject().getProject();
            project.close(null);
            project.delete(true, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
    }

    public void testGetMethod() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("myBean2");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._methodBeanType);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTMethodResolver methodResolver = new DefaultDTMethodResolver();
        IMethodSymbol methodSymbol = methodResolver.getMethod((IObjectSymbol)symbol, (Object)"actionMethod");
        TestDefaultDTMethodResolver.assertNotNull((Object)methodSymbol);
        TestDefaultDTMethodResolver.assertEquals((String)"actionMethod", (String)methodSymbol.getName());
        TestDefaultDTMethodResolver.assertEquals((String)"()Ljava.lang.String;", (String)methodSymbol.getSignature());
        methodSymbol = methodResolver.getMethod((IObjectSymbol)symbol, (Object)"actionMethodWithParam");
        TestDefaultDTMethodResolver.assertNotNull((Object)methodSymbol);
        TestDefaultDTMethodResolver.assertEquals((String)"actionMethodWithParam", (String)methodSymbol.getName());
        TestDefaultDTMethodResolver.assertEquals((String)"(Ljava.lang.String;)Ljava.lang.String;", (String)methodSymbol.getSignature());
        methodSymbol = methodResolver.getMethod((IObjectSymbol)symbol, (Object)"notAMethod");
        TestDefaultDTMethodResolver.assertNull((Object)methodSymbol);
    }

    public void testGetMethods() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("myBean2");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._methodBeanType);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTMethodResolver methodResolver = new DefaultDTMethodResolver();
        ISymbol[] symbols = methodResolver.getMethods((IObjectSymbol)symbol);
        TestDefaultDTMethodResolver.assertNotNull((Object)symbols);
        TestDefaultDTMethodResolver.assertEquals((int)11, (int)symbols.length);
        this.assertContains(symbols, "actionMethod", "()Ljava.lang.String;");
        this.assertContains(symbols, "actionMethodWithParam", "(Ljava.lang.String;)Ljava.lang.String;");
    }

    private void assertContains(ISymbol[] methods, String name, String signature) {
        IMethodSymbol methodSymbol = null;
        ISymbol[] iSymbolArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol symbol = iSymbolArray[n2];
            if (name.equals(symbol.getName())) {
                TestDefaultDTMethodResolver.assertTrue((boolean)(symbol instanceof IMethodSymbol));
                if (((IMethodSymbol)symbol).getSignature().equals(signature)) {
                    methodSymbol = (IMethodSymbol)symbol;
                }
            }
            ++n2;
        }
        TestDefaultDTMethodResolver.assertNotNull(methodSymbol);
    }
}

