/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavadocCompletionModelTest;

public class JavadocTypeCompletionModelTest
extends AbstractJavadocCompletionModelTest {
    public JavadocTypeCompletionModelTest(String name) {
        super(name);
    }

    public static Test suite() {
        return JavadocTypeCompletionModelTest.buildModelTestSuite(JavadocTypeCompletionModelTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setUpProjectOptions("1.4");
    }

    public void test001() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion on empty tag name:\n * \t@\n */\npublic class Test {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/Test.js", source, true, "@");
        this.assertResults("author[JSDOC_BLOCK_TAG]{@author, null, null, author, null, " + this.positions + 8 + "}\n" + "deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}\n" + "see[JSDOC_BLOCK_TAG]{@see, null, null, see, null, " + this.positions + 8 + "}\n" + "version[JSDOC_BLOCK_TAG]{@version, null, null, version, null, " + this.positions + 8 + "}\n" + "category[JSDOC_BLOCK_TAG]{@category, null, null, category, null, " + this.positions + 8 + "}\n" + "since[JSDOC_BLOCK_TAG]{@since, null, null, since, null, " + this.positions + 8 + "}\n" + "serial[JSDOC_BLOCK_TAG]{@serial, null, null, serial, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void test002() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion on impossible tag name:\n * \t@par\n */\npublic class Test {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/Test.js", source, true, "@par");
        this.assertResults("");
    }

    public void test003() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion on one letter:\n * \t@v\n */\npublic class Test {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/Test.js", source, true, "@v");
        this.assertResults("version[JSDOC_BLOCK_TAG]{@version, null, null, version, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void test004() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion with several letters:\n * \t@deprec\n */\npublic class Test {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/Test.js", source, true, "@deprec");
        this.assertResults("deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}");
    }

    public void test005() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion on full tag name:\n * \t@link\n */\npublic class Test {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/Test.js", source, true, "@link");
        this.assertResults("link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}");
    }

    public void test006() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion on full tag name:\n * \t@link\n */\npublic class Test {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/Test.js", source, true, "@li");
        this.assertResults("link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}");
    }

    public void test007() throws JavaScriptModelException {
        this.setUpProjectOptions("1.3");
        String source = "package javadoc.types;\n/**\n * Completion on empty tag name:\n * \t@\n */\n// Note: this test should be done using compliance 1.3\npublic class Test {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/Test.js", source, true, "@");
        this.assertResults("author[JSDOC_BLOCK_TAG]{@author, null, null, author, null, " + this.positions + 8 + "}\n" + "deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}\n" + "see[JSDOC_BLOCK_TAG]{@see, null, null, see, null, " + this.positions + 8 + "}\n" + "version[JSDOC_BLOCK_TAG]{@version, null, null, version, null, " + this.positions + 8 + "}\n" + "category[JSDOC_BLOCK_TAG]{@category, null, null, category, null, " + this.positions + 8 + "}\n" + "since[JSDOC_BLOCK_TAG]{@since, null, null, since, null, " + this.positions + 8 + "}\n" + "serial[JSDOC_BLOCK_TAG]{@serial, null, null, serial, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}");
    }

    public void test008() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types;\n/**\n * Completion on empty tag name:\n * \t@\n */\n// Note: this test should be done using compliance 1.5\npublic class Test<T> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/Test.js", source, true, "@");
        this.assertResults("author[JSDOC_BLOCK_TAG]{@author, null, null, author, null, " + this.positions + 8 + "}\n" + "deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}\n" + "param[JSDOC_BLOCK_TAG]{@param, null, null, param, null, " + this.positions + 8 + "}\n" + "see[JSDOC_BLOCK_TAG]{@see, null, null, see, null, " + this.positions + 8 + "}\n" + "version[JSDOC_BLOCK_TAG]{@version, null, null, version, null, " + this.positions + 8 + "}\n" + "category[JSDOC_BLOCK_TAG]{@category, null, null, category, null, " + this.positions + 8 + "}\n" + "since[JSDOC_BLOCK_TAG]{@since, null, null, since, null, " + this.positions + 8 + "}\n" + "serial[JSDOC_BLOCK_TAG]{@serial, null, null, serial, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}\n" + "code[JSDOC_INLINE_TAG]{{@code}, null, null, code, null, " + this.positions + 8 + "}\n" + "literal[JSDOC_INLINE_TAG]{{@literal}, null, null, literal, null, " + this.positions + 8 + "}");
    }

    public void test010() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see Obj\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "Obj");
        this.assertResults("Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 21 + "}");
    }

    public void test011() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTest\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BasicTest");
        this.assertResults("BasicTestTypes[TYPE_REF]{BasicTestTypes, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes;, null, null, " + this.positions + 21 + "}\n" + "BasicTestReferences[TYPE_REF]{org.eclipse.wst.jsdt.core.tests.BasicTestReferences, org.eclipse.wst.jsdt.core.tests, Lorg.eclipse.wst.jsdt.core.tests.BasicTestReferences;, null, null, " + this.positions + 18 + "}");
    }

    public void test012() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTestTypes\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BasicTest");
        this.assertResults("BasicTestTypes[TYPE_REF]{BasicTestTypes, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes;, null, null, " + this.positions + 21 + "}\n" + "BasicTestReferences[TYPE_REF]{org.eclipse.wst.jsdt.core.tests.BasicTestReferences, org.eclipse.wst.jsdt.core.tests, Lorg.eclipse.wst.jsdt.core.tests.BasicTestReferences;, null, null, " + this.positions + 18 + "}");
    }

    public void test013() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTest\n */\npublic class BasicTestTypes<TPARAM> {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BasicTest");
        this.assertResults("BasicTestTypes<TPARAM>[TYPE_REF]{BasicTestTypes, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes<TTPARAM;>;, null, null, " + this.positions + 21 + "}\n" + "BasicTestReferences[TYPE_REF]{org.eclipse.wst.jsdt.core.tests.BasicTestReferences, org.eclipse.wst.jsdt.core.tests, Lorg.eclipse.wst.jsdt.core.tests.BasicTestReferences;, null, null, " + this.positions + 18 + "}");
    }

    public void test014() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see javadoc.types.tags.BasicTest\n * \t\tNote: JDT-UI failed on this one\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "javadoc.types.tags.BasicTest");
        this.assertResults("BasicTestTypes[TYPE_REF]{BasicTestTypes, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes;, null, null, " + this.positions + 18 + "}");
    }

    public void test015() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see javadoc.types.tags.BasicTest\n * \t\tNote: JDT-UI failed on this one\n */\npublic class BasicTestTypes<TPARAM> {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "javadoc.types.tags.BasicTest");
        this.assertResults("BasicTestTypes<TPARAM>[TYPE_REF]{BasicTestTypes, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes<TTPARAM;>;, null, null, " + this.positions + 18 + "}");
    }

    public void test016() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see java.la\n * \t\tNote: JDT-UI fails on this one\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "java.la");
        this.assertResults("java.lang[PACKAGE_REF]{java.lang, java.lang, null, null, null, " + this.positions + 20 + "}");
    }

    public void test017() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see java.lang\n * \t\tNote: JDT-UI fails on this one\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "java.la");
        this.assertResults("java.lang[PACKAGE_REF]{java.lang, java.lang, null, null, null, " + this.positions + 20 + "}");
    }

    public void test018() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see pack.Bin\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "pack.Bin");
        this.assertSortedResults("Bin1[TYPE_REF]{pack.Bin1, pack, Lpack.Bin1;, null, null, " + this.positions + 20 + "}\n" + "Bin2[TYPE_REF]{pack.Bin2, pack, Lpack.Bin2;, null, null, " + this.positions + 20 + "}\n" + "Bin3[TYPE_REF]{pack.Bin3, pack, Lpack.Bin3;, null, null, " + this.positions + 20 + "}");
    }

    public void test019() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see pack.Bin2\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "pack.Bin");
        this.assertSortedResults("Bin1[TYPE_REF]{pack.Bin1, pack, Lpack.Bin1;, null, null, " + this.positions + 20 + "}\n" + "Bin2[TYPE_REF]{pack.Bin2, pack, Lpack.Bin2;, null, null, " + this.positions + 20 + "}\n" + "Bin3[TYPE_REF]{pack.Bin3, pack, Lpack.Bin3;, null, null, " + this.positions + 20 + "}");
    }

    public void test020() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see pack.Bin2\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "pack.Bin2");
        this.assertSortedResults("Bin2[TYPE_REF]{pack.Bin2, pack, Lpack.Bin2;, null, null, " + this.positions + 24 + "}");
    }

    public void test021() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see I\n * \t\tNote: completion list shoud not include base types.\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "I");
        this.assertSortedResults("IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 21 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 21 + "}");
    }

    public void test022() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see java.lang.\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "java.lang.");
        this.assertSortedResults("java.lang.annotation[PACKAGE_REF]{java.lang.annotation, java.lang.annotation, null, null, null, " + this.positions + 20 + "}\n" + "CharSequence[TYPE_REF]{CharSequence, java.lang, Ljava.lang.CharSequence;, null, null, " + this.positions + 18 + "}\n" + "Class[TYPE_REF]{Class, java.lang, Ljava.lang.Class;, null, null, " + this.positions + 18 + "}\n" + "CloneNotSupportedException[TYPE_REF]{CloneNotSupportedException, java.lang, Ljava.lang.CloneNotSupportedException;, null, null, " + this.positions + 18 + "}\n" + "Comparable[TYPE_REF]{Comparable, java.lang, Ljava.lang.Comparable;, null, null, " + this.positions + 18 + "}\n" + "Enum[TYPE_REF]{Enum, java.lang, Ljava.lang.Enum;, null, null, " + this.positions + 18 + "}\n" + "Error[TYPE_REF]{Error, java.lang, Ljava.lang.Error;, null, null, " + this.positions + 18 + "}\n" + "Exception[TYPE_REF]{Exception, java.lang, Ljava.lang.Exception;, null, null, " + this.positions + 18 + "}\n" + "IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 18 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 18 + "}\n" + "Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 18 + "}\n" + "RuntimeException[TYPE_REF]{RuntimeException, java.lang, Ljava.lang.RuntimeException;, null, null, " + this.positions + 18 + "}\n" + "String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 18 + "}\n" + "Throwable[TYPE_REF]{Throwable, java.lang, Ljava.lang.Throwable;, null, null, " + this.positions + 18 + "}");
    }

    public void test023() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see java.\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "java.");
        this.assertResults("java.lang[PACKAGE_REF]{java.lang, java.lang, null, null, null, " + this.positions + 20 + "}\n" + "java.io[PACKAGE_REF]{java.io, java.io, null, null, null, " + this.positions + 20 + "}");
    }

    public void test024() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see java.lang\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "java.");
        this.assertResults("java.lang.annotation[PACKAGE_REF]{java.lang.annotation, java.lang.annotation, null, null, null, " + this.positions + 20 + "}\n" + "java.lang[PACKAGE_REF]{java.lang, java.lang, null, null, null, " + this.positions + 20 + "}\n" + "java.io[PACKAGE_REF]{java.io, java.io, null, null, null, " + this.positions + 20 + "}");
    }

    public void test025() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see java.lang.Obj\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "java.lang.");
        this.assertSortedResults("Class[TYPE_REF]{Class, java.lang, Ljava.lang.Class;, null, null, " + this.positions + 18 + "}\n" + "CloneNotSupportedException[TYPE_REF]{CloneNotSupportedException, java.lang, Ljava.lang.CloneNotSupportedException;, null, null, " + this.positions + 18 + "}\n" + "Error[TYPE_REF]{Error, java.lang, Ljava.lang.Error;, null, null, " + this.positions + 18 + "}\n" + "Exception[TYPE_REF]{Exception, java.lang, Ljava.lang.Exception;, null, null, " + this.positions + 18 + "}\n" + "IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 18 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 18 + "}\n" + "Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 18 + "}\n" + "RuntimeException[TYPE_REF]{RuntimeException, java.lang, Ljava.lang.RuntimeException;, null, null, " + this.positions + 18 + "}\n" + "String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 18 + "}\n" + "Throwable[TYPE_REF]{Throwable, java.lang, Ljava.lang.Throwable;, null, null, " + this.positions + 18 + "}");
    }

    public void test026() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see java.lang.Objec\n */\npublic class BasicTestTypes {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "java.lang.Ob");
        this.assertResults("Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 18 + "}");
    }

    public void test030() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTestTypesM\n */\npublic class BasicTestTypes {\n\tclass BasicTestTypesMember {}\n}\nclass BasicTestTypesTestSecondary {}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BasicTestTypesM");
        this.assertResults("BasicTestTypes.BasicTestTypesMember[TYPE_REF]{BasicTestTypesMember, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes$BasicTestTypesMember;, null, null, " + this.positions + 21 + "}");
    }

    public void test031() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTestTypesMember\n */\npublic class BasicTestTypes {\n\tclass BasicTestTypesMember {}\n}\nclass BasicTestTypesSecondary {}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BasicTestTypesM");
        this.assertResults("BasicTestTypes.BasicTestTypesMember[TYPE_REF]{BasicTestTypesMember, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes$BasicTestTypesMember;, null, null, " + this.positions + 21 + "}");
    }

    public void test032() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTestTypes.BasicTestTypesM\n */\npublic class BasicTestTypes {\n\tclass BasicTestTypesMember {}\n}\nclass BasicTestTypesSecondary {}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BasicTestTypesM");
        this.assertResults("BasicTestTypes.BasicTestTypesMember[TYPE_REF]{BasicTestTypesMember, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes$BasicTestTypesMember;, null, null, " + this.positions + 18 + "}");
    }

    public void test033() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see javadoc.types.tags.BasicTestTypes.BasicTestTypesM\n */\npublic class BasicTestTypes {\n\tclass BasicTestTypesMember {}\n}\nclass BasicTestTypesSecondary {}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BasicTestTypesM");
        this.assertResults("BasicTestTypes.BasicTestTypesMember[TYPE_REF]{BasicTestTypesMember, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes$BasicTestTypesMember;, null, null, " + this.positions + 18 + "}");
    }

    public void test034() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTestTypesS\n */\npublic class BasicTestTypes {\n}\nclass BasicTestTypesSecondary {}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BasicTestTypesS");
        this.assertResults("BasicTestTypesSecondary[TYPE_REF]{BasicTestTypesSecondary, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypesSecondary;, null, null, " + this.positions + 21 + "}");
    }

    public void test035() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see javadoc.types.tags.BasicTestTypesS\n */\npublic class BasicTestTypes {\n}\nclass BasicTestTypesSecondary {}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "javadoc.types.tags.BasicTestTypesS");
        this.assertResults("BasicTestTypesSecondary[TYPE_REF]{BasicTestTypesSecondary, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypesSecondary;, null, null, " + this.positions + 18 + "}");
    }

    public void test036() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see javadoc.types.tags.BasicTestTypesSecondary\n */\npublic class BasicTestTypes {\n}\nclass BasicTestTypesSecondary {}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "javadoc.types.tags.BasicTestTypesS");
        this.assertResults("BasicTestTypesSecondary[TYPE_REF]{BasicTestTypesSecondary, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypesSecondary;, null, null, " + this.positions + 18 + "}");
    }

    public void test037() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see javadoc.types.tags.BasicTestTypes.BasicTestTypes\n */\npublic class BasicTestTypes {\n}\nclass BasicTestTypesSecondary {}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "javadoc.types.tags.BasicTestTypes.BasicTestTypes");
        this.assertResults("");
    }

    public void test040() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTestReferences#FIE\n * \t\tNote: JDT/UI create one proposal on this one\n */\npublic class BasicTestTypes {\n}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "FIE");
        this.assertResults("");
    }

    public void test041() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see org.eclipse.wst.jsdt.core.tests.BasicTestReferences#FIE\n */\npublic class BasicTestTypes {\n}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "FIE");
        this.assertResults("FIELD[FIELD_REF]{FIELD, Lorg.eclipse.wst.jsdt.core.tests.BasicTestReferences;, I, FIELD, null, " + this.positions + 18 + "}");
    }

    public void test042() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see org.eclipse.wst.jsdt.core.tests.BasicTestReferences#FIELD\n */\npublic class BasicTestTypes {\n}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "FIE");
        this.assertResults("FIELD[FIELD_REF]{FIELD, Lorg.eclipse.wst.jsdt.core.tests.BasicTestReferences;, I, FIELD, null, " + this.positions + 18 + "}");
    }

    public void test043() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see #fo\n */\npublic class BasicTestTypes {\n\tint foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "fo");
        this.assertResults("foo[FIELD_REF]{foo, Ljavadoc.types.tags.BasicTestTypes;, I, foo, null, " + this.positions + 29 + "}");
    }

    public void test044() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see #foo\n */\npublic class BasicTestTypes {\n\tint foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "fo");
        this.assertResults("foo[FIELD_REF]{foo, Ljavadoc.types.tags.BasicTestTypes;, I, foo, null, " + this.positions + 29 + "}");
    }

    public void test045() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/types/tags/BasicTestTypes.js", "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see OtherTypes#fo\n */\npublic class BasicTestTypes {\n}", "/Completion/src/javadoc/types/tags/OtherTypes.js", "package javadoc.types.tags;\npublic class OtherTypes {\n\tint foo;\n}"};
        this.completeInJavadoc(sources, true, "fo");
        this.assertResults("foo[FIELD_REF]{foo, Ljavadoc.types.tags.OtherTypes;, I, foo, null, " + this.positions + 29 + "}");
    }

    public void test050() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTestMethod.meth\n * \t\tNote that test result may change if bug https://bugs.eclipse.org/bugs/show_bug.cgi?id=26814 was fixed\n */\npublic class BasicTestTypes {\n\tvoid method() {}\n\tvoid paramMethod(String str, int x, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "meth");
        this.assertResults("");
    }

    public void test051() throws JavaScriptModelException {
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BasicTestMethod#unknown\n * \t\t- completion list shoud be empty\n */\npublic class BasicTestTypes {\n\tvoid method() {}\n\tvoid paramMethod(String str, int x, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "unknown");
        this.assertResults("");
    }

    public void test052() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/types/tags/BasicTestTypes.js", "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see OtherTypes#meth\n */\npublic class BasicTestTypes {\n}", "/Completion/src/javadoc/types/tags/OtherTypes.js", "package javadoc.types.tags;\npublic class OtherTypes {\n\tvoid method() {};\n}"};
        this.completeInJavadoc(sources, true, "meth");
        this.assertResults("method[FUNCTION_REF]{method(), Ljavadoc.types.tags.OtherTypes;, ()V, method, null, " + this.positions + 29 + "}");
    }

    public void test053() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/types/tags/BasicTestTypes.js", "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see OtherTypes#method\n */\npublic class BasicTestTypes {\n}", "/Completion/src/javadoc/types/tags/OtherTypes.js", "package javadoc.types.tags;\npublic class OtherTypes {\n\tvoid method() {};\n}"};
        this.completeInJavadoc(sources, true, "meth");
        this.assertResults("method[FUNCTION_REF]{method(), Ljavadoc.types.tags.OtherTypes;, ()V, method, null, " + this.positions + 29 + "}");
    }

    public void test060() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param \n */\npublic class BasicTestTypes<TPARAM> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "@param ", 0);
        this.assertResults("TPARAM[JSDOC_PARAM_REF]{<TPARAM>, null, null, TPARAM, null, " + this.positions + 8 + "}");
    }

    public void test061() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <\n * \tNote:\n * \t\tJDT/UI fails on this one (no proposal)\n */\npublic class BasicTestTypes<TPARAM> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<");
        this.assertResults("TPARAM[JSDOC_PARAM_REF]{<TPARAM>, null, null, TPARAM, null, " + this.positions + 8 + "}");
    }

    public void test062() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <TPA\n * \tNote:\n * \t\tJDT/UI fails on this one (no proposal)\n */\npublic class BasicTestTypes<TPARAM> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<TPA");
        this.assertResults("TPARAM[JSDOC_PARAM_REF]{<TPARAM>, null, null, TPARAM, null, " + this.positions + 8 + "}");
    }

    public void test063() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <TPARAM\n * \tNote:\n * \t\tJDT/UI fails on this one (no proposal)\n */\npublic class BasicTestTypes<TPARAM> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<TPA");
        this.assertResults("TPARAM[JSDOC_PARAM_REF]{<TPARAM>, null, null, TPARAM, null, " + this.positions + 8 + "}");
    }

    public void test064() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <TPARAM\n * \tNote:\n * \t\tJDT/UI fails on this one (no proposal)\n */\npublic class BasicTestTypes<TPARAM> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<TPARAM");
        this.assertResults("TPARAM[JSDOC_PARAM_REF]{<TPARAM>, null, null, TPARAM, null, " + this.positions + 8 + "}");
    }

    public void test065() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <TPARAM>\n * \tNote:\n * \t\tJDT/UI fails on this one (no proposal)\n */\npublic class BasicTestTypes<TPARAM> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<TPARAM");
        this.assertResults("TPARAM[JSDOC_PARAM_REF]{<TPARAM>, null, null, TPARAM, null, " + this.positions + 8 + "}");
    }

    public void test066() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <TPARAM>\n * \tNote:\n * \t\tJDT/UI fails on this one (no proposal)\n */\npublic class BasicTestTypes<TPARAM> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<TPARAM>");
        this.assertResults("TPARAM[JSDOC_PARAM_REF]{<TPARAM>, null, null, TPARAM, null, " + this.positions + 8 + "}");
    }

    public void test067() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <T1>\n * \t@param <T1>\n */\npublic class BasicTestTypes<T1, T2, T3> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<T1>");
        this.assertResults("");
    }

    public void test068() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <T1>\n * \t@param <T1>\n */\npublic class BasicTestTypes<T1, T2, T3> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<T1>", 2);
        this.assertResults("");
    }

    public void test069() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <T1>\n ** \t@param \n * \t@param <T3>\n */\npublic class BasicTestTypes<T1, T2, T3> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "** \t@param ", 0);
        this.assertResults("T2[JSDOC_PARAM_REF]{<T2>, null, null, T2, null, " + this.positions + 8 + "}");
    }

    public void test070() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <T1>\n * \t@param <T2>\n * \t@param <T3>\n */\npublic class BasicTestTypes<T1, T2, T3> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "<T", 3);
        this.assertResults("T3[JSDOC_PARAM_REF]{<T3>, null, null, T3, null, " + this.positions + 8 + "}");
    }

    public void test071() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@param <T1>\n * \t@param <T2>\n * \t@param <T3>\n ** \t@param \n */\npublic class BasicTestTypes<T1, T2, T3> {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "** \t@param ", 0);
        this.assertResults("");
    }

    public void test080() throws JavaScriptModelException {
        this.oldOptions = JavaScriptCore.getOptions();
        try {
            Hashtable<String, String> options = new Hashtable<String, String>(this.oldOptions);
            options.put("org.eclipse.wst.jsdt.core.codeComplete.camelCaseMatch", "enabled");
            JavaScriptCore.setOptions(options);
            String source = "package javadoc.types.tags;\n/**\n * Completion after:\n * \t@see BTT\n */\npublic class BasicTestTypes {}\n";
            this.completeInJavadoc("/Completion/src/javadoc/types/tags/BasicTestTypes.js", source, true, "BTT");
            this.assertResults("BasicTestTypes[TYPE_REF]{BasicTestTypes, javadoc.types.tags, Ljavadoc.types.tags.BasicTestTypes;, null, null, " + this.positions + "16}");
        }
        finally {
            JavaScriptCore.setOptions((Hashtable)this.oldOptions);
        }
    }

    public void test100() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasi bla\n */\npublic class ZBasicTestTypes {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasi", 1, new int[0]);
        this.assertResults("ZBasicTestTypes[TYPE_REF]{ZBasicTestTypes, javadoc.types, Ljavadoc.types.ZBasicTestTypes;, null, null, " + this.positions + 21 + "}\n" + "ZBasicTestTypes[JSDOC_TYPE_REF]{{@link ZBasicTestTypes}, javadoc.types, Ljavadoc.types.ZBasicTestTypes;, null, null, " + this.positions + 52 + "}");
    }

    public void test101() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasi bla\n */\npublic class ZBasicTestTypes {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasi", 1, new int[]{16});
        this.assertResults("ZBasicTestTypes[TYPE_REF]{ZBasicTestTypes, javadoc.types, Ljavadoc.types.ZBasicTestTypes;, null, null, " + this.positions + 21 + "}");
    }

    public void test102() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasi bla\n */\npublic class ZBasicTestTypes {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasi", 1, new int[]{9});
        this.assertResults("ZBasicTestTypes[JSDOC_TYPE_REF]{{@link ZBasicTestTypes}, javadoc.types, Ljavadoc.types.ZBasicTestTypes;, null, null, " + this.positions + 52 + "}");
    }

    public void test103() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasicTestTypes#fo bla\n */\npublic class ZBasicTestTypes {\n  public void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasicTestTypes#fo", 1, new int[0]);
        this.assertResults("foo[JSDOC_METHOD_REF]{{@link ZBasicTestTypes#foo()}, Ljavadoc.types.ZBasicTestTypes;, ()V, foo, null, " + this.positions + 60 + "}");
    }

    public void test104() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasicTestTypes#fo bla\n */\npublic class ZBasicTestTypes {\n  public void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasicTestTypes#fo", 1, new int[]{15});
        this.assertResults("");
    }

    public void test105() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasicTestTypes#fo bla\n */\npublic class ZBasicTestTypes {\n  public void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasicTestTypes#fo", 1, new int[]{6});
        this.assertResults("foo[JSDOC_METHOD_REF]{{@link ZBasicTestTypes#foo()}, Ljavadoc.types.ZBasicTestTypes;, ()V, foo, null, " + this.positions + 60 + "}");
    }

    public void test106() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasicTestTypes#fo bla\n */\npublic class ZBasicTestTypes {\n  public int foo;\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasicTestTypes#fo", 1, new int[0]);
        this.assertResults("foo[JSDOC_FIELD_REF]{{@link ZBasicTestTypes#foo}, Ljavadoc.types.ZBasicTestTypes;, I, foo, null, " + this.positions + 60 + "}");
    }

    public void test107() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasicTestTypes#fo bla\n */\npublic class ZBasicTestTypes {\n  public int foo;\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasicTestTypes#fo", 1, new int[]{14});
        this.assertResults("");
    }

    public void test108() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla ZBasicTestTypes#fo bla\n */\npublic class ZBasicTestTypes {\n  public int foo;\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "ZBasicTestTypes#fo", 1, new int[]{2});
        this.assertResults("foo[JSDOC_FIELD_REF]{{@link ZBasicTestTypes#foo}, Ljavadoc.types.ZBasicTestTypes;, I, foo, null, " + this.positions + 60 + "}");
    }

    public void test109() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla javadoc.types.ZBasi bla\n */\npublic class ZBasicTestTypes {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "javadoc.types.ZBasi", 1, new int[0]);
        this.assertResults("ZBasicTestTypes[TYPE_REF]{ZBasicTestTypes, javadoc.types, Ljavadoc.types.ZBasicTestTypes;, null, null, " + this.positions + 18 + "}\n" + "ZBasicTestTypes[JSDOC_TYPE_REF]{{@link ZBasicTestTypes}, javadoc.types, Ljavadoc.types.ZBasicTestTypes;, null, null, " + this.positions + 49 + "}");
    }

    public void test110() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla javadoc.types.ZBasi bla\n */\npublic class ZBasicTestTypes {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "javadoc.types.ZBasi", 1, new int[]{16});
        this.assertResults("ZBasicTestTypes[TYPE_REF]{ZBasicTestTypes, javadoc.types, Ljavadoc.types.ZBasicTestTypes;, null, null, " + this.positions + 18 + "}");
    }

    public void test111() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla javadoc.types.ZBasi bla\n */\npublic class ZBasicTestTypes {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "javadoc.types.ZBasi", 1, new int[]{9});
        this.assertResults("ZBasicTestTypes[JSDOC_TYPE_REF]{{@link ZBasicTestTypes}, javadoc.types, Ljavadoc.types.ZBasicTestTypes;, null, null, " + this.positions + 49 + "}");
    }

    public void test112() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla javadoc.types.ZBasicTestTypes.Inn bla\n */\npublic class ZBasicTestTypes {\n  public class Inner {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "javadoc.types.ZBasicTestTypes.Inn", 1, new int[0]);
        this.assertResults("ZBasicTestTypes.Inner[TYPE_REF]{Inner, javadoc.types, Ljavadoc.types.ZBasicTestTypes$Inner;, null, null, " + this.positions + 18 + "}\n" + "ZBasicTestTypes.Inner[JSDOC_TYPE_REF]{{@link Inner}, javadoc.types, Ljavadoc.types.ZBasicTestTypes$Inner;, null, null, " + this.positions + 49 + "}");
    }

    public void test113() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla javadoc.types.ZBasicTestTypes.Inn bla\n */\npublic class ZBasicTestTypes {\n  public class Inner {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "javadoc.types.ZBasicTestTypes.Inn", 1, new int[]{16});
        this.assertResults("ZBasicTestTypes.Inner[TYPE_REF]{Inner, javadoc.types, Ljavadoc.types.ZBasicTestTypes$Inner;, null, null, " + this.positions + 18 + "}");
    }

    public void test114() throws JavaScriptModelException {
        String source = "package javadoc.types;\n/**\n * Completion after:\n * \tbla javadoc.types.ZBasicTestTypes.Inn bla\n */\npublic class ZBasicTestTypes {\n  public class Inner {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/types/ZBasicTestTypes.js", source, true, "javadoc.types.ZBasicTestTypes.Inn", 1, new int[]{9});
        this.assertResults("ZBasicTestTypes.Inner[JSDOC_TYPE_REF]{{@link Inner}, javadoc.types, Ljavadoc.types.ZBasicTestTypes$Inner;, null, null, " + this.positions + 49 + "}");
    }
}

