/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ImageDescriptorRegistry {
    private HashMap fRegistry = new HashMap(10);
    private Display fDisplay;

    public ImageDescriptorRegistry() {
        this(PlatformUI.getWorkbench().getDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        this.fDisplay = display;
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        ImageDescriptor desc = descriptor;
        if (desc == null) {
            desc = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.fRegistry.get(desc)) != null) {
            return result;
        }
        result = desc.createImage();
        if (result != null) {
            this.fRegistry.put(desc, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageDescriptorRegistry.this.fDisplay.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageDescriptorRegistry.this.dispose();
                    }
                });
            }
        });
    }
}

