/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMAbstractNumberBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMDoubleClassBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMDoubleClassBeanTypeProxy
extends REMAbstractNumberBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;

    REMDoubleClassBeanTypeProxy(REMProxyFactoryRegistry aRegistry, IBeanTypeProxy numberType) {
        super(aRegistry, new Integer(10), Double.class.getName(), numberType);
        this.zeroProxy = new REMDoubleClassBeanProxy(aRegistry, new Double(0.0));
    }

    INumberBeanProxy createDoubleBeanProxy(Double aDouble) {
        return aDouble != 0.0 ? new REMDoubleClassBeanProxy(this.fRegistry, aDouble) : this.zeroProxy;
    }

    @Override
    protected INumberBeanProxy createNumberBeanProxy(Number aNumber) {
        return this.createDoubleBeanProxy((Double)aNumber);
    }

    @Override
    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    @Override
    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createDoubleBeanProxy(new Double(value.aDouble));
    }
}

