/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests.adaptdom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.tests.adaptdom.AdapterForAttrTestOnly;
import org.eclipse.wst.sse.core.tests.adaptdom.AdapterForDocumentTestOnly;
import org.eclipse.wst.sse.core.tests.adaptdom.AdapterForElementTestOnly;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdapterFactoryTestOnly
implements INodeAdapterFactory {
    List adapters = new ArrayList();

    public AdapterFactoryTestOnly() {
        this.adapters.add(new AdapterForDocumentTestOnly());
        this.adapters.add(new AdapterForElementTestOnly());
        this.adapters.add(new AdapterForAttrTestOnly());
    }

    public INodeAdapter adapt(INodeNotifier target) {
        INodeAdapter result = null;
        for (INodeAdapter adapter : this.adapters) {
            INodeAdapter existingAdapter;
            if (!adapter.isAdapterForType((Object)target) || (existingAdapter = target.getExistingAdapter((Object)adapter)) != null) continue;
            target.addAdapter(adapter);
            result = adapter;
        }
        return result;
    }

    public boolean isFactoryForType(Object type) {
        boolean result = false;
        if (type instanceof Document) {
            result = true;
        } else if (type instanceof Element) {
            result = true;
        } else if (type instanceof Attr) {
            result = true;
        }
        return result;
    }

    public void release() {
    }

    public INodeAdapterFactory copy() {
        return new AdapterFactoryTestOnly();
    }
}

