/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.WsSerializerAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer.SerializerAdapterTestFixture;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsSerializerAdapterTest
extends SerializerAdapterTestFixture {
    public void testCreateIAnnotationIWebServiceNpe() throws JavaModelException {
        try {
            new MyWsSerializerAdapter(this.resource).createIAnnotation(null, this.project.getJavaProject().getJavaModel());
            WsSerializerAdapterTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            new MyWsSerializerAdapter(this.resource).createIAnnotation(this.ws, null);
            WsSerializerAdapterTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void testCreateIAnnotationIWebServiceExplicit() throws JavaModelException {
        IAnnotation<? extends IJavaElement> annotation = new MyWsSerializerAdapter(this.resource).createIAnnotation(this.ws, this.project.getJavaProject().getJavaModel());
        WsSerializerAdapterTest.assertEquals((int)5, (int)annotation.getParamValuePairs().size());
        WsSerializerAdapterTest.checkIWebServiceIAnnotation(annotation);
        WsSerializerAdapterTest.assertNotNull((Object)annotation.getPropertyValue("endpointInterface"));
        WsSerializerAdapterTest.assertEquals((String)this.implBeanType.getFullyQualifiedName(), (String)((IType)annotation.getAppliedElement()).getFullyQualifiedName());
    }

    public void testCreateIAnnotationIWebServiceImplicit() throws JavaModelException {
        IAnnotation<? extends IJavaElement> annotation = new MyWsSerializerAdapter(this.resource).createIAnnotation(this.wsImplicit, this.project.getJavaProject().getJavaModel());
        WsSerializerAdapterTest.assertEquals((int)5, (int)annotation.getParamValuePairs().size());
        WsSerializerAdapterTest.checkIWebServiceIAnnotation(annotation);
        WsSerializerAdapterTest.assertEquals((String)"ImplicitName", (String)annotation.getPropertyValue("name"));
        WsSerializerAdapterTest.assertEquals((String)this.implBeanImplicit.getFullyQualifiedName(), (String)((IType)annotation.getAppliedElement()).getFullyQualifiedName());
    }

    public void testCreateIAnnotationIWebServiceDefault() throws JavaModelException {
        this.resource.disableSaving();
        this.wsImplicit.getServiceEndpoint().setName("ImplicitImplBean");
        this.wsImplicit.setName("ImplicitImplBeanService");
        this.wsImplicit.setPortName("ImplicitImplBeanPort");
        this.wsImplicit.setTargetNamespace("http://test/");
        this.wsImplicit.setWsdlLocation(null);
        IAnnotation<? extends IJavaElement> annotation = new MyWsSerializerAdapter(this.resource).createIAnnotation(this.wsImplicit, this.project.getJavaProject().getJavaModel());
        WsSerializerAdapterTest.assertEquals((int)0, (int)annotation.getParamValuePairs().size());
    }

    public void testSaveAnnotation() throws JavaModelException {
        this.resource.getSerializerFactory().adapt((Notifier)this.ws, IAnnotationSerializer.class);
        this.ws.setName("ChangedService");
        IAnnotationInspector inspector = AnnotationFactory.createAnnotationInspector((IType)this.implBeanType);
        IAnnotation found = inspector.inspectType("javax.jws.WebService");
        WsSerializerAdapterTest.assertNotNull((Object)found);
        WsSerializerAdapterTest.assertEquals((String)"ChangedService", (String)found.getPropertyValue("serviceName"));
        WsSerializerAdapterTest.assertEquals((String)"MyPort", (String)found.getPropertyValue("portName"));
        WsSerializerAdapterTest.assertEquals((String)"http://com.sap/test", (String)found.getPropertyValue("targetNamespace"));
        WsSerializerAdapterTest.assertEquals((String)"C:/test/wsdl/location", (String)found.getPropertyValue("wsdlLocation"));
    }

    public static void checkIWebServiceIAnnotation(IAnnotation<? extends IJavaElement> annotation) {
        boolean[] found = new boolean[4];
        String[] params = new String[]{"serviceName", "portName", "targetNamespace", "wsdlLocation"};
        for (IParamValuePair paramValuePair : annotation.getParamValuePairs()) {
            String param = paramValuePair.getParam();
            if (param.equals("serviceName")) {
                WsSerializerAdapterTest.assertEquals((String)"MyService", (String)paramValuePair.getValue().toString());
                found[0] = true;
            }
            if (param.equals("portName")) {
                WsSerializerAdapterTest.assertEquals((String)"MyPort", (String)paramValuePair.getValue().toString());
                found[1] = true;
            }
            if (param.equals("targetNamespace")) {
                WsSerializerAdapterTest.assertEquals((String)"http://com.sap/test", (String)paramValuePair.getValue().toString());
                found[2] = true;
            }
            if (!param.equals("wsdlLocation")) continue;
            WsSerializerAdapterTest.assertEquals((String)"C:/test/wsdl/location", (String)paramValuePair.getValue().toString());
            found[3] = true;
        }
        int i = 0;
        while (i < found.length) {
            WsSerializerAdapterTest.assertTrue((String)("Annotation param " + params[i] + " not found"), (boolean)found[i]);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MyWsSerializerAdapter
    extends WsSerializerAdapter {
        public MyWsSerializerAdapter(JaxWsWorkspaceResource resource) {
            super(resource);
        }

        public IAnnotation<? extends IJavaElement> createIAnnotation(IWebService ws, IJavaModel javaModel) throws JavaModelException {
            return super.createIAnnotation(ws, javaModel);
        }
    }
}

