/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.validation.tests.internal;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.eclipse.XMLValidator;
import org.eclipse.wst.xml.validation.tests.internal.XMLValidatorTestsPlugin;

public class BaseTestCase
extends TestCase {
    protected String FILE_PROTOCOL = "file:///";
    protected String PLUGIN_ABSOLUTE_PATH;
    protected String SAMPLES_DIR = "testresources/samples/";
    protected XMLValidator validator = XMLValidator.getInstance();
    protected XMLValidationConfiguration configuration;

    protected void setUp() throws IOException {
        this.PLUGIN_ABSOLUTE_PATH = String.valueOf(XMLValidatorTestsPlugin.getPluginLocation().toString()) + "/";
        this.configuration = new XMLValidationConfiguration();
        try {
            this.configuration.setFeature("WARN_NO_GRAMMAR", false);
            this.configuration.setFeature("INDICATE_NO_GRAMMAR", 0);
        }
        catch (Exception exception) {
            BaseTestCase.fail((String)"Unable to set the feature on the XML validation configuration.");
        }
    }

    public void runTest(String testfile, List keys, int numErrors, int numWarnings) {
        XMLValidationReport valreport = this.validator.validate(testfile, null, this.configuration);
        ValidationMessage[] valmessages = valreport.getValidationMessages();
        int nummessages = valmessages.length;
        int errorCount = 0;
        int warningCount = 0;
        int i = 0;
        while (i < nummessages) {
            ValidationMessage valmes = valmessages[i];
            String key = valmes.getKey();
            BaseTestCase.assertTrue((String)("The message key " + key + " is not correct."), (boolean)keys.contains(key));
            if (valmes.getSeverity() == 4) {
                ++warningCount;
            } else {
                ++errorCount;
            }
            ++i;
        }
        BaseTestCase.assertEquals((String)(String.valueOf(errorCount) + " errors were reported but " + numErrors + " errors were expected."), (int)numErrors, (int)errorCount);
        BaseTestCase.assertEquals((String)(String.valueOf(warningCount) + " warnings were reported but " + numWarnings + " warnings were expected."), (int)numWarnings, (int)warningCount);
    }
}

