/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.utility.jdt;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;

public class SimpleDeclarationAnnotationAdapterTests
extends AnnotationTestCase {
    public SimpleDeclarationAnnotationAdapterTests(String name) {
        super(name);
    }

    private void createAnnotation(String annotationName) throws Exception {
        this.createAnnotation("annot", annotationName);
    }

    private void createAnnotation(String packageName, String annotationName) throws Exception {
        this.javaProjectTestHarness.createCompilationUnit(packageName, String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " {}");
    }

    public void testAnnotation1() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        SimpleDeclarationAnnotationAdapterTests.assertEquals((String)"annot.Foo", (String)annotation.getTypeName().getFullyQualifiedName());
        SimpleDeclarationAnnotationAdapterTests.assertTrue((boolean)annotation.isMarkerAnnotation());
    }

    public void testAnnotation2() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType("@annot.Foo(1) @annot.Foo(2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        SimpleDeclarationAnnotationAdapterTests.assertEquals((String)"annot.Foo", (String)annotation.getTypeName().getFullyQualifiedName());
        SimpleDeclarationAnnotationAdapterTests.assertTrue((boolean)annotation.isSingleMemberAnnotation());
        Expression value = ((SingleMemberAnnotation)annotation).getValue();
        SimpleDeclarationAnnotationAdapterTests.assertEquals((int)34, (int)value.getNodeType());
        SimpleDeclarationAnnotationAdapterTests.assertEquals((String)"1", (String)((NumberLiteral)value).getToken());
    }

    public void testAnnotation3() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType("annot.Foo", "@Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        SimpleDeclarationAnnotationAdapterTests.assertEquals((String)"Foo", (String)annotation.getTypeName().getFullyQualifiedName());
        SimpleDeclarationAnnotationAdapterTests.assertTrue((boolean)annotation.isMarkerAnnotation());
    }

    public void testAnnotationNull1() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
    }

    public void testAnnotationNull2() throws Exception {
        this.createAnnotation("Foo");
        this.createAnnotation("Fop");
        ICompilationUnit cu = this.createTestType("@annot.Fop");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        this.assertSourceContains("@annot.Fop", cu);
    }

    public void testAnnotationNull3() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        this.assertSourceContains("@annot.Foo", cu);
    }

    public void testRemoveAnnotation1() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType("@annot.Foo");
        this.assertSourceContains("@annot.Foo", cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        aa.removeAnnotation();
        this.assertSourceDoesNotContain("@annot.Foo", cu);
    }

    public void testRemoveAnnotation2() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType("@annot.Foo(1) @annot.Foo(2)");
        this.assertSourceContains("@annot.Foo(1) @annot.Foo(2)", cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        aa.removeAnnotation();
        this.assertSourceDoesNotContain("@annot.Foo(1)", cu);
        this.assertSourceContains("@annot.Foo(2)", cu);
    }

    public void testNewMarkerAnnotation1() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain("import annot.Foo;", cu);
        this.assertSourceDoesNotContain("@Foo", cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        aa.newMarkerAnnotation();
        this.assertSourceContains("import annot.Foo;", cu);
        this.assertSourceContains("@Foo", cu);
    }

    public void testNewMarkerAnnotation2() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType("@annot.Foo(88)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        aa.newMarkerAnnotation();
        this.assertSourceContains("import annot.Foo;", cu);
        this.assertSourceContains("@Foo", cu);
        this.assertSourceDoesNotContain("@annot.Foo(88)", cu);
    }

    public void testNewSingleMemberAnnotation() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain("@Foo", cu);
        this.idField(cu).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SimpleDeclarationAnnotationAdapterTests.this.editNewSingleMemberAnnotation(declaration);
            }
        });
        this.assertSourceContains("import annot.Foo;", cu);
        this.assertSourceContains("@Foo(\"test string literal\")", cu);
    }

    void editNewSingleMemberAnnotation(ModifiedDeclaration declaration) {
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        SingleMemberAnnotation annotation = (SingleMemberAnnotation)daa.getAnnotation(declaration);
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        annotation = daa.newSingleMemberAnnotation(declaration);
        StringLiteral stringLiteral = annotation.getAST().newStringLiteral();
        stringLiteral.setLiteralValue("test string literal");
        annotation.setValue((Expression)stringLiteral);
    }

    public void testNewNormalAnnotation() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain("@Foo", cu);
        this.idField(cu).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SimpleDeclarationAnnotationAdapterTests.this.editNewNormalAnnotation(declaration);
            }
        });
        this.assertSourceContains("import annot.Foo;", cu);
        this.assertSourceContains("@Foo(bar = \"test string literal\")", cu);
    }

    void editNewNormalAnnotation(ModifiedDeclaration declaration) {
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NormalAnnotation annotation = (NormalAnnotation)daa.getAnnotation(declaration);
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        annotation = daa.newNormalAnnotation(declaration);
        MemberValuePair mvp = this.newMemberValuePair(annotation.getAST(), "bar", "test string literal");
        this.values(annotation).add(mvp);
    }

    public void testImportCollision1() throws Exception {
        this.createAnnotation("annot1", "Foo");
        this.createAnnotation("annot2", "Foo");
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain("@Foo", cu);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot1.Foo");
        SimpleDeclarationAnnotationAdapter daa2 = new SimpleDeclarationAnnotationAdapter("annot2.Foo");
        ElementAnnotationAdapter aa1 = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa1);
        Annotation annotation1 = aa1.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation1);
        ElementAnnotationAdapter aa2 = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa2);
        Annotation annotation2 = aa2.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation2);
        aa1.newMarkerAnnotation();
        this.assertSourceContains("import annot1.Foo;", cu);
        this.assertSourceContains("@Foo", cu);
        aa2.newMarkerAnnotation();
        this.assertSourceDoesNotContain("import annot2.Foo;", cu);
        this.assertSourceContains("@annot2.Foo", cu);
    }

    public void testImportCollision2() throws Exception {
        this.createAnnotation("annot1", "Foo");
        this.createAnnotation("annot2", "Foo");
        ICompilationUnit cu = this.createTestType("annot1.*", "@Foo");
        this.assertSourceContains("import annot1.*;", cu);
        this.assertSourceContains("@Foo", cu);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot1.Foo");
        SimpleDeclarationAnnotationAdapter daa2 = new SimpleDeclarationAnnotationAdapter("annot2.Foo");
        ElementAnnotationAdapter aa1 = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa1);
        Annotation annotation1 = aa1.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation1);
        ElementAnnotationAdapter aa2 = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa2);
        Annotation annotation2 = aa2.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation2);
        aa2.newMarkerAnnotation();
        this.assertSourceDoesNotContain("import annot2.Foo;", cu);
        this.assertSourceContains("@annot2.Foo", cu);
    }

    public void testImportWildCard() throws Exception {
        this.createAnnotation("Foo");
        ICompilationUnit cu = this.createTestType("annot.*", "");
        this.assertSourceContains("import annot.*;", cu);
        this.assertSourceDoesNotContain("@Foo", cu);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ElementAnnotationAdapter aa1 = new ElementAnnotationAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationAdapter)daa1);
        Annotation annotation1 = aa1.getAnnotation(this.buildASTRoot(cu));
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation1);
        aa1.newMarkerAnnotation();
        this.assertSourceDoesNotContain("import annot.Foo;", cu);
        this.assertSourceContains("@Foo", cu);
    }
}

