/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class CreateMembersTests
extends AbstractJavaModelTests {
    public CreateMembersTests(String name) {
        super(name);
    }

    public static Test suite() {
        return CreateMembersTests.buildModelTestSuite(CreateMembersTests.class, 1L);
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("CreateMembers", "1.5");
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("CreateMembers");
        super.tearDownSuite();
    }

    public void test001() throws JavaScriptModelException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("CreateMembers", "src", "", "A.js");
        CreateMembersTests.assertNotNull((String)"No compilation unit", (Object)compilationUnit);
        compilationUnit.createMethod("\tfunction foo() {\n\t\tSystem.out.println(\"Hello World\");\n\t}\n", null, true, (IProgressMonitor)new NullProgressMonitor());
        String expectedSource = "var aVar;\n\nfunction foo() {\n\tSystem.out.println(\"Hello World\");\n}";
        this.assertSourceEquals("Unexpected source", expectedSource, compilationUnit.getSource());
    }

    public void test002() throws JavaScriptModelException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("CreateMembers", "src", "", "A2.js");
        CreateMembersTests.assertNotNull((String)"No compilation unit", (Object)compilationUnit);
        IField sibling = compilationUnit.getField("aVar");
        compilationUnit.createField("var i;", (IJavaScriptElement)sibling, true, null);
        String expectedSource = "var i;\n\nvar aVar;";
        this.assertSourceEquals("Unexpected source", expectedSource, compilationUnit.getSource());
    }

    public void test003() throws JavaScriptModelException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("CreateMembers", "src", "", "Annot.js");
        CreateMembersTests.assertNotNull((String)"No compilation unit", (Object)compilationUnit);
        IType[] types = compilationUnit.getTypes();
        CreateMembersTests.assertNotNull((String)"No types", (Object)types);
        CreateMembersTests.assertEquals((String)"Wrong size", (int)1, (int)types.length);
        IType type = types[0];
        IFunction sibling = type.getFunction("foo", new String[0]);
        type.createMethod("String bar();", (IJavaScriptElement)sibling, true, null);
        String expectedSource = "public @interface Annot {\n\tString bar();\n\n\tString foo();\n}";
        this.assertSourceEquals("Unexpected source", expectedSource, type.getSource());
    }

    public void test004() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/CreateMembers/src/A.js").getType("A");
        IFunction method = type.createMethod("void bar(String... args) {}", null, false, null);
        CreateMembersTests.assertTrue((String)"Method should exist", (boolean)method.exists());
    }

    public void test005() throws JavaScriptModelException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("CreateMembers", "src", "", "E2.js");
        CreateMembersTests.assertNotNull((String)"No compilation unit", (Object)compilationUnit);
        IType[] types = compilationUnit.getTypes();
        CreateMembersTests.assertNotNull((String)"No types", (Object)types);
        CreateMembersTests.assertEquals((String)"Wrong size", (int)1, (int)types.length);
        IType type = types[0];
        type.createField("int i;", null, true, null);
        String expectedSource = "public enum E2 {\n\tA, B, C;\n\n\tint i;\n}";
        this.assertSourceEquals("Unexpected source", expectedSource, type.getSource());
    }

    public void test006() throws JavaScriptModelException {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit("CreateMembers", "src", "", "E3.js");
        CreateMembersTests.assertNotNull((String)"No compilation unit", (Object)compilationUnit);
        IType[] types = compilationUnit.getTypes();
        CreateMembersTests.assertNotNull((String)"No types", (Object)types);
        CreateMembersTests.assertEquals((String)"Wrong size", (int)1, (int)types.length);
        IType type = types[0];
        type.createType("class DD {}", null, true, null);
        String expectedSource = "public enum E3 {\n\tA, B, C;\n\n\tclass DD {}\n}";
        this.assertSourceEquals("Unexpected source", expectedSource, type.getSource());
    }
}

