/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal;

import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.utils.JaxWsUtils;

public class JaxWsUtilsTest
extends MockObjectTestCase {
    private static final String CLASS_NAME = "TestBean";
    private static final String CLASS_FQ_NAME = "org.eclipse.test.TestBean";

    public void testComposeJaxWsTargetNamespaceByPackage_WithNull() {
        try {
            JaxWsUtils.composeJaxWsTargetNamespaceByPackage(null);
            JaxWsUtilsTest.fail((String)"NPE expected");
        }
        catch (Exception exception) {
            JaxWsUtilsTest.assertTrue((boolean)true);
        }
    }

    public void testComposeJaxWsTargetNamespaceByPackage() {
        String ns = JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)"");
        JaxWsUtilsTest.assertTrue((boolean)ns.equals("http:///"));
        ns = JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)"a");
        JaxWsUtilsTest.assertTrue((boolean)ns.equals("http://a/"));
        ns = JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)"a.b.c");
        JaxWsUtilsTest.assertTrue((boolean)ns.equals("http://b.a/c/"));
        ns = JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)"a.b.c.d");
        JaxWsUtilsTest.assertTrue((boolean)ns.equals("http://b.a/c/d/"));
        ns = JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)"a.b.c.d.e");
        JaxWsUtilsTest.assertTrue((boolean)ns.equals("http://b.a/c/d/e/"));
    }

    public void testGetDefaultServiceName() {
        try {
            JaxWsUtils.getDefaultServiceName(null);
            JaxWsUtilsTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        JaxWsUtilsTest.assertEquals((String)"TestBeanService", (String)JaxWsUtils.getDefaultServiceName((String)CLASS_FQ_NAME));
    }

    public void testGetDefaultPorttypeName() {
        try {
            JaxWsUtils.getDefaultPorttypeName(null);
            JaxWsUtilsTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        JaxWsUtilsTest.assertEquals((String)CLASS_NAME, (String)JaxWsUtils.getDefaultPorttypeName((String)CLASS_FQ_NAME));
    }

    public void testGetDefaultPortName() {
        try {
            JaxWsUtils.getDefaultPortName(null);
            JaxWsUtilsTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        JaxWsUtilsTest.assertEquals((String)"TestBeanPort", (String)JaxWsUtils.getDefaultPortName((String)CLASS_FQ_NAME));
    }
}

