/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.wst.jsdt.chromium.internal.transport.LineReader;
import org.eclipse.wst.jsdt.chromium.internal.transport.Message;
import org.eclipse.wst.jsdt.chromium.internal.v8native.JavascriptVmImpl;

public interface Handshaker {
    public static final Handshaker CHROMIUM = new Handshaker(){
        private final Charset LATIN1_CHARSET = Charset.forName("LATIN1");
        private static final String INCOMING_TEXT = "ChromeDevToolsHandshake";
        private final byte[] OUTGOING_MESSAGE_BYTES = "ChromeDevToolsHandshake\r\n".getBytes();

        @Override
        public void perform(LineReader input, OutputStream output) throws IOException {
            output.write(this.OUTGOING_MESSAGE_BYTES);
            output.flush();
            if (Thread.interrupted()) {
                throw new IOException("Interrupted");
            }
            String line = input.readLine(this.LATIN1_CHARSET);
            if (line == null) {
                throw new IOException("Connection closed");
            }
            if (!INCOMING_TEXT.equals(line)) {
                throw new IOException("Unexpected handshake: " + line);
            }
        }
    };

    public void perform(LineReader var1, OutputStream var2) throws IOException;

    public static interface StandaloneV8
    extends Handshaker {
        public Future<RemoteInfo> getRemoteInfo();

        public static interface RemoteInfo {
            public String getProtocolVersion();

            public String getV8VmVersion();

            public String getEmbeddingHostName();
        }
    }

    public static class StandaloneV8Impl
    implements StandaloneV8 {
        private final FutureTask<StandaloneV8.RemoteInfo> runnableFuture = new FutureTask<StandaloneV8.RemoteInfo>(new HandshakeTaks());
        private LineReader input = null;
        private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

        @Override
        public Future<StandaloneV8.RemoteInfo> getRemoteInfo() {
            return this.runnableFuture;
        }

        @Override
        public void perform(LineReader input, OutputStream output) throws IOException {
            this.input = input;
            this.runnableFuture.run();
            try {
                this.runnableFuture.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw JavascriptVmImpl.newIOException("Failed to perform handshake", e);
            }
        }

        class HandshakeTaks
        implements Callable<StandaloneV8.RemoteInfo> {
            HandshakeTaks() {
            }

            @Override
            public StandaloneV8.RemoteInfo call() throws IOException {
                Message message;
                try {
                    message = Message.fromBufferedReader(StandaloneV8Impl.this.input, UTF8_CHARSET);
                }
                catch (Message.MalformedMessageException e) {
                    throw JavascriptVmImpl.newIOException("Unrecognized handshake message from remote", e);
                }
                if (message == null) {
                    throw new IOException("End of stream");
                }
                final String protocolVersion = message.getHeader("Protocol-Version", null);
                if (protocolVersion == null) {
                    throw new IOException("Absent protocol version");
                }
                final String vmVersion = message.getHeader("V8-Version", null);
                if (vmVersion == null) {
                    throw new IOException("Absent V8 VM version");
                }
                StandaloneV8.RemoteInfo remoteInfo = new StandaloneV8.RemoteInfo(){

                    @Override
                    public String getProtocolVersion() {
                        return protocolVersion;
                    }

                    @Override
                    public String getV8VmVersion() {
                        return vmVersion;
                    }

                    @Override
                    public String getEmbeddingHostName() {
                        return message.getHeader("Embedding-Host", null);
                    }
                };
                return remoteInfo;
            }
        }
    }
}

