/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import java.util.ArrayList;
import javax.jws.soap.SOAPBinding;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractSOAPBindingValidationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class SOAPBindingDocumentEncodedRuleTest
extends AbstractSOAPBindingValidationTest {
    protected Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair styleValuePair = AnnotationsCore.createEnumMemberValuePair((AST)this.ast, (String)SOAPBinding.class.getCanonicalName(), (String)"style", (Object)SOAPBinding.Style.DOCUMENT);
        MemberValuePair useValuePair = AnnotationsCore.createEnumMemberValuePair((AST)this.ast, (String)SOAPBinding.class.getCanonicalName(), (String)"use", (Object)SOAPBinding.Use.ENCODED);
        MemberValuePair parameterStyleValuePair = AnnotationsCore.createEnumMemberValuePair((AST)this.ast, (String)SOAPBinding.class.getCanonicalName(), (String)"parameterStyle", (Object)SOAPBinding.ParameterStyle.BARE);
        memberValuePairs.add(styleValuePair);
        memberValuePairs.add(useValuePair);
        memberValuePairs.add(parameterStyleValuePair);
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)SOAPBinding.class.getSimpleName(), memberValuePairs);
    }

    public void testSOAPBindingDocumentEncodedRule() {
        try {
            SOAPBindingDocumentEncodedRuleTest.assertNotNull((Object)this.annotation);
            SOAPBindingDocumentEncodedRuleTest.assertEquals((String)SOAPBinding.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("myMethod", new String[]{"QString;"});
            SOAPBindingDocumentEncodedRuleTest.assertNotNull((Object)method);
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)method, (String)SOAPBinding.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (Annotation)this.annotation));
            SOAPBindingDocumentEncodedRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            SOAPBindingDocumentEncodedRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            SOAPBindingDocumentEncodedRuleTest.assertTrue((boolean)this.source.getImport(SOAPBinding.class.getCanonicalName()).exists());
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            SOAPBindingDocumentEncodedRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            SOAPBindingDocumentEncodedRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            SOAPBindingDocumentEncodedRuleTest.assertEquals((Object)JAXWSCoreMessages.SOAPBINDING_DOCUMENT_ENCODED_NOT_SUPPORTED, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            SOAPBindingDocumentEncodedRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            SOAPBindingDocumentEncodedRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            SOAPBindingDocumentEncodedRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

