/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.io.IOException;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.FunctionScopeExtension;
import org.eclipse.wst.jsdt.chromium.IgnoreCountBreakpointExtension;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.RestartFrameExtension;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.Version;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.CallFrameImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8VersionFeatures;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsFunctionImpl;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

public abstract class JavascriptVmImpl
implements JavascriptVm {
    protected JavascriptVmImpl() {
    }

    @Override
    public void suspend(JavascriptVm.SuspendCallback callback) {
        this.getDebugSession().suspend(callback);
    }

    @Override
    public void getScripts(JavascriptVm.ScriptsCallback callback) throws MethodIsBlockingException {
        CallbackSemaphore callbackSemaphore = new CallbackSemaphore();
        RelayOk relayOk = this.getDebugSession().getScriptManagerProxy().getAllScripts(callback, callbackSemaphore);
        boolean res = callbackSemaphore.tryAcquireDefault(relayOk);
        if (!res) {
            callback.failure("Timeout");
        }
    }

    @Override
    public RelayOk setBreakpoint(Breakpoint.Target target, int line, int column, boolean enabled, String condition, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        return this.getDebugSession().getBreakpointManager().setBreakpoint(target, line, column, enabled, condition, callback, syncCallback);
    }

    @Override
    public RelayOk listBreakpoints(JavascriptVm.ListBreakpointsCallback callback, SyncCallback syncCallback) {
        return this.getDebugSession().getBreakpointManager().reloadBreakpoints(callback, syncCallback);
    }

    @Override
    public RelayOk enableBreakpoints(Boolean enabled, GenericCallback<Boolean> callback, SyncCallback syncCallback) {
        return this.getDebugSession().getBreakpointManager().enableBreakpoints(enabled, callback, syncCallback);
    }

    @Override
    public RelayOk setBreakOnException(JavascriptVm.ExceptionCatchMode catchMode, GenericCallback<JavascriptVm.ExceptionCatchMode> callback, SyncCallback syncCallback) {
        return this.getDebugSession().getBreakpointManager().setBreakOnException(catchMode, callback, syncCallback);
    }

    @Override
    public Version getVersion() {
        return this.getDebugSession().getVmVersion();
    }

    @Override
    public BreakpointTypeExtension getBreakpointTypeExtension() {
        return this.getDebugSession().getBreakpointManager().getBreakpointTypeExtension();
    }

    @Override
    public IgnoreCountBreakpointExtension getIgnoreCountBreakpointExtension() {
        return BreakpointImpl.IGNORE_COUNT_EXTENSION;
    }

    @Override
    public FunctionScopeExtension getFunctionScopeExtension() {
        if (!V8VersionFeatures.isFunctionScopeSupported(this.getDebugSession().getVmVersion())) {
            return null;
        }
        return JsFunctionImpl.FUNCTION_SCOPE_EXTENSION;
    }

    @Override
    public RestartFrameExtension getRestartFrameExtension() {
        if (!V8VersionFeatures.isRestartFrameSupported(this.getDebugSession().getVmVersion())) {
            return null;
        }
        return CallFrameImpl.RESTART_FRAME_EXTENSION;
    }

    public abstract DebugSession getDebugSession();

    public static IOException newIOException(String message, Throwable cause) {
        IOException result = new IOException(message);
        result.initCause(cause);
        return result;
    }
}

