/* The following code was generated by JFlex 1.4.2 on 3/1/20, 11:47 PM */

/*******************************************************************************
 * Copyright (c) 2004, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Gautier de SAINT MARTIN LACAZE - bug 441104, 432472, 446745, 481719
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.wst.css.core.internal.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.wst.css.core.internal.parser.regions.CSSTextRegionFactory;
import org.eclipse.wst.css.core.internal.parserz.CSSRegionContexts;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.2
 * on 3/1/20, 11:47 PM from the specification file
 * <tt>CSSTokenizer.jflex</tt>
 */
public class CSSTokenizer implements CSSRegionContexts, ICSSTokenizer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_SELECTOR_ATTRIBUTE_NAME = 26;
  public static final int ST_IMPORT_DELIMITER = 10;
  public static final int ST_DECLARATION_PRE_VALUE = 38;
  public static final int ST_SELECTOR = 22;
  public static final int ST_CHARSET_DELIMITER = 4;
  public static final int ST_DECLARATION_VALUE = 40;
  public static final int ST_PAGE_PSEUDO_PAGE = 16;
  public static final int ST_IMPORT_URI = 6;
  public static final int ST_SELECTOR_ATTRIBUTE_END = 32;
  public static final int ST_SELECTOR_ATTRIBUTE_OPERATOR = 28;
  public static final int ST_DECLARATION = 34;
  public static final int ST_PAGE_DELIMITER = 18;
  public static final int ST_SELECTOR_ATTRIBUTE_VALUE = 30;
  public static final int ST_MEDIA_MEDIUM = 12;
  public static final int ST_CHARSET_NAME = 2;
  public static final int ST_IMPORT_MEDIUM = 8;
  public static final int ST_DECLARATION_SEPARATOR = 36;
  public static final int ST_FONT_FACE_DELIMITER = 20;
  public static final int ST_MEDIA_DELIMITER = 14;
  public static final int ST_SELECTOR_MODIFIER = 24;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9,  9,  9,  0,  0, 10, 10, 11, 11, 12, 12, 13, 13, 
    14, 14, 15, 15, 16, 16, 17, 17, 18, 18
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\17\1\0\1\4\1\20\22\0\1\6\1\31\1\11"+
    "\1\21\1\71\1\72\1\16\1\5\1\25\1\13\1\35\1\15\1\55"+
    "\1\10\1\14\1\34\12\1\1\62\1\50\1\30\1\70\1\32\1\27"+
    "\1\36\1\43\1\26\1\40\1\57\1\46\1\64\1\61\1\41\1\51"+
    "\2\2\1\24\1\52\1\65\1\54\1\53\1\2\1\23\1\44\1\47"+
    "\1\22\5\2\1\66\1\3\1\67\1\71\1\2\1\16\1\42\1\7"+
    "\1\37\1\56\1\45\1\63\1\61\1\41\1\51\2\2\1\24\1\52"+
    "\1\65\1\54\1\53\1\2\1\23\1\44\1\47\1\22\5\2\1\60"+
    "\1\71\1\33\1\71\1\0\uff80\2";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\23\0\1\1\1\2\1\3\1\1\1\4\1\2\1\5"+
    "\2\1\1\6\1\1\1\7\1\1\1\10\1\1\1\11"+
    "\1\12\3\1\1\13\3\1\1\14\2\1\1\15\1\16"+
    "\2\1\1\17\1\20\1\21\2\1\1\22\2\1\1\4"+
    "\1\2\1\23\1\24\1\25\2\1\1\26\1\1\1\27"+
    "\1\30\4\1\1\31\3\1\1\32\1\33\1\34\1\35"+
    "\4\1\1\36\1\34\2\1\1\35\1\1\2\37\1\4"+
    "\2\0\1\3\1\2\1\40\1\0\1\41\10\0\1\11"+
    "\4\0\1\42\5\0\1\43\4\0\1\14\1\0\1\16"+
    "\1\0\1\21\1\0\1\2\1\44\1\0\1\25\1\0"+
    "\1\30\2\0\1\30\3\0\1\31\1\0\1\45\2\0"+
    "\1\46\1\0\1\35\1\47\1\35\2\0\1\50\2\0"+
    "\1\51\2\0\1\35\2\0\1\52\1\3\1\53\1\40"+
    "\1\41\7\0\1\11\1\0\1\42\2\0\1\42\2\0"+
    "\1\43\2\0\1\43\2\0\1\14\1\16\1\21\1\2"+
    "\1\25\1\30\1\0\1\30\2\0\1\30\1\0\1\31"+
    "\1\45\1\35\1\0\1\35\1\0\1\50\2\0\1\50"+
    "\1\0\1\51\1\54\1\35\1\0\1\3\1\40\1\41"+
    "\1\55\1\56\5\0\1\11\5\0\1\14\1\16\1\21"+
    "\1\2\1\25\1\30\2\0\1\31\1\45\2\35\2\0"+
    "\1\51\1\54\1\0\1\47\1\0\1\3\1\40\1\41"+
    "\3\0\1\57\1\0\1\11\10\0\1\60\1\14\1\16"+
    "\1\21\1\2\1\25\1\30\2\0\1\31\1\45\2\35"+
    "\2\0\1\51\2\54\5\0\1\61\1\0\1\3\1\40"+
    "\1\41\2\0\1\62\1\0\1\11\6\0\1\60\2\0"+
    "\1\14\1\16\1\21\1\2\1\25\1\30\2\0\1\31"+
    "\1\45\2\35\2\0\1\51\2\54\2\0\1\61\3\0"+
    "\1\3\1\40\1\41\1\0\1\63\1\0\1\11\13\0"+
    "\1\14\1\16\1\21\1\2\1\25\1\30\2\0\1\31"+
    "\1\45\2\35\2\0\1\51\2\54\10\0\1\40\1\41"+
    "\1\64\1\0\1\11\6\0\1\60\1\0\1\60\2\0"+
    "\1\45\1\35\2\0\1\51\2\54\2\0\1\61\1\0"+
    "\1\61\5\0\1\35\1\54\4\0\1\65\3\0\1\54"+
    "\3\0\1\66\12\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[435];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\73\0\166\0\261\0\354\0\u0127\0\u0162\0\u019d"+
    "\0\u01d8\0\u0213\0\u024e\0\u0289\0\u02c4\0\u02ff\0\u033a\0\u0375"+
    "\0\u03b0\0\u03eb\0\u0426\0\u0461\0\u049c\0\u04d7\0\u0512\0\u054d"+
    "\0\u0588\0\u0461\0\u05c3\0\u05fe\0\u0461\0\u0639\0\u0461\0\u0674"+
    "\0\u0461\0\u06af\0\u06ea\0\u0461\0\u0725\0\u0760\0\u079b\0\u0461"+
    "\0\u07d6\0\u0811\0\u084c\0\u0887\0\u08c2\0\u08fd\0\u0461\0\u0938"+
    "\0\u0973\0\u09ae\0\u0461\0\u0461\0\u09e9\0\u0a24\0\u0a5f\0\u0461"+
    "\0\u0a9a\0\u0ad5\0\u0b10\0\u0b4b\0\u0461\0\u0461\0\u0b86\0\u0bc1"+
    "\0\u0bfc\0\u0461\0\u0c37\0\u0461\0\u0c72\0\u0cad\0\u0ce8\0\u0d23"+
    "\0\u0d5e\0\u0d99\0\u0dd4\0\u0e0f\0\u0e4a\0\u0461\0\u0461\0\u0e85"+
    "\0\u0ec0\0\u0efb\0\u0f36\0\u0f71\0\u0fac\0\u0461\0\u0fe7\0\u1022"+
    "\0\u105d\0\u1098\0\u10d3\0\u0674\0\u0461\0\u110e\0\u0ad5\0\u0512"+
    "\0\u1149\0\u1184\0\u05c3\0\u11bf\0\u05fe\0\u11fa\0\u1235\0\u1270"+
    "\0\u12ab\0\u12e6\0\u1321\0\u135c\0\u1397\0\u13d2\0\u140d\0\u1448"+
    "\0\u0725\0\u1483\0\u0461\0\u14be\0\u079b\0\u14f9\0\u07d6\0\u1534"+
    "\0\u0461\0\u0811\0\u156f\0\u15aa\0\u08c2\0\u15e5\0\u0973\0\u1620"+
    "\0\u0a24\0\u165b\0\u1696\0\u16d1\0\u0461\0\u0bc1\0\u170c\0\u0cad"+
    "\0\u1747\0\u0ce8\0\u1782\0\u0461\0\u0d5e\0\u17bd\0\u0dd4\0\u17f8"+
    "\0\u1833\0\u186e\0\u18a9\0\u18e4\0\u0461\0\u0efb\0\u191f\0\u0461"+
    "\0\u195a\0\u0f36\0\u1995\0\u0461\0\u0fac\0\u19d0\0\u105d\0\u1a0b"+
    "\0\u1a46\0\u1a81\0\u10d3\0\u1abc\0\u0461\0\u1af7\0\u0461\0\u1b32"+
    "\0\u1b6d\0\u1ba8\0\u1be3\0\u1c1e\0\u1c59\0\u1c94\0\u1ccf\0\u1d0a"+
    "\0\u1d45\0\u1d80\0\u0725\0\u1dbb\0\u1df6\0\u079b\0\u1e31\0\u1e6c"+
    "\0\u07d6\0\u1ea7\0\u1ee2\0\u0811\0\u1f1d\0\u1f58\0\u1f93\0\u1fce"+
    "\0\u2009\0\u2044\0\u207f\0\u20ba\0\u20f5\0\u0ce8\0\u2130\0\u216b"+
    "\0\u0d5e\0\u21a6\0\u21e1\0\u221c\0\u2257\0\u2292\0\u22cd\0\u2308"+
    "\0\u0f36\0\u2343\0\u237e\0\u0fac\0\u23b9\0\u23f4\0\u242f\0\u246a"+
    "\0\u24a5\0\u24e0\0\u251b\0\u2556\0\u0461\0\u0461\0\u2591\0\u25cc"+
    "\0\u2607\0\u2642\0\u267d\0\u26b8\0\u26f3\0\u272e\0\u2769\0\u27a4"+
    "\0\u27df\0\u281a\0\u2855\0\u2890\0\u28cb\0\u2906\0\u2941\0\u297c"+
    "\0\u29b7\0\u29f2\0\u2a2d\0\u2a68\0\u2aa3\0\u2ade\0\u2b19\0\u2b54"+
    "\0\u2b8f\0\u2bca\0\u2c05\0\u2c40\0\u2c7b\0\u2cb6\0\u2cf1\0\u2d2c"+
    "\0\u2d67\0\u2da2\0\u0461\0\u2ddd\0\u2e18\0\u2e53\0\u2e8e\0\u2ec9"+
    "\0\u2f04\0\u2f3f\0\u2f7a\0\u2fb5\0\u2ff0\0\u0461\0\u302b\0\u3066"+
    "\0\u30a1\0\u30dc\0\u3117\0\u3152\0\u318d\0\u31c8\0\u3203\0\u323e"+
    "\0\u3279\0\u32b4\0\u32ef\0\u332a\0\u3365\0\u33a0\0\u33db\0\u3416"+
    "\0\u3451\0\u2c05\0\u348c\0\u34c7\0\u0461\0\u3502\0\u353d\0\u3578"+
    "\0\u35b3\0\u35ee\0\u3629\0\u0461\0\u3664\0\u369f\0\u36da\0\u3715"+
    "\0\u3750\0\u378b\0\u37c6\0\u3801\0\u2f3f\0\u383c\0\u3877\0\u38b2"+
    "\0\u38ed\0\u3928\0\u3963\0\u399e\0\u39d9\0\u3a14\0\u3a4f\0\u3a8a"+
    "\0\u3ac5\0\u3b00\0\u3b3b\0\u3b76\0\u3bb1\0\u3bec\0\u3c27\0\u3c62"+
    "\0\u3c9d\0\u3cd8\0\u3416\0\u3d13\0\u3d4e\0\u3d89\0\u3dc4\0\u3dff"+
    "\0\u3e3a\0\u3e75\0\u0461\0\u3eb0\0\u3eeb\0\u3f26\0\u3f61\0\u3f9c"+
    "\0\u3fd7\0\u4012\0\u404d\0\u4088\0\u40c3\0\u40fe\0\u4139\0\u4174"+
    "\0\u41af\0\u41ea\0\u4225\0\u4260\0\u429b\0\u42d6\0\u4311\0\u434c"+
    "\0\u4387\0\u43c2\0\u43fd\0\u4438\0\u4473\0\u44ae\0\u44e9\0\u4524"+
    "\0\u455f\0\u459a\0\u45d5\0\u4610\0\u464b\0\u4686\0\u46c1\0\u46fc"+
    "\0\u4737\0\u4772\0\u47ad\0\u0461\0\u47e8\0\u4823\0\u485e\0\u4899"+
    "\0\u48d4\0\u490f\0\u494a\0\u4985\0\u2fb5\0\u49c0\0\u2ff0\0\u49fb"+
    "\0\u4a36\0\u4a71\0\u4aac\0\u4ae7\0\u4b22\0\u4b5d\0\u4b98\0\u4bd3"+
    "\0\u4c0e\0\u4c49\0\u348c\0\u4c84\0\u34c7\0\u4cbf\0\u4cfa\0\u4d35"+
    "\0\u4d70\0\u4dab\0\u4de6\0\u4e21\0\u4e5c\0\u4e97\0\u4ed2\0\u4f0d"+
    "\0\u0461\0\u4f48\0\u4f83\0\u4fbe\0\u0461\0\u4ff9\0\u5034\0\u506f"+
    "\0\u0461\0\u50aa\0\u50e5\0\u5120\0\u515b\0\u5196\0\u51d1\0\u520c"+
    "\0\u5247\0\u5282\0\u52bd";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[435];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\24\1\25\1\26\1\27\1\30\1\24\1\30\1\26"+
    "\1\31\1\24\1\30\1\32\1\33\2\24\2\30\1\34"+
    "\3\26\1\35\1\26\1\24\1\36\2\24\1\37\1\40"+
    "\1\41\1\42\11\26\1\24\4\26\1\24\2\26\1\24"+
    "\1\26\1\43\3\26\1\44\10\24\1\30\1\45\1\30"+
    "\1\24\1\46\1\47\1\30\4\24\2\30\7\24\1\36"+
    "\2\24\1\37\1\40\1\24\1\42\40\24\1\30\1\24"+
    "\1\30\1\24\1\46\1\24\1\30\4\24\2\30\7\24"+
    "\1\36\2\24\1\37\1\40\1\24\1\42\11\24\1\50"+
    "\26\24\1\30\1\51\1\30\1\24\1\46\1\52\1\30"+
    "\4\24\2\30\1\24\1\53\5\24\1\36\2\24\1\37"+
    "\1\40\1\24\1\42\11\24\1\50\24\24\1\54\1\55"+
    "\1\30\1\24\1\30\1\54\1\56\1\24\1\30\4\24"+
    "\2\30\1\24\3\54\1\24\1\54\1\24\1\36\2\24"+
    "\1\37\1\40\1\24\1\42\11\54\1\50\4\54\1\24"+
    "\2\54\1\24\1\54\1\24\3\54\11\24\1\30\1\24"+
    "\1\30\1\24\1\46\1\24\1\30\4\24\2\30\7\24"+
    "\1\36\2\24\1\37\1\40\1\24\1\42\11\24\1\50"+
    "\4\24\1\57\17\24\1\60\1\61\1\30\1\24\1\30"+
    "\1\60\1\62\1\24\1\30\4\24\2\30\1\24\3\60"+
    "\1\24\1\60\1\24\1\36\2\24\1\37\1\40\1\24"+
    "\1\42\11\60\1\24\4\60\1\24\2\60\1\63\1\60"+
    "\1\24\3\60\11\24\1\30\1\24\1\30\1\24\1\46"+
    "\1\24\1\30\4\24\2\30\7\24\1\36\2\24\1\37"+
    "\1\40\1\24\1\42\16\24\1\64\2\24\1\63\14\24"+
    "\1\65\1\66\1\30\1\24\1\30\1\65\1\67\1\24"+
    "\1\30\4\24\2\30\1\24\3\65\1\24\1\65\1\24"+
    "\1\36\2\24\1\37\1\40\1\24\1\42\11\65\1\24"+
    "\4\65\1\24\2\65\1\70\1\65\1\71\3\65\11\24"+
    "\1\30\1\24\1\30\1\24\1\46\1\24\1\30\4\24"+
    "\2\30\7\24\1\36\2\24\1\37\1\40\1\24\1\42"+
    "\21\24\1\70\13\24\2\25\1\72\1\73\1\24\1\73"+
    "\1\25\1\74\1\24\1\73\1\32\1\33\1\75\1\24"+
    "\2\73\1\34\3\25\1\35\1\25\1\24\1\36\1\24"+
    "\1\75\1\37\1\40\1\41\1\42\11\25\1\24\4\25"+
    "\1\76\2\25\1\70\1\25\1\43\3\25\1\44\6\24"+
    "\1\77\1\100\1\30\1\24\1\30\1\77\1\101\1\24"+
    "\1\30\4\24\2\30\1\24\3\77\1\24\1\77\1\24"+
    "\1\36\2\24\1\37\1\40\1\24\1\42\11\77\1\24"+
    "\4\77\1\24\2\77\1\24\1\77\1\24\3\77\1\24"+
    "\1\102\7\24\1\30\1\24\1\30\1\24\1\46\1\24"+
    "\1\30\4\24\2\30\7\24\1\36\2\24\1\37\1\40"+
    "\1\103\1\42\30\24\1\102\1\104\1\103\3\24\1\105"+
    "\1\106\1\30\1\107\1\30\1\105\1\110\1\111\1\30"+
    "\4\24\2\30\1\24\3\105\1\24\1\105\1\24\1\36"+
    "\2\24\1\37\1\40\1\24\1\42\11\105\1\24\4\105"+
    "\1\24\2\105\1\24\1\105\1\24\3\105\11\24\1\30"+
    "\1\24\1\30\1\24\1\46\1\24\1\30\4\24\2\30"+
    "\7\24\1\36\2\24\1\37\1\40\1\24\1\42\30\24"+
    "\1\102\5\24\1\112\1\113\1\30\1\24\1\30\1\112"+
    "\1\114\1\24\1\30\4\24\2\30\1\24\3\112\1\24"+
    "\1\112\1\24\1\36\2\24\1\37\1\40\1\115\1\42"+
    "\11\112\1\116\4\112\1\24\2\112\1\24\1\112\1\24"+
    "\3\112\11\24\1\30\1\24\1\30\1\24\1\46\1\24"+
    "\1\30\4\24\2\30\7\24\1\36\2\24\1\37\1\40"+
    "\1\24\1\42\11\24\1\116\11\24\1\117\11\24\1\120"+
    "\1\121\1\122\1\30\1\123\1\30\1\121\1\124\1\125"+
    "\1\30\1\126\1\127\1\130\1\24\2\30\1\131\1\132"+
    "\2\121\1\24\1\121\1\24\1\36\1\133\1\24\1\37"+
    "\1\134\1\24\1\42\11\121\1\116\4\121\1\135\2\121"+
    "\1\24\1\121\1\24\3\121\6\24\1\120\1\121\1\122"+
    "\1\136\1\123\1\136\1\121\1\124\1\125\1\136\1\126"+
    "\1\127\1\130\1\24\2\136\1\131\1\132\2\121\1\24"+
    "\1\121\1\24\1\36\1\133\1\24\1\37\1\134\1\24"+
    "\1\42\11\121\1\116\4\121\1\135\2\121\1\24\1\121"+
    "\1\24\3\121\5\24\74\0\2\25\1\137\3\0\2\25"+
    "\11\0\3\25\1\0\1\25\10\0\11\25\1\0\4\25"+
    "\1\0\2\25\1\0\1\25\1\0\3\25\6\0\2\26"+
    "\1\140\3\0\2\26\11\0\3\26\1\0\1\26\10\0"+
    "\11\26\1\0\4\26\1\0\2\26\1\0\1\26\1\0"+
    "\3\26\6\0\1\141\2\26\1\0\2\26\1\141\2\26"+
    "\1\0\4\26\2\0\16\26\1\141\2\26\1\141\2\26"+
    "\1\141\10\26\1\141\4\26\1\141\7\26\4\0\1\30"+
    "\1\0\1\30\3\0\1\30\4\0\2\30\53\0\1\25"+
    "\1\26\1\140\3\0\1\26\1\142\11\0\3\26\1\0"+
    "\1\26\10\0\11\26\1\0\4\26\1\0\2\26\1\0"+
    "\1\26\1\0\3\26\6\0\2\143\1\144\3\0\2\143"+
    "\11\0\3\143\1\0\1\143\10\0\11\143\1\0\4\143"+
    "\1\0\2\143\1\0\1\143\1\0\3\143\6\0\2\145"+
    "\1\146\3\0\2\145\11\0\3\145\1\0\1\145\10\0"+
    "\11\145\1\0\4\145\1\0\2\145\1\0\1\145\1\0"+
    "\3\145\36\0\1\147\76\0\1\150\74\0\2\151\10\0"+
    "\1\152\1\153\1\154\7\0\2\155\10\0\1\156\1\157"+
    "\3\0\1\156\1\160\11\0\3\156\1\0\1\156\10\0"+
    "\11\156\1\0\4\156\1\0\2\156\1\0\1\156\1\0"+
    "\3\156\6\0\2\161\1\162\1\0\1\163\11\161\2\0"+
    "\52\161\10\0\1\164\63\0\2\165\1\166\1\0\4\165"+
    "\1\163\5\165\2\0\52\165\1\0\2\167\1\170\1\0"+
    "\1\171\11\167\2\0\52\167\1\0\2\172\1\173\1\0"+
    "\4\172\1\171\5\172\2\0\52\172\23\0\1\174\50\0"+
    "\2\54\1\175\3\0\2\54\11\0\3\54\1\0\1\54"+
    "\10\0\11\54\1\0\4\54\1\0\2\54\1\0\1\54"+
    "\1\0\3\54\6\0\1\176\2\54\1\0\2\54\1\176"+
    "\2\54\1\0\4\54\2\0\16\54\1\176\2\54\1\176"+
    "\2\54\1\176\10\54\1\176\4\54\1\176\7\54\2\0"+
    "\1\54\1\175\3\0\1\54\1\164\11\0\3\54\1\0"+
    "\1\54\10\0\11\54\1\0\4\54\1\0\2\54\1\0"+
    "\1\54\1\0\3\54\6\0\2\60\1\177\3\0\2\60"+
    "\11\0\3\60\1\0\1\60\10\0\11\60\1\0\4\60"+
    "\1\0\2\60\1\0\1\60\1\0\3\60\6\0\1\200"+
    "\2\60\1\0\2\60\1\200\2\60\1\0\4\60\2\0"+
    "\16\60\1\200\2\60\1\200\2\60\1\200\10\60\1\200"+
    "\4\60\1\200\7\60\2\0\1\60\1\177\3\0\1\60"+
    "\1\164\11\0\3\60\1\0\1\60\10\0\11\60\1\0"+
    "\4\60\1\0\2\60\1\0\1\60\1\0\3\60\6\0"+
    "\2\65\1\201\3\0\2\65\11\0\3\65\1\0\1\65"+
    "\10\0\11\65\1\0\4\65\1\0\2\65\1\0\1\65"+
    "\1\0\3\65\6\0\1\202\2\65\1\0\2\65\1\202"+
    "\2\65\1\0\4\65\2\0\16\65\1\202\2\65\1\202"+
    "\2\65\1\202\10\65\1\202\4\65\1\202\7\65\2\0"+
    "\1\65\1\201\3\0\1\65\1\164\11\0\3\65\1\0"+
    "\1\65\10\0\11\65\1\0\4\65\1\0\2\65\1\0"+
    "\1\65\1\0\3\65\7\0\1\65\1\201\3\0\1\65"+
    "\1\203\11\0\3\65\1\0\1\65\10\0\11\65\1\0"+
    "\4\65\1\0\2\65\1\0\1\65\1\0\3\65\6\0"+
    "\1\204\2\25\1\0\2\25\1\204\2\25\1\0\4\25"+
    "\2\0\16\25\1\204\2\25\1\204\2\25\1\204\10\25"+
    "\1\204\4\25\1\204\7\25\4\205\1\73\1\205\1\73"+
    "\3\205\1\73\2\205\1\0\1\205\2\73\11\205\1\0"+
    "\1\205\1\0\20\205\1\0\2\205\1\0\12\205\1\0"+
    "\2\25\1\137\3\0\1\25\1\142\11\0\3\25\1\0"+
    "\1\25\10\0\11\25\1\0\4\25\1\0\2\25\1\0"+
    "\1\25\1\0\3\25\6\0\2\77\1\206\3\0\2\77"+
    "\11\0\3\77\1\0\1\77\10\0\11\77\1\0\4\77"+
    "\1\0\2\77\1\0\1\77\1\0\3\77\6\0\1\207"+
    "\2\77\1\0\2\77\1\207\2\77\1\0\4\77\2\0"+
    "\16\77\1\207\2\77\1\207\2\77\1\207\10\77\1\207"+
    "\4\77\1\207\7\77\2\0\1\77\1\206\3\0\1\77"+
    "\1\164\11\0\3\77\1\0\1\77\10\0\11\77\1\0"+
    "\4\77\1\0\2\77\1\0\1\77\1\0\3\77\75\0"+
    "\1\104\3\0\2\105\1\210\3\0\2\105\11\0\3\105"+
    "\1\0\1\105\10\0\11\105\1\0\4\105\1\0\2\105"+
    "\1\0\1\105\1\0\3\105\6\0\1\211\2\105\1\0"+
    "\2\105\1\211\2\105\1\0\4\105\2\0\16\105\1\211"+
    "\2\105\1\211\2\105\1\211\10\105\1\211\4\105\1\211"+
    "\7\105\1\0\2\212\1\213\1\0\1\214\11\212\2\0"+
    "\52\212\2\0\1\105\1\210\3\0\1\105\1\164\11\0"+
    "\3\105\1\0\1\105\10\0\11\105\1\0\4\105\1\0"+
    "\2\105\1\0\1\105\1\0\3\105\6\0\2\215\1\216"+
    "\1\0\4\215\1\214\5\215\2\0\52\215\1\0\2\112"+
    "\1\217\3\0\2\112\11\0\3\112\1\0\1\112\10\0"+
    "\11\112\1\0\4\112\1\0\2\112\1\0\1\112\1\0"+
    "\3\112\6\0\1\220\2\112\1\0\2\112\1\220\2\112"+
    "\1\0\4\112\2\0\16\112\1\220\2\112\1\220\2\112"+
    "\1\220\10\112\1\220\4\112\1\220\7\112\2\0\1\112"+
    "\1\217\3\0\1\112\1\164\11\0\3\112\1\0\1\112"+
    "\10\0\11\112\1\0\4\112\1\0\2\112\1\0\1\112"+
    "\1\0\3\112\7\0\1\112\1\217\3\0\1\112\1\221"+
    "\11\0\3\112\1\0\1\112\10\0\11\112\1\0\4\112"+
    "\1\0\2\112\1\0\1\112\1\0\3\112\6\0\1\120"+
    "\1\222\1\223\3\0\1\222\1\224\3\0\1\127\5\0"+
    "\3\222\1\0\1\222\10\0\11\222\1\0\4\222\1\0"+
    "\2\222\1\0\1\222\1\0\3\222\4\0\1\225\1\0"+
    "\2\121\1\226\3\0\2\121\3\0\1\227\5\0\3\121"+
    "\1\230\1\121\10\0\11\121\1\0\4\121\1\0\2\121"+
    "\1\0\1\121\1\0\3\121\6\0\1\231\2\121\1\0"+
    "\2\121\1\231\2\121\1\0\4\121\2\0\16\121\1\231"+
    "\2\121\1\231\2\121\1\231\10\121\1\231\4\121\1\231"+
    "\7\121\1\0\2\232\1\233\1\0\1\234\11\232\2\0"+
    "\52\232\1\0\1\120\1\121\1\226\3\0\1\121\1\164"+
    "\3\0\1\127\5\0\3\121\1\0\1\121\10\0\11\121"+
    "\1\0\4\121\1\0\2\121\1\0\1\121\1\0\3\121"+
    "\6\0\2\235\1\236\1\0\4\235\1\234\5\235\2\0"+
    "\52\235\1\0\1\127\1\222\1\223\3\0\1\222\1\224"+
    "\11\0\3\222\1\0\1\222\10\0\11\222\1\0\4\222"+
    "\1\0\2\222\1\0\1\222\1\0\3\222\4\0\1\225"+
    "\1\0\1\120\12\0\1\127\57\0\2\237\1\240\3\0"+
    "\2\237\11\0\3\237\1\0\1\237\10\0\11\237\1\0"+
    "\4\237\1\0\2\237\1\0\1\237\1\0\3\237\6\0"+
    "\2\121\1\226\3\0\2\121\3\0\1\227\1\241\4\0"+
    "\1\121\1\242\1\121\1\230\1\121\10\0\11\121\1\0"+
    "\4\121\1\0\2\121\1\0\1\121\1\0\3\121\11\0"+
    "\1\243\1\0\1\243\3\0\1\243\4\0\2\243\30\0"+
    "\1\244\21\0\4\245\1\136\1\245\1\136\3\245\1\136"+
    "\4\245\2\136\12\245\1\0\14\245\1\0\22\245\1\0"+
    "\1\246\1\26\1\140\1\26\1\0\1\26\1\246\1\26"+
    "\1\0\1\26\4\0\2\26\1\0\3\26\1\0\1\26"+
    "\10\0\1\246\2\26\1\246\2\26\1\246\2\26\1\0"+
    "\4\26\1\0\1\246\1\26\1\0\1\26\1\0\1\246"+
    "\2\26\6\0\2\25\1\137\3\0\2\25\11\0\3\25"+
    "\1\0\1\25\3\0\1\247\4\0\11\25\1\0\4\25"+
    "\1\0\2\25\1\0\1\25\1\0\3\25\6\0\1\250"+
    "\2\143\1\0\2\143\1\250\2\143\1\0\4\143\2\0"+
    "\16\143\1\250\2\143\1\250\2\143\1\250\10\143\1\250"+
    "\4\143\1\250\7\143\1\0\1\251\2\145\1\0\2\145"+
    "\1\251\2\145\1\0\4\145\2\0\16\145\1\251\2\145"+
    "\1\251\2\145\1\251\10\145\1\251\4\145\1\251\7\145"+
    "\10\0\1\252\62\0\35\150\1\253\35\150\41\0\1\254"+
    "\103\0\1\255\65\0\2\256\66\0\2\257\103\0\1\260"+
    "\17\0\2\156\1\157\3\0\2\156\11\0\3\156\1\0"+
    "\1\156\10\0\11\156\1\0\4\156\1\0\2\156\1\0"+
    "\1\156\1\0\3\156\6\0\1\261\2\156\1\0\2\156"+
    "\1\261\2\156\1\0\4\156\2\0\16\156\1\261\2\156"+
    "\1\261\2\156\1\261\10\156\1\261\4\156\1\261\7\156"+
    "\2\0\1\156\1\157\3\0\1\156\12\0\3\156\1\0"+
    "\1\156\10\0\11\156\1\0\4\156\1\0\2\156\1\0"+
    "\1\156\1\0\3\156\6\0\1\262\1\161\1\162\1\161"+
    "\1\263\1\161\1\262\10\161\1\264\16\161\1\262\2\161"+
    "\1\262\2\161\1\262\10\161\1\262\4\161\1\262\7\161"+
    "\32\0\1\247\41\0\1\265\1\165\1\166\3\165\1\265"+
    "\1\165\1\266\6\165\1\267\16\165\1\265\2\165\1\265"+
    "\2\165\1\265\10\165\1\265\4\165\1\265\7\165\1\0"+
    "\1\270\1\167\1\170\1\167\1\271\1\167\1\270\10\167"+
    "\1\272\16\167\1\270\2\167\1\270\2\167\1\270\10\167"+
    "\1\270\4\167\1\270\7\167\1\0\1\273\1\172\1\173"+
    "\3\172\1\273\1\172\1\274\6\172\1\275\16\172\1\273"+
    "\2\172\1\273\2\172\1\273\10\172\1\273\4\172\1\273"+
    "\7\172\24\0\1\276\47\0\1\277\1\54\1\175\1\54"+
    "\1\0\1\54\1\277\1\54\1\0\1\54\4\0\2\54"+
    "\1\0\3\54\1\0\1\54\10\0\1\277\2\54\1\277"+
    "\2\54\1\277\2\54\1\0\4\54\1\0\1\277\1\54"+
    "\1\0\1\54\1\0\1\277\2\54\6\0\1\300\1\60"+
    "\1\177\1\60\1\0\1\60\1\300\1\60\1\0\1\60"+
    "\4\0\2\60\1\0\3\60\1\0\1\60\10\0\1\300"+
    "\2\60\1\300\2\60\1\300\2\60\1\0\4\60\1\0"+
    "\1\300\1\60\1\0\1\60\1\0\1\300\2\60\6\0"+
    "\1\301\1\65\1\201\1\65\1\0\1\65\1\301\1\65"+
    "\1\0\1\65\4\0\2\65\1\0\3\65\1\0\1\65"+
    "\10\0\1\301\2\65\1\301\2\65\1\301\2\65\1\0"+
    "\4\65\1\0\1\301\1\65\1\0\1\65\1\0\1\301"+
    "\2\65\7\0\1\65\1\201\3\0\1\65\12\0\3\65"+
    "\1\0\1\65\10\0\11\65\1\0\4\65\1\0\2\65"+
    "\1\0\1\65\1\0\3\65\6\0\1\302\1\25\1\137"+
    "\1\25\1\0\1\25\1\302\1\25\1\0\1\25\4\0"+
    "\2\25\1\0\3\25\1\0\1\25\10\0\1\302\2\25"+
    "\1\302\2\25\1\302\2\25\1\0\4\25\1\0\1\302"+
    "\1\25\1\0\1\25\1\0\1\302\2\25\6\0\1\303"+
    "\1\77\1\206\1\77\1\0\1\77\1\303\1\77\1\0"+
    "\1\77\4\0\2\77\1\0\3\77\1\0\1\77\10\0"+
    "\1\303\2\77\1\303\2\77\1\303\2\77\1\0\4\77"+
    "\1\0\1\303\1\77\1\0\1\77\1\0\1\303\2\77"+
    "\6\0\1\304\1\105\1\210\1\105\1\0\1\105\1\304"+
    "\1\105\1\0\1\105\4\0\2\105\1\0\3\105\1\0"+
    "\1\105\10\0\1\304\2\105\1\304\2\105\1\304\2\105"+
    "\1\0\4\105\1\0\1\304\1\105\1\0\1\105\1\0"+
    "\1\304\2\105\6\0\1\305\1\212\1\213\1\212\1\306"+
    "\1\212\1\305\10\212\1\307\16\212\1\305\2\212\1\305"+
    "\2\212\1\305\10\212\1\305\4\212\1\305\7\212\1\0"+
    "\1\310\1\215\1\216\3\215\1\310\1\215\1\311\6\215"+
    "\1\312\16\215\1\310\2\215\1\310\2\215\1\310\10\215"+
    "\1\310\4\215\1\310\7\215\1\0\1\313\1\112\1\217"+
    "\1\112\1\0\1\112\1\313\1\112\1\0\1\112\4\0"+
    "\2\112\1\0\3\112\1\0\1\112\10\0\1\313\2\112"+
    "\1\313\2\112\1\313\2\112\1\0\4\112\1\0\1\313"+
    "\1\112\1\0\1\112\1\0\1\313\2\112\7\0\1\112"+
    "\1\217\3\0\1\112\12\0\3\112\1\0\1\112\10\0"+
    "\11\112\1\0\4\112\1\0\2\112\1\0\1\112\1\0"+
    "\3\112\6\0\2\222\1\223\3\0\2\222\11\0\3\222"+
    "\1\0\1\222\10\0\11\222\1\0\4\222\1\0\2\222"+
    "\1\0\1\222\1\0\3\222\6\0\1\314\2\222\1\0"+
    "\2\222\1\314\2\222\1\0\4\222\2\0\16\222\1\314"+
    "\2\222\1\314\2\222\1\314\10\222\1\314\4\222\1\314"+
    "\7\222\2\0\1\222\1\223\3\0\1\222\12\0\3\222"+
    "\1\0\1\222\10\0\11\222\1\0\4\222\1\0\2\222"+
    "\1\0\1\222\1\0\3\222\6\0\2\315\1\316\3\0"+
    "\2\315\11\0\3\315\1\0\1\315\10\0\11\315\1\0"+
    "\4\315\1\0\2\315\1\0\1\315\1\0\3\315\6\0"+
    "\1\317\1\121\1\226\1\121\1\0\1\121\1\317\1\121"+
    "\1\0\1\121\1\0\1\227\2\0\2\121\1\0\3\121"+
    "\1\230\1\121\10\0\1\317\2\121\1\317\2\121\1\317"+
    "\2\121\1\0\4\121\1\0\1\317\1\121\1\0\1\121"+
    "\1\0\1\317\2\121\6\0\1\320\1\232\1\233\1\232"+
    "\1\321\1\232\1\320\10\232\1\322\16\232\1\320\2\232"+
    "\1\320\2\232\1\320\10\232\1\320\4\232\1\320\7\232"+
    "\1\0\1\323\1\235\1\236\3\235\1\323\1\235\1\324"+
    "\6\235\1\325\16\235\1\323\2\235\1\323\2\235\1\323"+
    "\10\235\1\323\4\235\1\323\7\235\1\0\1\326\2\237"+
    "\1\0\2\237\1\326\2\237\1\0\4\237\2\0\16\237"+
    "\1\326\2\237\1\326\2\237\1\326\10\237\1\326\4\237"+
    "\1\326\7\237\1\0\1\327\5\0\1\327\16\0\2\327"+
    "\7\0\2\327\1\0\2\327\1\0\2\327\7\0\2\327"+
    "\3\0\2\327\7\0\2\121\1\226\3\0\2\121\3\0"+
    "\1\227\5\0\2\121\1\330\1\230\1\121\10\0\11\121"+
    "\1\0\4\121\1\0\2\121\1\0\1\121\1\0\3\121"+
    "\57\0\1\331\21\0\1\332\1\26\1\140\1\26\1\0"+
    "\1\26\1\332\1\26\1\0\1\26\4\0\2\26\1\0"+
    "\3\26\1\0\1\26\10\0\1\332\2\26\1\332\2\26"+
    "\1\332\2\26\1\0\4\26\1\0\1\332\1\26\1\0"+
    "\1\26\1\0\1\332\2\26\6\0\1\333\1\143\1\144"+
    "\1\143\1\0\1\143\1\333\1\143\1\0\1\143\4\0"+
    "\2\143\1\0\3\143\1\0\1\143\10\0\1\333\2\143"+
    "\1\333\2\143\1\333\2\143\1\0\4\143\1\0\1\333"+
    "\1\143\1\0\1\143\1\0\1\333\2\143\6\0\1\334"+
    "\1\145\1\146\1\145\1\0\1\145\1\334\1\145\1\0"+
    "\1\145\4\0\2\145\1\0\3\145\1\0\1\145\10\0"+
    "\1\334\2\145\1\334\2\145\1\334\2\145\1\0\4\145"+
    "\1\0\1\334\1\145\1\0\1\145\1\0\1\334\2\145"+
    "\15\0\1\335\62\0\34\150\1\336\1\253\35\150\42\0"+
    "\2\337\102\0\1\340\75\0\2\341\74\0\1\342\76\0"+
    "\1\343\6\0\1\344\1\156\1\157\1\156\1\0\1\156"+
    "\1\344\1\156\1\0\1\156\4\0\2\156\1\0\3\156"+
    "\1\0\1\156\10\0\1\344\2\156\1\344\2\156\1\344"+
    "\2\156\1\0\4\156\1\0\1\344\1\156\1\0\1\156"+
    "\1\0\1\344\2\156\6\0\1\345\1\161\1\162\1\161"+
    "\1\163\1\161\1\345\27\161\1\345\2\161\1\345\2\161"+
    "\1\345\10\161\1\345\4\161\1\345\7\161\1\0\2\161"+
    "\1\162\1\0\1\163\12\161\1\0\52\161\1\0\1\346"+
    "\1\165\1\166\3\165\1\346\1\165\1\163\25\165\1\346"+
    "\2\165\1\346\2\165\1\346\10\165\1\346\4\165\1\346"+
    "\7\165\1\0\2\165\1\166\1\0\4\165\1\163\6\165"+
    "\1\0\52\165\1\0\1\347\1\167\1\170\1\167\1\171"+
    "\1\167\1\347\27\167\1\347\2\167\1\347\2\167\1\347"+
    "\10\167\1\347\4\167\1\347\7\167\1\0\2\167\1\170"+
    "\1\0\1\171\12\167\1\0\52\167\1\0\1\350\1\172"+
    "\1\173\3\172\1\350\1\172\1\171\25\172\1\350\2\172"+
    "\1\350\2\172\1\350\10\172\1\350\4\172\1\350\7\172"+
    "\1\0\2\172\1\173\1\0\4\172\1\171\6\172\1\0"+
    "\52\172\25\0\1\351\46\0\1\352\1\54\1\175\1\54"+
    "\1\0\1\54\1\352\1\54\1\0\1\54\4\0\2\54"+
    "\1\0\3\54\1\0\1\54\10\0\1\352\2\54\1\352"+
    "\2\54\1\352\2\54\1\0\4\54\1\0\1\352\1\54"+
    "\1\0\1\54\1\0\1\352\2\54\6\0\1\353\1\60"+
    "\1\177\1\60\1\0\1\60\1\353\1\60\1\0\1\60"+
    "\4\0\2\60\1\0\3\60\1\0\1\60\10\0\1\353"+
    "\2\60\1\353\2\60\1\353\2\60\1\0\4\60\1\0"+
    "\1\353\1\60\1\0\1\60\1\0\1\353\2\60\6\0"+
    "\1\354\1\65\1\201\1\65\1\0\1\65\1\354\1\65"+
    "\1\0\1\65\4\0\2\65\1\0\3\65\1\0\1\65"+
    "\10\0\1\354\2\65\1\354\2\65\1\354\2\65\1\0"+
    "\4\65\1\0\1\354\1\65\1\0\1\65\1\0\1\354"+
    "\2\65\6\0\1\355\1\25\1\137\1\25\1\0\1\25"+
    "\1\355\1\25\1\0\1\25\4\0\2\25\1\0\3\25"+
    "\1\0\1\25\10\0\1\355\2\25\1\355\2\25\1\355"+
    "\2\25\1\0\4\25\1\0\1\355\1\25\1\0\1\25"+
    "\1\0\1\355\2\25\6\0\1\356\1\77\1\206\1\77"+
    "\1\0\1\77\1\356\1\77\1\0\1\77\4\0\2\77"+
    "\1\0\3\77\1\0\1\77\10\0\1\356\2\77\1\356"+
    "\2\77\1\356\2\77\1\0\4\77\1\0\1\356\1\77"+
    "\1\0\1\77\1\0\1\356\2\77\6\0\1\357\1\105"+
    "\1\210\1\105\1\0\1\105\1\357\1\105\1\0\1\105"+
    "\4\0\2\105\1\0\3\105\1\0\1\105\10\0\1\357"+
    "\2\105\1\357\2\105\1\357\2\105\1\0\4\105\1\0"+
    "\1\357\1\105\1\0\1\105\1\0\1\357\2\105\6\0"+
    "\1\360\1\212\1\213\1\212\1\214\1\212\1\360\27\212"+
    "\1\360\2\212\1\360\2\212\1\360\10\212\1\360\4\212"+
    "\1\360\7\212\1\0\2\212\1\213\1\0\1\214\12\212"+
    "\1\0\52\212\1\0\1\361\1\215\1\216\3\215\1\361"+
    "\1\215\1\214\25\215\1\361\2\215\1\361\2\215\1\361"+
    "\10\215\1\361\4\215\1\361\7\215\1\0\2\215\1\216"+
    "\1\0\4\215\1\214\6\215\1\0\52\215\1\0\1\362"+
    "\1\112\1\217\1\112\1\0\1\112\1\362\1\112\1\0"+
    "\1\112\4\0\2\112\1\0\3\112\1\0\1\112\10\0"+
    "\1\362\2\112\1\362\2\112\1\362\2\112\1\0\4\112"+
    "\1\0\1\362\1\112\1\0\1\112\1\0\1\362\2\112"+
    "\6\0\1\363\1\222\1\223\1\222\1\0\1\222\1\363"+
    "\1\222\1\0\1\222\4\0\2\222\1\0\3\222\1\0"+
    "\1\222\10\0\1\363\2\222\1\363\2\222\1\363\2\222"+
    "\1\0\4\222\1\0\1\363\1\222\1\0\1\222\1\0"+
    "\1\363\2\222\6\0\2\315\1\316\3\0\2\315\3\0"+
    "\1\227\5\0\3\315\1\0\1\315\10\0\11\315\1\0"+
    "\4\315\1\0\2\315\1\0\1\315\1\0\3\315\6\0"+
    "\1\364\2\315\1\0\2\315\1\364\2\315\1\0\4\315"+
    "\2\0\16\315\1\364\2\315\1\364\2\315\1\364\10\315"+
    "\1\364\4\315\1\364\7\315\1\0\1\365\1\121\1\226"+
    "\1\121\1\0\1\121\1\365\1\121\1\0\1\121\1\0"+
    "\1\227\2\0\2\121\1\0\3\121\1\230\1\121\10\0"+
    "\1\365\2\121\1\365\2\121\1\365\2\121\1\0\4\121"+
    "\1\0\1\365\1\121\1\0\1\121\1\0\1\365\2\121"+
    "\6\0\1\366\1\232\1\233\1\232\1\234\1\232\1\366"+
    "\27\232\1\366\2\232\1\366\2\232\1\366\10\232\1\366"+
    "\4\232\1\366\7\232\1\0\2\232\1\233\1\0\1\234"+
    "\12\232\1\0\52\232\1\0\1\367\1\235\1\236\3\235"+
    "\1\367\1\235\1\234\25\235\1\367\2\235\1\367\2\235"+
    "\1\367\10\235\1\367\4\235\1\367\7\235\1\0\2\235"+
    "\1\236\1\0\4\235\1\234\6\235\1\0\52\235\1\0"+
    "\1\370\1\237\1\240\1\237\1\0\1\237\1\370\1\237"+
    "\1\0\1\237\4\0\2\237\1\0\3\237\1\0\1\237"+
    "\10\0\1\370\2\237\1\370\2\237\1\370\2\237\1\0"+
    "\4\237\1\0\1\370\1\237\1\0\1\237\1\0\1\370"+
    "\2\237\6\0\1\371\5\0\1\371\1\372\15\0\2\371"+
    "\7\0\2\371\1\0\2\371\1\0\2\371\7\0\2\371"+
    "\3\0\2\371\7\0\2\121\1\226\3\0\2\121\3\0"+
    "\1\227\5\0\3\121\1\373\1\121\10\0\11\121\1\0"+
    "\4\121\1\0\2\121\1\0\1\121\1\0\3\121\60\0"+
    "\1\374\20\0\1\375\1\26\1\140\1\26\1\0\1\26"+
    "\1\375\1\26\1\0\1\26\4\0\2\26\1\0\3\26"+
    "\1\0\1\26\10\0\1\375\2\26\1\375\2\26\1\375"+
    "\2\26\1\0\4\26\1\0\1\375\1\26\1\0\1\26"+
    "\1\0\1\375\2\26\6\0\1\376\1\143\1\144\1\143"+
    "\1\0\1\143\1\376\1\143\1\0\1\143\4\0\2\143"+
    "\1\0\3\143\1\0\1\143\10\0\1\376\2\143\1\376"+
    "\2\143\1\376\2\143\1\0\4\143\1\0\1\376\1\143"+
    "\1\0\1\143\1\0\1\376\2\143\6\0\1\377\1\145"+
    "\1\146\1\145\1\0\1\145\1\377\1\145\1\0\1\145"+
    "\4\0\2\145\1\0\3\145\1\0\1\145\10\0\1\377"+
    "\2\145\1\377\2\145\1\377\2\145\1\0\4\145\1\0"+
    "\1\377\1\145\1\0\1\145\1\0\1\377\2\145\30\0"+
    "\1\u0100\123\0\1\u0101\67\0\1\u0102\66\0\2\u0103\73\0"+
    "\1\u0104\24\0\1\u0105\1\156\1\157\1\156\1\0\1\156"+
    "\1\u0105\1\156\1\0\1\156\4\0\2\156\1\0\3\156"+
    "\1\0\1\156\10\0\1\u0105\2\156\1\u0105\2\156\1\u0105"+
    "\2\156\1\0\4\156\1\0\1\u0105\1\156\1\0\1\156"+
    "\1\0\1\u0105\2\156\6\0\1\u0106\1\161\1\162\1\161"+
    "\1\163\1\161\1\u0106\27\161\1\u0106\2\161\1\u0106\2\161"+
    "\1\u0106\10\161\1\u0106\4\161\1\u0106\7\161\1\0\1\u0107"+
    "\1\165\1\166\3\165\1\u0107\1\165\1\163\25\165\1\u0107"+
    "\2\165\1\u0107\2\165\1\u0107\10\165\1\u0107\4\165\1\u0107"+
    "\7\165\1\0\1\u0108\1\167\1\170\1\167\1\171\1\167"+
    "\1\u0108\27\167\1\u0108\2\167\1\u0108\2\167\1\u0108\10\167"+
    "\1\u0108\4\167\1\u0108\7\167\1\0\1\u0109\1\172\1\173"+
    "\3\172\1\u0109\1\172\1\171\25\172\1\u0109\2\172\1\u0109"+
    "\2\172\1\u0109\10\172\1\u0109\4\172\1\u0109\7\172\1\0"+
    "\2\u010a\1\u010b\1\351\1\u010c\1\351\2\u010a\1\u010d\1\351"+
    "\1\u010e\3\u010a\2\351\4\u010a\1\0\45\u010a\1\0\1\u010f"+
    "\1\54\1\175\1\54\1\0\1\54\1\u010f\1\54\1\0"+
    "\1\54\4\0\2\54\1\0\3\54\1\0\1\54\10\0"+
    "\1\u010f\2\54\1\u010f\2\54\1\u010f\2\54\1\0\4\54"+
    "\1\0\1\u010f\1\54\1\0\1\54\1\0\1\u010f\2\54"+
    "\6\0\1\u0110\1\60\1\177\1\60\1\0\1\60\1\u0110"+
    "\1\60\1\0\1\60\4\0\2\60\1\0\3\60\1\0"+
    "\1\60\10\0\1\u0110\2\60\1\u0110\2\60\1\u0110\2\60"+
    "\1\0\4\60\1\0\1\u0110\1\60\1\0\1\60\1\0"+
    "\1\u0110\2\60\6\0\1\u0111\1\65\1\201\1\65\1\0"+
    "\1\65\1\u0111\1\65\1\0\1\65\4\0\2\65\1\0"+
    "\3\65\1\0\1\65\10\0\1\u0111\2\65\1\u0111\2\65"+
    "\1\u0111\2\65\1\0\4\65\1\0\1\u0111\1\65\1\0"+
    "\1\65\1\0\1\u0111\2\65\6\0\1\u0112\1\25\1\137"+
    "\1\25\1\0\1\25\1\u0112\1\25\1\0\1\25\4\0"+
    "\2\25\1\0\3\25\1\0\1\25\10\0\1\u0112\2\25"+
    "\1\u0112\2\25\1\u0112\2\25\1\0\4\25\1\0\1\u0112"+
    "\1\25\1\0\1\25\1\0\1\u0112\2\25\6\0\1\u0113"+
    "\1\77\1\206\1\77\1\0\1\77\1\u0113\1\77\1\0"+
    "\1\77\4\0\2\77\1\0\3\77\1\0\1\77\10\0"+
    "\1\u0113\2\77\1\u0113\2\77\1\u0113\2\77\1\0\4\77"+
    "\1\0\1\u0113\1\77\1\0\1\77\1\0\1\u0113\2\77"+
    "\6\0\1\u0114\1\105\1\210\1\105\1\0\1\105\1\u0114"+
    "\1\105\1\0\1\105\4\0\2\105\1\0\3\105\1\0"+
    "\1\105\10\0\1\u0114\2\105\1\u0114\2\105\1\u0114\2\105"+
    "\1\0\4\105\1\0\1\u0114\1\105\1\0\1\105\1\0"+
    "\1\u0114\2\105\6\0\1\u0115\1\212\1\213\1\212\1\214"+
    "\1\212\1\u0115\27\212\1\u0115\2\212\1\u0115\2\212\1\u0115"+
    "\10\212\1\u0115\4\212\1\u0115\7\212\1\0\1\u0116\1\215"+
    "\1\216\3\215\1\u0116\1\215\1\214\25\215\1\u0116\2\215"+
    "\1\u0116\2\215\1\u0116\10\215\1\u0116\4\215\1\u0116\7\215"+
    "\1\0\1\u0117\1\112\1\217\1\112\1\0\1\112\1\u0117"+
    "\1\112\1\0\1\112\4\0\2\112\1\0\3\112\1\0"+
    "\1\112\10\0\1\u0117\2\112\1\u0117\2\112\1\u0117\2\112"+
    "\1\0\4\112\1\0\1\u0117\1\112\1\0\1\112\1\0"+
    "\1\u0117\2\112\6\0\1\u0118\1\222\1\223\1\222\1\0"+
    "\1\222\1\u0118\1\222\1\0\1\222\4\0\2\222\1\0"+
    "\3\222\1\0\1\222\10\0\1\u0118\2\222\1\u0118\2\222"+
    "\1\u0118\2\222\1\0\4\222\1\0\1\u0118\1\222\1\0"+
    "\1\222\1\0\1\u0118\2\222\6\0\1\u0119\1\315\1\316"+
    "\1\315\1\0\1\315\1\u0119\1\315\1\0\1\315\1\0"+
    "\1\227\2\0\2\315\1\0\3\315\1\0\1\315\10\0"+
    "\1\u0119\2\315\1\u0119\2\315\1\u0119\2\315\1\0\4\315"+
    "\1\0\1\u0119\1\315\1\0\1\315\1\0\1\u0119\2\315"+
    "\6\0\1\u011a\1\121\1\226\1\121\1\0\1\121\1\u011a"+
    "\1\121\1\0\1\121\1\0\1\227\2\0\2\121\1\0"+
    "\3\121\1\230\1\121\10\0\1\u011a\2\121\1\u011a\2\121"+
    "\1\u011a\2\121\1\0\4\121\1\0\1\u011a\1\121\1\0"+
    "\1\121\1\0\1\u011a\2\121\6\0\1\u011b\1\232\1\233"+
    "\1\232\1\234\1\232\1\u011b\27\232\1\u011b\2\232\1\u011b"+
    "\2\232\1\u011b\10\232\1\u011b\4\232\1\u011b\7\232\1\0"+
    "\1\u011c\1\235\1\236\3\235\1\u011c\1\235\1\234\25\235"+
    "\1\u011c\2\235\1\u011c\2\235\1\u011c\10\235\1\u011c\4\235"+
    "\1\u011c\7\235\1\0\1\u011d\1\237\1\240\1\237\1\0"+
    "\1\237\1\u011d\1\237\1\0\1\237\4\0\2\237\1\0"+
    "\3\237\1\0\1\237\10\0\1\u011d\2\237\1\u011d\2\237"+
    "\1\u011d\2\237\1\0\4\237\1\0\1\u011d\1\237\1\0"+
    "\1\237\1\0\1\u011d\2\237\6\0\1\u011e\5\0\1\u011e"+
    "\1\372\15\0\2\u011e\7\0\2\u011e\1\0\2\u011e\1\0"+
    "\2\u011e\7\0\2\u011e\3\0\2\u011e\7\0\1\u011f\5\0"+
    "\1\u011f\16\0\2\u011f\7\0\2\u011f\1\0\2\u011f\1\0"+
    "\2\u011f\7\0\2\u011f\3\0\2\u011f\7\0\2\u0120\1\u0121"+
    "\1\u0122\1\u0123\1\u0122\2\u0120\1\u0124\1\u0122\1\u0125\3\u0120"+
    "\2\u0122\4\u0120\1\0\45\u0120\54\0\1\u0126\17\0\1\u0127"+
    "\1\26\1\140\1\26\1\0\1\26\1\u0127\1\26\1\0"+
    "\1\26\4\0\2\26\1\0\3\26\1\0\1\26\10\0"+
    "\1\u0127\2\26\1\u0127\2\26\1\u0127\2\26\1\0\4\26"+
    "\1\0\1\u0127\1\26\1\0\1\26\1\0\1\u0127\2\26"+
    "\6\0\1\u0128\1\143\1\144\1\143\1\0\1\143\1\u0128"+
    "\1\143\1\0\1\143\4\0\2\143\1\0\3\143\1\0"+
    "\1\143\10\0\1\u0128\2\143\1\u0128\2\143\1\u0128\2\143"+
    "\1\0\4\143\1\0\1\u0128\1\143\1\0\1\143\1\0"+
    "\1\u0128\2\143\6\0\1\u0129\1\145\1\146\1\145\1\0"+
    "\1\145\1\u0129\1\145\1\0\1\145\4\0\2\145\1\0"+
    "\3\145\1\0\1\145\10\0\1\u0129\2\145\1\u0129\2\145"+
    "\1\u0129\2\145\1\0\4\145\1\0\1\u0129\1\145\1\0"+
    "\1\145\1\0\1\u0129\2\145\51\0\1\u012a\51\0\1\u012b"+
    "\111\0\2\u012c\37\0\1\u012d\63\0\1\u012e\1\156\1\157"+
    "\1\156\1\0\1\156\1\u012e\1\156\1\0\1\156\4\0"+
    "\2\156\1\0\3\156\1\0\1\156\10\0\1\u012e\2\156"+
    "\1\u012e\2\156\1\u012e\2\156\1\0\4\156\1\0\1\u012e"+
    "\1\156\1\0\1\156\1\0\1\u012e\2\156\6\0\1\u012f"+
    "\1\161\1\162\1\161\1\163\1\161\1\u012f\27\161\1\u012f"+
    "\2\161\1\u012f\2\161\1\u012f\10\161\1\u012f\4\161\1\u012f"+
    "\7\161\1\0\1\u0130\1\165\1\166\3\165\1\u0130\1\165"+
    "\1\163\25\165\1\u0130\2\165\1\u0130\2\165\1\u0130\10\165"+
    "\1\u0130\4\165\1\u0130\7\165\1\0\1\u0131\1\167\1\170"+
    "\1\167\1\171\1\167\1\u0131\27\167\1\u0131\2\167\1\u0131"+
    "\2\167\1\u0131\10\167\1\u0131\4\167\1\u0131\7\167\1\0"+
    "\1\u0132\1\172\1\173\3\172\1\u0132\1\172\1\171\25\172"+
    "\1\u0132\2\172\1\u0132\2\172\1\u0132\10\172\1\u0132\4\172"+
    "\1\u0132\7\172\1\0\2\u010a\1\u010b\1\u0133\1\0\3\u010a"+
    "\1\0\1\u0133\1\u010e\3\u010a\2\u0133\4\u010a\1\0\45\u010a"+
    "\1\0\1\u0134\1\u010a\1\u010b\1\u0133\2\u010a\1\u0134\2\u010a"+
    "\1\u0133\1\u0135\3\u010a\2\u0133\16\u010a\1\u0134\2\u010a\1\u0134"+
    "\2\u010a\1\u0134\10\u010a\1\u0134\4\u010a\1\u0134\7\u010a\1\0"+
    "\2\u010c\1\u0136\1\0\1\u0133\11\u010c\2\0\52\u010c\1\0"+
    "\2\u010d\1\u0137\1\0\4\u010d\1\u0133\5\u010d\2\0\52\u010d"+
    "\1\0\1\u0138\1\54\1\175\1\54\1\0\1\54\1\u0138"+
    "\1\54\1\0\1\54\4\0\2\54\1\0\3\54\1\0"+
    "\1\54\10\0\1\u0138\2\54\1\u0138\2\54\1\u0138\2\54"+
    "\1\0\4\54\1\0\1\u0138\1\54\1\0\1\54\1\0"+
    "\1\u0138\2\54\6\0\1\u0139\1\60\1\177\1\60\1\0"+
    "\1\60\1\u0139\1\60\1\0\1\60\4\0\2\60\1\0"+
    "\3\60\1\0\1\60\10\0\1\u0139\2\60\1\u0139\2\60"+
    "\1\u0139\2\60\1\0\4\60\1\0\1\u0139\1\60\1\0"+
    "\1\60\1\0\1\u0139\2\60\6\0\1\u013a\1\65\1\201"+
    "\1\65\1\0\1\65\1\u013a\1\65\1\0\1\65\4\0"+
    "\2\65\1\0\3\65\1\0\1\65\10\0\1\u013a\2\65"+
    "\1\u013a\2\65\1\u013a\2\65\1\0\4\65\1\0\1\u013a"+
    "\1\65\1\0\1\65\1\0\1\u013a\2\65\6\0\1\u013b"+
    "\1\25\1\137\1\25\1\0\1\25\1\u013b\1\25\1\0"+
    "\1\25\4\0\2\25\1\0\3\25\1\0\1\25\10\0"+
    "\1\u013b\2\25\1\u013b\2\25\1\u013b\2\25\1\0\4\25"+
    "\1\0\1\u013b\1\25\1\0\1\25\1\0\1\u013b\2\25"+
    "\6\0\1\u013c\1\77\1\206\1\77\1\0\1\77\1\u013c"+
    "\1\77\1\0\1\77\4\0\2\77\1\0\3\77\1\0"+
    "\1\77\10\0\1\u013c\2\77\1\u013c\2\77\1\u013c\2\77"+
    "\1\0\4\77\1\0\1\u013c\1\77\1\0\1\77\1\0"+
    "\1\u013c\2\77\6\0\1\u013d\1\105\1\210\1\105\1\0"+
    "\1\105\1\u013d\1\105\1\0\1\105\4\0\2\105\1\0"+
    "\3\105\1\0\1\105\10\0\1\u013d\2\105\1\u013d\2\105"+
    "\1\u013d\2\105\1\0\4\105\1\0\1\u013d\1\105\1\0"+
    "\1\105\1\0\1\u013d\2\105\6\0\1\u013e\1\212\1\213"+
    "\1\212\1\214\1\212\1\u013e\27\212\1\u013e\2\212\1\u013e"+
    "\2\212\1\u013e\10\212\1\u013e\4\212\1\u013e\7\212\1\0"+
    "\1\u013f\1\215\1\216\3\215\1\u013f\1\215\1\214\25\215"+
    "\1\u013f\2\215\1\u013f\2\215\1\u013f\10\215\1\u013f\4\215"+
    "\1\u013f\7\215\1\0\1\u0140\1\112\1\217\1\112\1\0"+
    "\1\112\1\u0140\1\112\1\0\1\112\4\0\2\112\1\0"+
    "\3\112\1\0\1\112\10\0\1\u0140\2\112\1\u0140\2\112"+
    "\1\u0140\2\112\1\0\4\112\1\0\1\u0140\1\112\1\0"+
    "\1\112\1\0\1\u0140\2\112\6\0\1\u0141\1\222\1\223"+
    "\1\222\1\0\1\222\1\u0141\1\222\1\0\1\222\4\0"+
    "\2\222\1\0\3\222\1\0\1\222\10\0\1\u0141\2\222"+
    "\1\u0141\2\222\1\u0141\2\222\1\0\4\222\1\0\1\u0141"+
    "\1\222\1\0\1\222\1\0\1\u0141\2\222\6\0\1\u0142"+
    "\1\315\1\316\1\315\1\0\1\315\1\u0142\1\315\1\0"+
    "\1\315\1\0\1\227\2\0\2\315\1\0\3\315\1\0"+
    "\1\315\10\0\1\u0142\2\315\1\u0142\2\315\1\u0142\2\315"+
    "\1\0\4\315\1\0\1\u0142\1\315\1\0\1\315\1\0"+
    "\1\u0142\2\315\6\0\1\u0143\1\121\1\226\1\121\1\0"+
    "\1\121\1\u0143\1\121\1\0\1\121\1\0\1\227\2\0"+
    "\2\121\1\0\3\121\1\230\1\121\10\0\1\u0143\2\121"+
    "\1\u0143\2\121\1\u0143\2\121\1\0\4\121\1\0\1\u0143"+
    "\1\121\1\0\1\121\1\0\1\u0143\2\121\6\0\1\u0144"+
    "\1\232\1\233\1\232\1\234\1\232\1\u0144\27\232\1\u0144"+
    "\2\232\1\u0144\2\232\1\u0144\10\232\1\u0144\4\232\1\u0144"+
    "\7\232\1\0\1\u0145\1\235\1\236\3\235\1\u0145\1\235"+
    "\1\234\25\235\1\u0145\2\235\1\u0145\2\235\1\u0145\10\235"+
    "\1\u0145\4\235\1\u0145\7\235\1\0\1\u0146\1\237\1\240"+
    "\1\237\1\0\1\237\1\u0146\1\237\1\0\1\237\4\0"+
    "\2\237\1\0\3\237\1\0\1\237\10\0\1\u0146\2\237"+
    "\1\u0146\2\237\1\u0146\2\237\1\0\4\237\1\0\1\u0146"+
    "\1\237\1\0\1\237\1\0\1\u0146\2\237\6\0\1\u0147"+
    "\5\0\1\u0147\1\372\15\0\2\u0147\7\0\2\u0147\1\0"+
    "\2\u0147\1\0\2\u0147\7\0\2\u0147\3\0\2\u0147\7\0"+
    "\1\u0148\5\0\1\u0148\16\0\2\u0148\7\0\2\u0148\1\0"+
    "\2\u0148\1\0\2\u0148\7\0\2\u0148\3\0\2\u0148\7\0"+
    "\2\u0120\1\u0121\1\u0149\1\0\3\u0120\1\0\1\u0149\1\u0125"+
    "\3\u0120\2\u0149\4\u0120\1\0\45\u0120\1\0\1\u014a\1\u0120"+
    "\1\u0121\1\u0149\2\u0120\1\u014a\2\u0120\1\u0149\1\u014b\3\u0120"+
    "\2\u0149\16\u0120\1\u014a\2\u0120\1\u014a\2\u0120\1\u014a\10\u0120"+
    "\1\u014a\4\u0120\1\u014a\7\u0120\1\0\2\u0123\1\u014c\1\0"+
    "\1\u0149\11\u0123\2\0\52\u0123\1\0\2\u0124\1\u014d\1\0"+
    "\4\u0124\1\u0149\5\u0124\2\0\52\u0124\23\0\1\u014e\50\0"+
    "\1\u014f\1\26\1\140\1\26\1\0\1\26\1\u014f\1\26"+
    "\1\0\1\26\4\0\2\26\1\0\3\26\1\0\1\26"+
    "\10\0\1\u014f\2\26\1\u014f\2\26\1\u014f\2\26\1\0"+
    "\4\26\1\0\1\u014f\1\26\1\0\1\26\1\0\1\u014f"+
    "\2\26\6\0\1\u0150\1\143\1\144\1\143\1\0\1\143"+
    "\1\u0150\1\143\1\0\1\143\4\0\2\143\1\0\3\143"+
    "\1\0\1\143\10\0\1\u0150\2\143\1\u0150\2\143\1\u0150"+
    "\2\143\1\0\4\143\1\0\1\u0150\1\143\1\0\1\143"+
    "\1\0\1\u0150\2\143\6\0\1\u0151\1\145\1\146\1\145"+
    "\1\0\1\145\1\u0151\1\145\1\0\1\145\4\0\2\145"+
    "\1\0\3\145\1\0\1\145\10\0\1\u0151\2\145\1\u0151"+
    "\2\145\1\u0151\2\145\1\0\4\145\1\0\1\u0151\1\145"+
    "\1\0\1\145\1\0\1\u0151\2\145\52\0\2\u0152\73\0"+
    "\1\u0153\106\0\2\u0154\7\0\1\u0155\1\156\1\157\1\156"+
    "\1\0\1\156\1\u0155\1\156\1\0\1\156\4\0\2\156"+
    "\1\0\3\156\1\0\1\156\10\0\1\u0155\2\156\1\u0155"+
    "\2\156\1\u0155\2\156\1\0\4\156\1\0\1\u0155\1\156"+
    "\1\0\1\156\1\0\1\u0155\2\156\6\0\1\u0156\1\161"+
    "\1\162\1\161\1\163\1\161\1\u0156\27\161\1\u0156\2\161"+
    "\1\u0156\2\161\1\u0156\10\161\1\u0156\4\161\1\u0156\7\161"+
    "\1\0\1\u0157\1\165\1\166\3\165\1\u0157\1\165\1\163"+
    "\25\165\1\u0157\2\165\1\u0157\2\165\1\u0157\10\165\1\u0157"+
    "\4\165\1\u0157\7\165\1\0\1\u0158\1\167\1\170\1\167"+
    "\1\171\1\167\1\u0158\27\167\1\u0158\2\167\1\u0158\2\167"+
    "\1\u0158\10\167\1\u0158\4\167\1\u0158\7\167\1\0\1\u0159"+
    "\1\172\1\173\3\172\1\u0159\1\172\1\171\25\172\1\u0159"+
    "\2\172\1\u0159\2\172\1\u0159\10\172\1\u0159\4\172\1\u0159"+
    "\7\172\4\0\1\u0133\1\0\1\u0133\3\0\1\u0133\1\u010e"+
    "\3\0\2\u0133\53\0\1\u015a\1\u010a\1\u010b\1\u010a\1\0"+
    "\1\u010a\1\u015a\1\u010a\1\0\1\u010a\1\u010e\11\u010a\1\0"+
    "\11\u010a\1\u015a\2\u010a\1\u015a\2\u010a\1\u015a\10\u010a\1\u015a"+
    "\4\u010a\1\u015a\7\u010a\1\0\1\u015b\1\u010c\1\u0136\1\u010c"+
    "\1\u015c\1\u010c\1\u015b\10\u010c\1\u015d\16\u010c\1\u015b\2\u010c"+
    "\1\u015b\2\u010c\1\u015b\10\u010c\1\u015b\4\u010c\1\u015b\7\u010c"+
    "\1\0\1\u015e\1\u010d\1\u0137\3\u010d\1\u015e\1\u010d\1\u015f"+
    "\6\u010d\1\u0160\16\u010d\1\u015e\2\u010d\1\u015e\2\u010d\1\u015e"+
    "\10\u010d\1\u015e\4\u010d\1\u015e\7\u010d\1\0\1\u0161\1\54"+
    "\1\175\1\54\1\0\1\54\1\u0161\1\54\1\0\1\54"+
    "\4\0\2\54\1\0\3\54\1\0\1\54\10\0\1\u0161"+
    "\2\54\1\u0161\2\54\1\u0161\2\54\1\0\4\54\1\0"+
    "\1\u0161\1\54\1\0\1\54\1\0\1\u0161\2\54\6\0"+
    "\1\u0162\1\60\1\177\1\60\1\0\1\60\1\u0162\1\60"+
    "\1\0\1\60\4\0\2\60\1\0\3\60\1\0\1\60"+
    "\10\0\1\u0162\2\60\1\u0162\2\60\1\u0162\2\60\1\0"+
    "\4\60\1\0\1\u0162\1\60\1\0\1\60\1\0\1\u0162"+
    "\2\60\6\0\1\u0163\1\65\1\201\1\65\1\0\1\65"+
    "\1\u0163\1\65\1\0\1\65\4\0\2\65\1\0\3\65"+
    "\1\0\1\65\10\0\1\u0163\2\65\1\u0163\2\65\1\u0163"+
    "\2\65\1\0\4\65\1\0\1\u0163\1\65\1\0\1\65"+
    "\1\0\1\u0163\2\65\6\0\1\u0164\1\25\1\137\1\25"+
    "\1\0\1\25\1\u0164\1\25\1\0\1\25\4\0\2\25"+
    "\1\0\3\25\1\0\1\25\10\0\1\u0164\2\25\1\u0164"+
    "\2\25\1\u0164\2\25\1\0\4\25\1\0\1\u0164\1\25"+
    "\1\0\1\25\1\0\1\u0164\2\25\6\0\1\u0165\1\77"+
    "\1\206\1\77\1\0\1\77\1\u0165\1\77\1\0\1\77"+
    "\4\0\2\77\1\0\3\77\1\0\1\77\10\0\1\u0165"+
    "\2\77\1\u0165\2\77\1\u0165\2\77\1\0\4\77\1\0"+
    "\1\u0165\1\77\1\0\1\77\1\0\1\u0165\2\77\6\0"+
    "\1\u0166\1\105\1\210\1\105\1\0\1\105\1\u0166\1\105"+
    "\1\0\1\105\4\0\2\105\1\0\3\105\1\0\1\105"+
    "\10\0\1\u0166\2\105\1\u0166\2\105\1\u0166\2\105\1\0"+
    "\4\105\1\0\1\u0166\1\105\1\0\1\105\1\0\1\u0166"+
    "\2\105\6\0\1\u0167\1\212\1\213\1\212\1\214\1\212"+
    "\1\u0167\27\212\1\u0167\2\212\1\u0167\2\212\1\u0167\10\212"+
    "\1\u0167\4\212\1\u0167\7\212\1\0\1\u0168\1\215\1\216"+
    "\3\215\1\u0168\1\215\1\214\25\215\1\u0168\2\215\1\u0168"+
    "\2\215\1\u0168\10\215\1\u0168\4\215\1\u0168\7\215\1\0"+
    "\1\u0169\1\112\1\217\1\112\1\0\1\112\1\u0169\1\112"+
    "\1\0\1\112\4\0\2\112\1\0\3\112\1\0\1\112"+
    "\10\0\1\u0169\2\112\1\u0169\2\112\1\u0169\2\112\1\0"+
    "\4\112\1\0\1\u0169\1\112\1\0\1\112\1\0\1\u0169"+
    "\2\112\6\0\1\u016a\1\222\1\223\1\222\1\0\1\222"+
    "\1\u016a\1\222\1\0\1\222\4\0\2\222\1\0\3\222"+
    "\1\0\1\222\10\0\1\u016a\2\222\1\u016a\2\222\1\u016a"+
    "\2\222\1\0\4\222\1\0\1\u016a\1\222\1\0\1\222"+
    "\1\0\1\u016a\2\222\6\0\1\u016b\1\315\1\316\1\315"+
    "\1\0\1\315\1\u016b\1\315\1\0\1\315\1\0\1\227"+
    "\2\0\2\315\1\0\3\315\1\0\1\315\10\0\1\u016b"+
    "\2\315\1\u016b\2\315\1\u016b\2\315\1\0\4\315\1\0"+
    "\1\u016b\1\315\1\0\1\315\1\0\1\u016b\2\315\6\0"+
    "\1\u016c\1\121\1\226\1\121\1\0\1\121\1\u016c\1\121"+
    "\1\0\1\121\1\0\1\227\2\0\2\121\1\0\3\121"+
    "\1\230\1\121\10\0\1\u016c\2\121\1\u016c\2\121\1\u016c"+
    "\2\121\1\0\4\121\1\0\1\u016c\1\121\1\0\1\121"+
    "\1\0\1\u016c\2\121\6\0\1\u016d\1\232\1\233\1\232"+
    "\1\234\1\232\1\u016d\27\232\1\u016d\2\232\1\u016d\2\232"+
    "\1\u016d\10\232\1\u016d\4\232\1\u016d\7\232\1\0\1\u016e"+
    "\1\235\1\236\3\235\1\u016e\1\235\1\234\25\235\1\u016e"+
    "\2\235\1\u016e\2\235\1\u016e\10\235\1\u016e\4\235\1\u016e"+
    "\7\235\1\0\1\u016f\1\237\1\240\1\237\1\0\1\237"+
    "\1\u016f\1\237\1\0\1\237\4\0\2\237\1\0\3\237"+
    "\1\0\1\237\10\0\1\u016f\2\237\1\u016f\2\237\1\u016f"+
    "\2\237\1\0\4\237\1\0\1\u016f\1\237\1\0\1\237"+
    "\1\0\1\u016f\2\237\6\0\1\u0170\5\0\1\u0170\1\372"+
    "\15\0\2\u0170\7\0\2\u0170\1\0\2\u0170\1\0\2\u0170"+
    "\7\0\2\u0170\3\0\2\u0170\7\0\1\u0171\5\0\1\u0171"+
    "\16\0\2\u0171\7\0\2\u0171\1\0\2\u0171\1\0\2\u0171"+
    "\7\0\2\u0171\3\0\2\u0171\12\0\1\u0149\1\0\1\u0149"+
    "\3\0\1\u0149\1\u0125\3\0\2\u0149\53\0\1\u0172\1\u0120"+
    "\1\u0121\1\u0120\1\0\1\u0120\1\u0172\1\u0120\1\0\1\u0120"+
    "\1\u0125\11\u0120\1\0\11\u0120\1\u0172\2\u0120\1\u0172\2\u0120"+
    "\1\u0172\10\u0120\1\u0172\4\u0120\1\u0172\7\u0120\1\0\1\u0173"+
    "\1\u0123\1\u014c\1\u0123\1\u0174\1\u0123\1\u0173\10\u0123\1\u0175"+
    "\16\u0123\1\u0173\2\u0123\1\u0173\2\u0123\1\u0173\10\u0123\1\u0173"+
    "\4\u0123\1\u0173\7\u0123\1\0\1\u0176\1\u0124\1\u014d\3\u0124"+
    "\1\u0176\1\u0124\1\u0177\6\u0124\1\u0178\16\u0124\1\u0176\2\u0124"+
    "\1\u0176\2\u0124\1\u0176\10\u0124\1\u0176\4\u0124\1\u0176\7\u0124"+
    "\47\0\1\u0179\24\0\2\26\1\140\1\26\1\0\3\26"+
    "\1\0\1\26\4\0\2\26\1\0\3\26\1\0\1\26"+
    "\10\0\11\26\1\0\4\26\1\0\2\26\1\0\1\26"+
    "\1\0\3\26\6\0\1\u017a\1\143\1\144\1\143\1\0"+
    "\1\143\1\u017a\1\143\1\0\1\143\4\0\2\143\1\0"+
    "\3\143\1\0\1\143\10\0\1\u017a\2\143\1\u017a\2\143"+
    "\1\u017a\2\143\1\0\4\143\1\0\1\u017a\1\143\1\0"+
    "\1\143\1\0\1\u017a\2\143\6\0\1\u017b\1\145\1\146"+
    "\1\145\1\0\1\145\1\u017b\1\145\1\0\1\145\4\0"+
    "\2\145\1\0\3\145\1\0\1\145\10\0\1\u017b\2\145"+
    "\1\u017b\2\145\1\u017b\2\145\1\0\4\145\1\0\1\u017b"+
    "\1\145\1\0\1\145\1\0\1\u017b\2\145\54\0\1\u017c"+
    "\65\0\2\u017d\30\0\1\u017e\1\156\1\157\1\156\1\0"+
    "\1\156\1\u017e\1\156\1\0\1\156\4\0\2\156\1\0"+
    "\3\156\1\0\1\156\10\0\1\u017e\2\156\1\u017e\2\156"+
    "\1\u017e\2\156\1\0\4\156\1\0\1\u017e\1\156\1\0"+
    "\1\156\1\0\1\u017e\2\156\6\0\1\u017f\1\161\1\162"+
    "\1\161\1\163\1\161\1\u017f\27\161\1\u017f\2\161\1\u017f"+
    "\2\161\1\u017f\10\161\1\u017f\4\161\1\u017f\7\161\1\0"+
    "\1\u0180\1\165\1\166\3\165\1\u0180\1\165\1\163\25\165"+
    "\1\u0180\2\165\1\u0180\2\165\1\u0180\10\165\1\u0180\4\165"+
    "\1\u0180\7\165\1\0\1\u0181\1\167\1\170\1\167\1\171"+
    "\1\167\1\u0181\27\167\1\u0181\2\167\1\u0181\2\167\1\u0181"+
    "\10\167\1\u0181\4\167\1\u0181\7\167\1\0\1\u0182\1\172"+
    "\1\173\3\172\1\u0182\1\172\1\171\25\172\1\u0182\2\172"+
    "\1\u0182\2\172\1\u0182\10\172\1\u0182\4\172\1\u0182\7\172"+
    "\1\0\1\u0183\1\u010a\1\u010b\1\u010a\1\0\1\u010a\1\u0183"+
    "\1\u010a\1\0\1\u010a\1\u010e\11\u010a\1\0\11\u010a\1\u0183"+
    "\2\u010a\1\u0183\2\u010a\1\u0183\10\u010a\1\u0183\4\u010a\1\u0183"+
    "\7\u010a\1\0\1\u0184\1\u010c\1\u0136\1\u010c\1\u0133\1\u010c"+
    "\1\u0184\27\u010c\1\u0184\2\u010c\1\u0184\2\u010c\1\u0184\10\u010c"+
    "\1\u0184\4\u010c\1\u0184\7\u010c\1\0\2\u010c\1\u0136\2\u0133"+
    "\1\u015c\3\u010c\1\u015c\1\u0185\3\u010c\2\u0133\52\u010c\1\0"+
    "\2\u010c\1\u0136\1\0\1\u0133\12\u010c\1\0\52\u010c\1\0"+
    "\1\u0186\1\u010d\1\u0137\3\u010d\1\u0186\1\u010d\1\u0133\25\u010d"+
    "\1\u0186\2\u010d\1\u0186\2\u010d\1\u0186\10\u010d\1\u0186\4\u010d"+
    "\1\u0186\7\u010d\1\0\2\u010d\1\u0137\1\u0133\1\u010d\1\u015f"+
    "\2\u010d\1\u0133\1\u015f\1\u0187\3\u010d\2\u0133\52\u010d\1\0"+
    "\2\u010d\1\u0137\1\0\4\u010d\1\u0133\6\u010d\1\0\52\u010d"+
    "\1\0\2\54\1\175\1\54\1\0\3\54\1\0\1\54"+
    "\4\0\2\54\1\0\3\54\1\0\1\54\10\0\11\54"+
    "\1\0\4\54\1\0\2\54\1\0\1\54\1\0\3\54"+
    "\6\0\2\60\1\177\1\60\1\0\3\60\1\0\1\60"+
    "\4\0\2\60\1\0\3\60\1\0\1\60\10\0\11\60"+
    "\1\0\4\60\1\0\2\60\1\0\1\60\1\0\3\60"+
    "\6\0\2\65\1\201\1\65\1\0\3\65\1\0\1\65"+
    "\4\0\2\65\1\0\3\65\1\0\1\65\10\0\11\65"+
    "\1\0\4\65\1\0\2\65\1\0\1\65\1\0\3\65"+
    "\6\0\2\25\1\137\1\25\1\0\3\25\1\0\1\25"+
    "\4\0\2\25\1\0\3\25\1\0\1\25\10\0\11\25"+
    "\1\0\4\25\1\0\2\25\1\0\1\25\1\0\3\25"+
    "\6\0\2\77\1\206\1\77\1\0\3\77\1\0\1\77"+
    "\4\0\2\77\1\0\3\77\1\0\1\77\10\0\11\77"+
    "\1\0\4\77\1\0\2\77\1\0\1\77\1\0\3\77"+
    "\6\0\2\105\1\210\1\105\1\0\3\105\1\0\1\105"+
    "\4\0\2\105\1\0\3\105\1\0\1\105\10\0\11\105"+
    "\1\0\4\105\1\0\2\105\1\0\1\105\1\0\3\105"+
    "\6\0\1\u0188\1\212\1\213\1\212\1\214\1\212\1\u0188"+
    "\27\212\1\u0188\2\212\1\u0188\2\212\1\u0188\10\212\1\u0188"+
    "\4\212\1\u0188\7\212\1\0\1\u0189\1\215\1\216\3\215"+
    "\1\u0189\1\215\1\214\25\215\1\u0189\2\215\1\u0189\2\215"+
    "\1\u0189\10\215\1\u0189\4\215\1\u0189\7\215\1\0\2\112"+
    "\1\217\1\112\1\0\3\112\1\0\1\112\4\0\2\112"+
    "\1\0\3\112\1\0\1\112\10\0\11\112\1\0\4\112"+
    "\1\0\2\112\1\0\1\112\1\0\3\112\6\0\1\u018a"+
    "\1\222\1\223\1\222\1\0\1\222\1\u018a\1\222\1\0"+
    "\1\222\4\0\2\222\1\0\3\222\1\0\1\222\10\0"+
    "\1\u018a\2\222\1\u018a\2\222\1\u018a\2\222\1\0\4\222"+
    "\1\0\1\u018a\1\222\1\0\1\222\1\0\1\u018a\2\222"+
    "\6\0\1\u018b\1\315\1\316\1\315\1\0\1\315\1\u018b"+
    "\1\315\1\0\1\315\1\0\1\227\2\0\2\315\1\0"+
    "\3\315\1\0\1\315\10\0\1\u018b\2\315\1\u018b\2\315"+
    "\1\u018b\2\315\1\0\4\315\1\0\1\u018b\1\315\1\0"+
    "\1\315\1\0\1\u018b\2\315\6\0\2\121\1\226\1\121"+
    "\1\0\3\121\1\0\1\121\1\0\1\227\2\0\2\121"+
    "\1\0\3\121\1\230\1\121\10\0\11\121\1\0\4\121"+
    "\1\0\2\121\1\0\1\121\1\0\3\121\6\0\1\u018c"+
    "\1\232\1\233\1\232\1\234\1\232\1\u018c\27\232\1\u018c"+
    "\2\232\1\u018c\2\232\1\u018c\10\232\1\u018c\4\232\1\u018c"+
    "\7\232\1\0\1\u018d\1\235\1\236\3\235\1\u018d\1\235"+
    "\1\234\25\235\1\u018d\2\235\1\u018d\2\235\1\u018d\10\235"+
    "\1\u018d\4\235\1\u018d\7\235\1\0\1\u018e\1\237\1\240"+
    "\1\237\1\0\1\237\1\u018e\1\237\1\0\1\237\4\0"+
    "\2\237\1\0\3\237\1\0\1\237\10\0\1\u018e\2\237"+
    "\1\u018e\2\237\1\u018e\2\237\1\0\4\237\1\0\1\u018e"+
    "\1\237\1\0\1\237\1\0\1\u018e\2\237\6\0\1\u018f"+
    "\5\0\1\u018f\1\372\15\0\2\u018f\7\0\2\u018f\1\0"+
    "\2\u018f\1\0\2\u018f\7\0\2\u018f\3\0\2\u018f\7\0"+
    "\1\u0190\5\0\1\u0190\16\0\2\u0190\7\0\2\u0190\1\0"+
    "\2\u0190\1\0\2\u0190\7\0\2\u0190\3\0\2\u0190\7\0"+
    "\1\u0191\1\u0120\1\u0121\1\u0120\1\0\1\u0120\1\u0191\1\u0120"+
    "\1\0\1\u0120\1\u0125\11\u0120\1\0\11\u0120\1\u0191\2\u0120"+
    "\1\u0191\2\u0120\1\u0191\10\u0120\1\u0191\4\u0120\1\u0191\7\u0120"+
    "\1\0\1\u0192\1\u0123\1\u014c\1\u0123\1\u0149\1\u0123\1\u0192"+
    "\27\u0123\1\u0192\2\u0123\1\u0192\2\u0123\1\u0192\10\u0123\1\u0192"+
    "\4\u0123\1\u0192\7\u0123\1\0\2\u0123\1\u014c\2\u0149\1\u0174"+
    "\3\u0123\1\u0174\1\u0193\3\u0123\2\u0149\52\u0123\1\0\2\u0123"+
    "\1\u014c\1\0\1\u0149\12\u0123\1\0\52\u0123\1\0\1\u0194"+
    "\1\u0124\1\u014d\3\u0124\1\u0194\1\u0124\1\u0149\25\u0124\1\u0194"+
    "\2\u0124\1\u0194\2\u0124\1\u0194\10\u0124\1\u0194\4\u0124\1\u0194"+
    "\7\u0124\1\0\2\u0124\1\u014d\1\u0149\1\u0124\1\u0177\2\u0124"+
    "\1\u0149\1\u0177\1\u0195\3\u0124\2\u0149\52\u0124\1\0\2\u0124"+
    "\1\u014d\1\0\4\u0124\1\u0149\6\u0124\1\0\52\u0124\42\0"+
    "\2\u0196\30\0\2\143\1\144\1\143\1\0\3\143\1\0"+
    "\1\143\4\0\2\143\1\0\3\143\1\0\1\143\10\0"+
    "\11\143\1\0\4\143\1\0\2\143\1\0\1\143\1\0"+
    "\3\143\6\0\2\145\1\146\1\145\1\0\3\145\1\0"+
    "\1\145\4\0\2\145\1\0\3\145\1\0\1\145\10\0"+
    "\11\145\1\0\4\145\1\0\2\145\1\0\1\145\1\0"+
    "\3\145\44\0\2\u0197\33\0\2\156\1\157\1\156\1\0"+
    "\3\156\1\0\1\156\4\0\2\156\1\0\3\156\1\0"+
    "\1\156\10\0\11\156\1\0\4\156\1\0\2\156\1\0"+
    "\1\156\1\0\3\156\6\0\2\161\1\162\1\161\1\163"+
    "\65\161\1\0\2\165\1\166\5\165\1\163\61\165\1\0"+
    "\2\167\1\170\1\167\1\171\65\167\1\0\2\172\1\173"+
    "\5\172\1\171\61\172\1\0\1\u0198\1\u010a\1\u010b\1\u010a"+
    "\1\0\1\u010a\1\u0198\1\u010a\1\0\1\u010a\1\u010e\11\u010a"+
    "\1\0\11\u010a\1\u0198\2\u010a\1\u0198\2\u010a\1\u0198\10\u010a"+
    "\1\u0198\4\u010a\1\u0198\7\u010a\1\0\1\u0199\1\u010c\1\u0136"+
    "\1\u010c\1\u0133\1\u010c\1\u0199\27\u010c\1\u0199\2\u010c\1\u0199"+
    "\2\u010c\1\u0199\10\u010c\1\u0199\4\u010c\1\u0199\7\u010c\1\0"+
    "\1\u019a\1\u010d\1\u0137\3\u010d\1\u019a\1\u010d\1\u0133\25\u010d"+
    "\1\u019a\2\u010d\1\u019a\2\u010d\1\u019a\10\u010d\1\u019a\4\u010d"+
    "\1\u019a\7\u010d\1\0\2\212\1\213\1\212\1\214\65\212"+
    "\1\0\2\215\1\216\5\215\1\214\61\215\1\0\2\222"+
    "\1\223\1\222\1\0\3\222\1\0\1\222\4\0\2\222"+
    "\1\0\3\222\1\0\1\222\10\0\11\222\1\0\4\222"+
    "\1\0\2\222\1\0\1\222\1\0\3\222\6\0\1\u019b"+
    "\1\315\1\316\1\315\1\0\1\315\1\u019b\1\315\1\0"+
    "\1\315\1\0\1\227\2\0\2\315\1\0\3\315\1\0"+
    "\1\315\10\0\1\u019b\2\315\1\u019b\2\315\1\u019b\2\315"+
    "\1\0\4\315\1\0\1\u019b\1\315\1\0\1\315\1\0"+
    "\1\u019b\2\315\6\0\2\232\1\233\1\232\1\234\65\232"+
    "\1\0\2\235\1\236\5\235\1\234\61\235\1\0\2\237"+
    "\1\240\1\237\1\0\3\237\1\0\1\237\4\0\2\237"+
    "\1\0\3\237\1\0\1\237\10\0\11\237\1\0\4\237"+
    "\1\0\2\237\1\0\1\237\1\0\3\237\15\0\1\372"+
    "\63\0\1\u019c\5\0\1\u019c\16\0\2\u019c\7\0\2\u019c"+
    "\1\0\2\u019c\1\0\2\u019c\7\0\2\u019c\3\0\2\u019c"+
    "\7\0\1\u019d\1\u0120\1\u0121\1\u0120\1\0\1\u0120\1\u019d"+
    "\1\u0120\1\0\1\u0120\1\u0125\11\u0120\1\0\11\u0120\1\u019d"+
    "\2\u0120\1\u019d\2\u0120\1\u019d\10\u0120\1\u019d\4\u0120\1\u019d"+
    "\7\u0120\1\0\1\u019e\1\u0123\1\u014c\1\u0123\1\u0149\1\u0123"+
    "\1\u019e\27\u0123\1\u019e\2\u0123\1\u019e\2\u0123\1\u019e\10\u0123"+
    "\1\u019e\4\u0123\1\u019e\7\u0123\1\0\1\u019f\1\u0124\1\u014d"+
    "\3\u0124\1\u019f\1\u0124\1\u0149\25\u0124\1\u019f\2\u0124\1\u019f"+
    "\2\u0124\1\u019f\10\u0124\1\u019f\4\u0124\1\u019f\7\u0124\65\0"+
    "\1\u01a0\52\0\2\u01a1\25\0\1\u01a2\1\u010a\1\u010b\1\u010a"+
    "\1\0\1\u010a\1\u01a2\1\u010a\1\0\1\u010a\1\u010e\11\u010a"+
    "\1\0\11\u010a\1\u01a2\2\u010a\1\u01a2\2\u010a\1\u01a2\10\u010a"+
    "\1\u01a2\4\u010a\1\u01a2\7\u010a\1\0\1\u01a3\1\u010c\1\u0136"+
    "\1\u010c\1\u0133\1\u010c\1\u01a3\27\u010c\1\u01a3\2\u010c\1\u01a3"+
    "\2\u010c\1\u01a3\10\u010c\1\u01a3\4\u010c\1\u01a3\7\u010c\1\0"+
    "\1\u01a4\1\u010d\1\u0137\3\u010d\1\u01a4\1\u010d\1\u0133\25\u010d"+
    "\1\u01a4\2\u010d\1\u01a4\2\u010d\1\u01a4\10\u010d\1\u01a4\4\u010d"+
    "\1\u01a4\7\u010d\1\0\2\315\1\316\1\315\1\0\3\315"+
    "\1\0\1\315\1\0\1\227\2\0\2\315\1\0\3\315"+
    "\1\0\1\315\10\0\11\315\1\0\4\315\1\0\2\315"+
    "\1\0\1\315\1\0\3\315\6\0\1\u01a5\5\0\1\u01a5"+
    "\16\0\2\u01a5\7\0\2\u01a5\1\0\2\u01a5\1\0\2\u01a5"+
    "\7\0\2\u01a5\3\0\2\u01a5\7\0\1\u01a6\1\u0120\1\u0121"+
    "\1\u0120\1\0\1\u0120\1\u01a6\1\u0120\1\0\1\u0120\1\u0125"+
    "\11\u0120\1\0\11\u0120\1\u01a6\2\u0120\1\u01a6\2\u0120\1\u01a6"+
    "\10\u0120\1\u01a6\4\u0120\1\u01a6\7\u0120\1\0\1\u01a7\1\u0123"+
    "\1\u014c\1\u0123\1\u0149\1\u0123\1\u01a7\27\u0123\1\u01a7\2\u0123"+
    "\1\u01a7\2\u0123\1\u01a7\10\u0123\1\u01a7\4\u0123\1\u01a7\7\u0123"+
    "\1\0\1\u01a8\1\u0124\1\u014d\3\u0124\1\u01a8\1\u0124\1\u0149"+
    "\25\u0124\1\u01a8\2\u0124\1\u01a8\2\u0124\1\u01a8\10\u0124\1\u01a8"+
    "\4\u0124\1\u01a8\7\u0124\47\0\1\u01a9\24\0\1\u01aa\1\u010a"+
    "\1\u010b\1\u010a\1\0\1\u010a\1\u01aa\1\u010a\1\0\1\u010a"+
    "\1\u010e\11\u010a\1\0\11\u010a\1\u01aa\2\u010a\1\u01aa\2\u010a"+
    "\1\u01aa\10\u010a\1\u01aa\4\u010a\1\u01aa\7\u010a\1\0\1\u01ab"+
    "\1\u010c\1\u0136\1\u010c\1\u0133\1\u010c\1\u01ab\27\u010c\1\u01ab"+
    "\2\u010c\1\u01ab\2\u010c\1\u01ab\10\u010c\1\u01ab\4\u010c\1\u01ab"+
    "\7\u010c\1\0\1\u01ac\1\u010d\1\u0137\3\u010d\1\u01ac\1\u010d"+
    "\1\u0133\25\u010d\1\u01ac\2\u010d\1\u01ac\2\u010d\1\u01ac\10\u010d"+
    "\1\u01ac\4\u010d\1\u01ac\7\u010d\1\0\1\u01ad\1\u0120\1\u0121"+
    "\1\u0120\1\0\1\u0120\1\u01ad\1\u0120\1\0\1\u0120\1\u0125"+
    "\11\u0120\1\0\11\u0120\1\u01ad\2\u0120\1\u01ad\2\u0120\1\u01ad"+
    "\10\u0120\1\u01ad\4\u0120\1\u01ad\7\u0120\1\0\1\u01ae\1\u0123"+
    "\1\u014c\1\u0123\1\u0149\1\u0123\1\u01ae\27\u0123\1\u01ae\2\u0123"+
    "\1\u01ae\2\u0123\1\u01ae\10\u0123\1\u01ae\4\u0123\1\u01ae\7\u0123"+
    "\1\0\1\u01af\1\u0124\1\u014d\3\u0124\1\u01af\1\u0124\1\u0149"+
    "\25\u0124\1\u01af\2\u0124\1\u01af\2\u0124\1\u01af\10\u0124\1\u01af"+
    "\4\u0124\1\u01af\7\u0124\1\0\2\u010a\1\u010b\1\u010a\1\0"+
    "\3\u010a\1\0\1\u010a\1\u010e\11\u010a\1\0\45\u010a\1\0"+
    "\1\u01b0\1\u010c\1\u0136\1\u010c\1\u0133\1\u010c\1\u01b0\27\u010c"+
    "\1\u01b0\2\u010c\1\u01b0\2\u010c\1\u01b0\10\u010c\1\u01b0\4\u010c"+
    "\1\u01b0\7\u010c\1\0\1\u01b1\1\u010d\1\u0137\3\u010d\1\u01b1"+
    "\1\u010d\1\u0133\25\u010d\1\u01b1\2\u010d\1\u01b1\2\u010d\1\u01b1"+
    "\10\u010d\1\u01b1\4\u010d\1\u01b1\7\u010d\1\0\2\u0120\1\u0121"+
    "\1\u0120\1\0\3\u0120\1\0\1\u0120\1\u0125\11\u0120\1\0"+
    "\45\u0120\1\0\1\u01b2\1\u0123\1\u014c\1\u0123\1\u0149\1\u0123"+
    "\1\u01b2\27\u0123\1\u01b2\2\u0123\1\u01b2\2\u0123\1\u01b2\10\u0123"+
    "\1\u01b2\4\u0123\1\u01b2\7\u0123\1\0\1\u01b3\1\u0124\1\u014d"+
    "\3\u0124\1\u01b3\1\u0124\1\u0149\25\u0124\1\u01b3\2\u0124\1\u01b3"+
    "\2\u0124\1\u01b3\10\u0124\1\u01b3\4\u0124\1\u01b3\7\u0124\1\0"+
    "\2\u010c\1\u0136\1\u010c\1\u0133\65\u010c\1\0\2\u010d\1\u0137"+
    "\5\u010d\1\u0133\61\u010d\1\0\2\u0123\1\u014c\1\u0123\1\u0149"+
    "\65\u0123\1\0\2\u0124\1\u014d\5\u0124\1\u0149\61\u0124";

  private static int [] zzUnpackTrans() {
    int [] result = new int[21240];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\23\0\1\11\5\1\1\11\2\1\1\11\1\1\1\11"+
    "\1\1\1\11\2\1\1\11\3\1\1\11\6\1\1\11"+
    "\3\1\2\11\3\1\1\11\4\1\2\11\3\1\1\11"+
    "\1\1\1\11\11\1\2\11\6\1\1\11\6\1\1\11"+
    "\1\1\2\0\3\1\1\0\1\1\10\0\1\1\4\0"+
    "\1\11\5\0\1\11\4\0\1\1\1\0\1\1\1\0"+
    "\1\1\1\0\1\1\1\11\1\0\1\1\1\0\1\1"+
    "\2\0\1\11\3\0\1\1\1\0\1\1\2\0\1\11"+
    "\1\0\1\1\1\11\1\1\2\0\1\11\2\0\1\1"+
    "\2\0\1\1\2\0\1\11\1\1\1\11\2\1\7\0"+
    "\1\1\1\0\1\1\2\0\1\1\2\0\1\1\2\0"+
    "\1\1\2\0\6\1\1\0\1\1\2\0\1\1\1\0"+
    "\3\1\1\0\1\1\1\0\1\1\2\0\1\1\1\0"+
    "\3\1\1\0\3\1\2\11\5\0\1\1\5\0\6\1"+
    "\2\0\4\1\2\0\2\1\1\0\1\1\1\0\3\1"+
    "\3\0\1\11\1\0\1\1\10\0\1\11\6\1\2\0"+
    "\4\1\2\0\3\1\5\0\1\11\1\0\3\1\2\0"+
    "\1\11\1\0\1\1\6\0\1\1\2\0\6\1\2\0"+
    "\4\1\2\0\3\1\2\0\1\1\3\0\3\1\1\0"+
    "\1\11\1\0\1\1\13\0\6\1\2\0\4\1\2\0"+
    "\3\1\10\0\2\1\1\11\1\0\1\1\6\0\1\1"+
    "\1\0\1\1\2\0\2\1\2\0\3\1\2\0\1\1"+
    "\1\0\1\1\5\0\2\1\4\0\1\11\3\0\1\11"+
    "\3\0\1\11\12\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[435];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
	private final static String UNDEFINED = "undefined";
	private String fBufferedContext = null;
	private int fBufferedStart;
//	private int fBufferedTextLength;
	private int fBufferedLength;
//	private StringBuffer fBufferedText = null;
	private CSSTextRegionFactory fRegionFactory = CSSTextRegionFactory.getInstance();
	private int fInitialState = YYINITIAL;
	public final static int BUFFER_SIZE_NORMAL = 16384;
	public final static int BUFFER_SIZE_SMALL = 256;
	private int fInitialBufferSize = BUFFER_SIZE_NORMAL;

	public void setInitialState(int state) {
		fInitialState = state;
	}
	
	public void setInitialBufferSize(int size) {
		fInitialBufferSize = size;
	}

	/* user method */
  	public final ITextRegion getNextToken() throws IOException {
		String context;
		String nextTokenType;
		boolean spaceFollows;
//		StringBuffer text;
		int start;
		int textLength;
		int length;
		if (fBufferedContext != null) {
			context = fBufferedContext;
//			text = fBufferedText;
			start = fBufferedStart;
			textLength = length = fBufferedLength;

			fBufferedContext = null;
		} else {
			context = primGetNextToken();
//			text = new StringBuffer(yytext());
			start = yychar;
			textLength = length = yylength();
		}

		if (context != null) {
			if (context == UNDEFINED) {
				// undef -> concatenate undef's
				nextTokenType = primGetNextToken();
				while (nextTokenType == UNDEFINED) {
//					text.append(yytext());
					textLength += yylength();
					length = textLength;
					nextTokenType = primGetNextToken();
				}
				fBufferedContext = nextTokenType;
//				fBufferedText = new StringBuffer(yytext());
				fBufferedStart = yychar;
				fBufferedLength = yylength();
			} else {
				nextTokenType = null;
				spaceFollows = false;
				if (CSSRegionUtil.isDeclarationValueType(context)) { // declaration value can contain VALUE_S
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_DECLARATION_VALUE_S);
				} else if (canContainSpace(context)) {
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_S);
				}
				if (nextTokenType != null) { // nextToken is retrieved
					if (spaceFollows && (context != CSS_COMMENT)) {
						// next is space -> append
//						text.append(yytext());
						length += yylength();
					} else {
						// next is NOT space -> push this for next time, return itself
						fBufferedContext = nextTokenType;
//						fBufferedText = new StringBuffer(yytext());
						fBufferedStart = yychar;
						fBufferedLength = yylength();
					}
				}
			}
		}

		if (context != null) {
			if (context == UNDEFINED) {
				context = CSS_UNKNOWN;
			}
			return fRegionFactory.createRegion(context, start, textLength, length);
		} else {
			return null;
		}
  	}

	/* user method */
	/* for standalone use */
  	public final List parseText() throws IOException {
  		List tokens = new ArrayList();

  		CSSTextToken token;
		for (String kind = primGetNextToken(); kind != null; kind = primGetNextToken()) {
			token = new CSSTextToken();
			token.kind = kind;  				
			token.start = yychar;
			token.length = yylength();
			token.image = yytext();
			tokens.add(token);
		}

  		return tokens;
  	}
  	
  	/* user method */
  	private boolean canContainSpace(String type) {
  		if (type == CSS_DELIMITER || type == CSS_RBRACE || type == CSS_DECLARATION_DELIMITER) {
  			return false;
  		} else {
  			return true;
  		}
  	}

	/* user method */
	public final int getOffset() {
		return yychar;
	}
	
	/* user method */
	public final boolean isEOF() {
		return zzAtEOF;
	}

	/* user method */
	public void reset(char[] charArray) {
		reset(new CharArrayReader(charArray), 0);
	}

	/* user method */
	public final void reset(java.io.Reader in, int newOffset) {
		/** the input device */
		zzReader = in;

		/** the current state of the DFA */
		zzState = 0;

		/** the current lexical state */
		zzLexicalState = fInitialState; //YYINITIAL;

		/** this buffer contains the current text to be matched and is
			the source of the yytext() string */
		if (zzBuffer.length != fInitialBufferSize) {
			zzBuffer = new char[fInitialBufferSize];
		}
		java.util.Arrays.fill(zzBuffer, (char)0);

		/** the textposition at the last accepting state */
		zzMarkedPos = 0;

		/** the textposition at the last state to be included in yytext */
//		yy_pushbackPos = 0;

		/** the current text position in the buffer */
		zzCurrentPos = 0;

		/** startRead marks the beginning of the yytext() string in the buffer */
		zzStartRead = 0;

		/** endRead marks the last character in the buffer, that has been read
			from input */
		zzEndRead = 0;

		/** number of newlines encountered up to the start of the matched text */
		yyline = 0;

		/** the number of characters up to the start of the matched text */
		yychar = 0;

		/**
		 * the number of characters from the last newline up to the start of the 
		 * matched text
		 */
//		yycolumn = 0; 

		/** 
		 * yy_atBOL == true <=> the scanner is currently at the beginning of a line
		 */
//		yy_atBOL = false;
		
		/** zzAtEOF == true <=> the scanner has returned a value for EOF */
		zzAtEOF = false;

		/* user variables */
		//		fUndefined.delete(0, fUndefined.length());
	}

	/* user method */
	public CSSTokenizer() {
		super();
	}

	/**
	 * Added to workaround stricter compilation options without creating
	 * an alternate skeleton file
	 */
	void _usePrivates() {
		System.out.print(yycolumn);
		System.out.print(yyline);
		System.out.print(Boolean.toString(zzAtBOL));
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CSSTokenizer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CSSTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 170) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 35: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_STRING;
          }
        case 55: break;
        case 37: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_DIMENSION;
          }
        case 56: break;
        case 6: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_PSEUDO_START;
          }
        case 57: break;
        case 42: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { return CSS_DECLARATION_VALUE_S;
          }
        case 58: break;
        case 39: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_FUNCTION;
          }
        case 59: break;
        case 22: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ATTRIBUTE_END;
          }
        case 60: break;
        case 1: 
          { return UNDEFINED;
          }
        case 61: break;
        case 12: 
          { yybegin(ST_IMPORT_DELIMITER); return CSS_MEDIUM;
          }
        case 62: break;
        case 40: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_STRING;
          }
        case 63: break;
        case 32: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_CLASS;
          }
        case 64: break;
        case 15: 
          { yybegin(YYINITIAL); return CSS_LBRACE;
          }
        case 65: break;
        case 7: 
          { yybegin(YYINITIAL); return CSS_RBRACE;
          }
        case 66: break;
        case 14: 
          { yybegin(ST_MEDIA_DELIMITER); return CSS_MEDIUM;
          }
        case 67: break;
        case 13: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_MEDIA_SEPARATOR;
          }
        case 68: break;
        case 27: 
          { yybegin(ST_DECLARATION_PRE_VALUE); return CSS_DECLARATION_SEPARATOR;
          }
        case 69: break;
        case 53: 
          { yybegin(ST_FONT_FACE_DELIMITER); return CSS_FONT_FACE;
          }
        case 70: break;
        case 52: 
          { yybegin(ST_CHARSET_NAME); return CSS_CHARSET;
          }
        case 71: break;
        case 48: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_URI;
          }
        case 72: break;
        case 23: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_VALUE); return CSS_SELECTOR_ATTRIBUTE_OPERATOR;
          }
        case 73: break;
        case 43: 
          { return CSS_CDC;
          }
        case 74: break;
        case 18: 
          { yybegin(ST_DECLARATION); return CSS_LBRACE;
          }
        case 75: break;
        case 8: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_UNIVERSAL;
          }
        case 76: break;
        case 10: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_NAME); return CSS_SELECTOR_ATTRIBUTE_START;
          }
        case 77: break;
        case 45: 
          { return CSS_CDO;
          }
        case 78: break;
        case 11: 
          { yybegin(YYINITIAL); return CSS_DELIMITER;
          }
        case 79: break;
        case 21: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_OPERATOR); return CSS_SELECTOR_ATTRIBUTE_NAME;
          }
        case 80: break;
        case 41: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_HASH;
          }
        case 81: break;
        case 5: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_PSEUDO_END;
          }
        case 82: break;
        case 47: 
          { yybegin(ST_PAGE_PSEUDO_PAGE); return CSS_PAGE;
          }
        case 83: break;
        case 3: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ELEMENT_NAME;
          }
        case 84: break;
        case 34: 
          { yybegin(ST_CHARSET_DELIMITER); return CSS_STRING;
          }
        case 85: break;
        case 28: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_NUMBER;
          }
        case 86: break;
        case 36: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;
          }
        case 87: break;
        case 19: 
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;
          }
        case 88: break;
        case 44: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_UNICODE_RANGE;
          }
        case 89: break;
        case 38: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PERCENTAGE;
          }
        case 90: break;
        case 16: 
          { yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA_SEPARATOR;
          }
        case 91: break;
        case 29: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IDENT;
          }
        case 92: break;
        case 17: 
          { yybegin(ST_PAGE_DELIMITER); return CSS_PAGE_SELECTOR;
          }
        case 93: break;
        case 31: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_OPERATOR;
          }
        case 94: break;
        case 46: 
          { return CSS_COMMENT;
          }
        case 95: break;
        case 54: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IMPORTANT;
          }
        case 96: break;
        case 24: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_END); return CSS_SELECTOR_ATTRIBUTE_VALUE;
          }
        case 97: break;
        case 20: 
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_SEPARATOR;
          }
        case 98: break;
        case 4: 
          { return CSS_S;
          }
        case 99: break;
        case 33: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ID;
          }
        case 100: break;
        case 51: 
          { yybegin(ST_IMPORT_URI); return CSS_IMPORT;
          }
        case 101: break;
        case 30: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PARENTHESIS_CLOSE;
          }
        case 102: break;
        case 50: 
          { yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA;
          }
        case 103: break;
        case 26: 
          { yybegin(ST_DECLARATION); return CSS_DECLARATION_DELIMITER;
          }
        case 104: break;
        case 25: 
          { yybegin(ST_DECLARATION_SEPARATOR); return CSS_DECLARATION_PROPERTY;
          }
        case 105: break;
        case 9: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_PSEUDO;
          }
        case 106: break;
        case 2: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_PSEUDO_VALUE;
          }
        case 107: break;
        case 49: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_URI;
          }
        case 108: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return null;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
