/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.document;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentLoader;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public class TestXMLDocumentLoader
extends TestCase {
    private boolean isSetup = false;
    private final String fProjectName = "DOCUMENT-LOADER";
    private final String fZipFileName = "xml-document-loader-tests.zip";

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "xml-document-loader-tests.zip", "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject("DOCUMENT-LOADER");
    }

    public void testCreateNewEmptyStructuredDocument() {
        XMLDocumentLoader xmlDocumentLoader = new XMLDocumentLoader();
        IEncodedDocument document = null;
        document = xmlDocumentLoader.createNewStructuredDocument();
        TestXMLDocumentLoader.assertNotNull((String)"failed to create Empty document", (Object)document);
    }

    public void testCreateNewStructuredDocumentFromFile() {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("DOCUMENT-LOADER/files/simple.xml"));
        XMLDocumentLoader xmlDocumentLoader = new XMLDocumentLoader();
        IEncodedDocument document = null;
        try {
            document = xmlDocumentLoader.createNewStructuredDocument(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        TestXMLDocumentLoader.assertNotNull((String)"failed to create document from IFile", (Object)document);
    }

    public void testCreateNewStructuredDocumentFromInputStream() {
        String fileLocation = "/files/simple.xml";
        String absoluteFileLocation = Platform.getInstanceLocation() + "DOCUMENT-LOADER" + fileLocation;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("DOCUMENT-LOADER/files/simple.xml"));
        XMLDocumentLoader xmlDocumentLoader = new XMLDocumentLoader();
        IEncodedDocument document = null;
        try {
            document = xmlDocumentLoader.createNewStructuredDocument(absoluteFileLocation, file.getContents());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        TestXMLDocumentLoader.assertNotNull((String)"failed to create document from InputStream", (Object)document);
    }

    public void testCreateNewDocumentFromReaderWithEncodingRule() {
        String fileLocation = "/files/simple.xml";
        String absoluteFileLocation = String.valueOf(Platform.getInstanceLocation().getURL().getPath().toString()) + "DOCUMENT-LOADER" + fileLocation;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("DOCUMENT-LOADER/files/simple.xml"));
        XMLDocumentLoader xmlDocumentLoader = new XMLDocumentLoader();
        IEncodedDocument document = null;
        try {
            document = xmlDocumentLoader.createNewStructuredDocument(absoluteFileLocation, file.getContents());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        TestXMLDocumentLoader.assertNotNull((String)"failed to create document from InputStream with EncodingRule", (Object)document);
    }
}

