/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests;

import java.io.FileInputStream;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.common.core.tests.CoreTestTools;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public abstract class PreferencesTests
extends TestCase {
    private JavaProjectTestHarness javaProjectTestHarness;
    private String workspacePrefsFilePath;
    private String projectPrefsFilePath;
    private static final String WORKSPACE_PREFS_DIR_NAME = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/";
    private static final String PROJECT_PREFS_DIR_NAME = "/.settings/";

    public PreferencesTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.javaProjectTestHarness = this.buildJavaProjectTestHarness(false);
        this.workspacePrefsFilePath = String.valueOf(this.getWorkspaceRoot().getLocation().toString()) + WORKSPACE_PREFS_DIR_NAME + this.getWorkspacePrefsFileName();
        this.projectPrefsFilePath = String.valueOf(this.getProject().getLocation().toString()) + PROJECT_PREFS_DIR_NAME + this.getProjectPrefsFileName();
    }

    protected abstract String getWorkspacePrefsFileName();

    protected abstract String getProjectPrefsFileName();

    private JavaProjectTestHarness buildJavaProjectTestHarness(boolean autoBuild) throws Exception {
        return this.buildJavaProjectTestHarness(this.getName(), autoBuild);
    }

    private JavaProjectTestHarness buildJavaProjectTestHarness(String projectName, boolean autoBuild) throws Exception {
        return new JavaProjectTestHarness(projectName, autoBuild);
    }

    protected void tearDown() throws Exception {
        this.getPlugin().removePreferences();
        this.flushWorkspacePrefs();
        CoreTestTools.delete(this.getProject());
        TestTools.clear((TestCase)this);
        super.tearDown();
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProject getProject() {
        return this.javaProjectTestHarness.getProject();
    }

    protected Properties readProjectPrefs() throws Exception {
        return this.readProperties(this.projectPrefsFilePath);
    }

    protected Properties readWorkspacePrefs() throws Exception {
        return this.readProperties(this.workspacePrefsFilePath);
    }

    protected Properties readProperties(String path) throws Exception {
        Properties properties = new Properties();
        try (FileInputStream stream = new FileInputStream(path);){
            properties.load(stream);
        }
        return properties;
    }

    protected void flushWorkspacePrefs() throws Exception {
        JptPlugin plugin = this.getPlugin();
        IEclipsePreferences prefs = (IEclipsePreferences)ObjectTools.execute((Object)plugin, (String)"getWorkspacePreferences");
        prefs.flush();
    }

    protected void flushProjectPrefs() throws Exception {
        JptPlugin plugin = this.getPlugin();
        IEclipsePreferences prefs = (IEclipsePreferences)ObjectTools.execute((Object)plugin, (String)"getProjectPreferences", IProject.class, (Object)this.getProject());
        prefs.flush();
    }

    protected JptPlugin getPlugin() throws Exception {
        return (JptPlugin)ClassTools.execute(this.getPreferencesClass(), (String)"getPlugin");
    }

    protected abstract Class<?> getPreferencesClass();
}

