/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.state;

import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.ws.jaxws.dom.runtime.IPropertyState;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.state.PropertyStateAdapterFactory;

public class MethodPropertyStateAdapterTest
extends TestCase {
    private IWebMethod wm;
    private IWebService ws;
    private IPropertyState adapter;

    public void setUp() {
        this.wm = DomFactory.eINSTANCE.createIWebMethod();
        this.ws = DomFactory.eINSTANCE.createIWebService();
        IServiceEndpointInterface sei = DomFactory.eINSTANCE.createIServiceEndpointInterface();
        sei.getWebMethods().add((Object)this.wm);
        sei.getImplementingWebServices().add((Object)this.ws);
        this.adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.wm, IPropertyState.class);
        MethodPropertyStateAdapterTest.assertNotNull((Object)this.adapter);
    }

    public void testIsChangebleOutsideInWs() {
        this.ws.setWsdlLocation("C:/test/wsdl/location");
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_METHOD__EXCLUDED));
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_METHOD__SOAP_BINDING_STYLE));
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_METHOD__SOAP_BINDING_USE));
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_METHOD__SOAP_BINDING_PARAMETER_STYLE));
    }

    public void testIsChangable() {
        MethodPropertyStateAdapterTest.assertTrue((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_METHOD__EXCLUDED));
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_METHOD__SOAP_BINDING_STYLE));
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_METHOD__SOAP_BINDING_USE));
        MethodPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_METHOD__SOAP_BINDING_PARAMETER_STYLE));
    }
}

