/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.reference.SimpleBooleanReference;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.reference.BooleanReference;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class MethodPredicateTests
extends TestCase {
    private Predicate<BooleanReference> methodPredicate;
    private Predicate<Transformer<String, Boolean>> parmMethodPredicate;

    public MethodPredicateTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.methodPredicate = PredicateTools.execute((String)"getValue");
        this.parmMethodPredicate = PredicateTools.execute((String)"transform", Object.class, (Object)"true");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        SimpleBooleanReference ref = new SimpleBooleanReference(false);
        MethodPredicateTests.assertFalse((boolean)this.methodPredicate.evaluate((Object)ref));
        ref.setValue(true);
        MethodPredicateTests.assertTrue((boolean)this.methodPredicate.evaluate((Object)ref));
        MethodPredicateTests.assertTrue((boolean)this.parmMethodPredicate.evaluate((Object)TransformerTools.stringToBooleanTransformer()));
    }

    public void testEquals() {
        Predicate methodPredicate2 = PredicateTools.execute((String)"getValue");
        MethodPredicateTests.assertEquals(this.methodPredicate, (Object)methodPredicate2);
        MethodPredicateTests.assertEquals((int)this.methodPredicate.hashCode(), (int)methodPredicate2.hashCode());
        MethodPredicateTests.assertFalse((boolean)this.methodPredicate.equals((Object)IsNotNull.instance()));
        Predicate parmMethodPredicate2 = PredicateTools.execute((String)"transform", Object.class, (Object)"true");
        MethodPredicateTests.assertEquals(this.parmMethodPredicate, (Object)parmMethodPredicate2);
        MethodPredicateTests.assertEquals((int)this.parmMethodPredicate.hashCode(), (int)parmMethodPredicate2.hashCode());
        MethodPredicateTests.assertFalse((boolean)this.parmMethodPredicate.equals((Object)IsNotNull.instance()));
    }
}

