/******************************************************************************
 * Copyright (c) 2005-2007 BEA Systems, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *    Konstantin Komissarchik
 ******************************************************************************/

package org.eclipse.wst.common.project.facet.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * @author <a href="mailto:kosta@bea.com">Konstantin Komissarchik</a>
 */

public class AllTests

    extends TestCase
    
{
    public static Test suite()
    {
        final TestSuite suite = new TestSuite();
        
        suite.setName( "All Faceted Project Framework Tests" );
        
        suite.addTest( BasicTests.suite() );
        suite.addTest( PresetsTests.suite() );
        suite.addTest( ProjectCreationTests.suite() );
        suite.addTest( BasicFacetActionTests.suite() );
        suite.addTest( FacetActionSortTests.suite() );
        suite.addTest( FacetActionsTests.suite() );
        suite.addTest( ProjectChangeReactionTests.suite() );
        suite.addTest( FacetConstraintsTests.suite() );
        suite.addTest( DefaultVersionTests.suite() );
        suite.addTest( EventDeliveryTests.suite() );
        suite.addTest( AliasingSystemTests.suite() );
        suite.addTest( ProjectFacetGroupsTests.suite() );
        
        return suite;
    }

}
