/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public class CompositeClosure<A>
implements Closure<A> {
    private final Iterable<Closure<? super A>> closures;

    public CompositeClosure(Iterable<Closure<? super A>> closures) {
        if (IterableTools.isOrContainsNull(closures)) {
            throw new NullPointerException();
        }
        this.closures = closures;
    }

    @Override
    public void execute(A argument) {
        for (Closure<A> closure : this.closures) {
            closure.execute(argument);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.closures);
    }
}

