/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.tests.internal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetTools;

public class JDBCTests
extends TestCase {
    protected static final ConnectionConfig DERBY = new ConnectionConfig("Derby", "org.apache.derby.jdbc.EmbeddedDriver", "derby:C:/derby/data/test", null, null);
    protected static final ConnectionConfig MYSQL = new ConnectionConfig("MySQL", "com.mysql.jdbc.Driver", "mysql://localhost:3306", "root", "oracle");
    protected static final ConnectionConfig ORACLE = new ConnectionConfig("Oracle", "oracle.jdbc.OracleDriver", "oracle:thin:@localhost:1521:orcl", "scott", "tiger");
    protected static final ConnectionConfig POSTGRESQL = new ConnectionConfig("PostgreSQL", "org.postgresql.Driver", "postgresql:postgres", "postgres", "oracle");
    protected static final ConnectionConfig SYBASE = new ConnectionConfig("Sybase", "com.sybase.jdbc3.jdbc.SybDriver", "sybase:Tds:localhost:5000", "sa", "oracle");

    public JDBCTests(String name) {
        super(name);
    }

    public void testDerby() throws Exception {
        this.dumpMetaData(DERBY);
    }

    public void testMySQL() throws Exception {
        this.dumpMetaData(MYSQL);
    }

    public void testOracle() throws Exception {
        this.dumpMetaData(ORACLE);
    }

    public void testPostgreSQL() throws Exception {
        this.dumpMetaData(POSTGRESQL);
    }

    public void testSybase() throws Exception {
        this.dumpMetaData(SYBASE);
    }

    protected void dumpMetaData(ConnectionConfig config) throws Exception {
        System.out.println("***** PLATFORM: " + config.platformName + " *****");
        System.out.println();
        Class.forName(config.driverClassName);
        Connection connection = DriverManager.getConnection(this.buildURL(config), config.user, config.password);
        System.out.println("CATALOGS:");
        ResultSetTools.dump((ResultSet)connection.getMetaData().getCatalogs());
        System.out.println();
        System.out.println("SCHEMATA:");
        ResultSetTools.dump((ResultSet)connection.getMetaData().getSchemas());
        connection.close();
        System.out.println();
    }

    protected String buildURL(ConnectionConfig config) {
        return "jdbc:" + config.databaseURL;
    }

    protected static class ConnectionConfig {
        protected final String platformName;
        protected final String driverClassName;
        protected final String databaseURL;
        protected final String user;
        protected final String password;

        protected ConnectionConfig(String platformName, String driverClassName, String databaseURL, String user, String password) {
            this.platformName = platformName;
            this.driverClassName = driverClassName;
            this.databaseURL = databaseURL;
            this.user = user;
            this.password = password;
        }
    }
}

