/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class GlobalObjectLiteralTests
extends TestCase {
    private static final String TEST_NAME = "Test Global Object Literals JavaScript Content Assist";
    private static TestProjectSetup fTestProjectSetup;

    public GlobalObjectLiteralTests() {
        super(TEST_NAME);
    }

    public GlobalObjectLiteralTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(GlobalObjectLiteralTests.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false);
        return fTestProjectSetup;
    }

    public void testFindGlobalObjectLiteral_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"org : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalObjectLiterals.html", 6, 0, expectedProposals);
    }

    public void testFindGlobalObjectLiteral_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"org : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalObjectLiterals.html", 8, 1, expectedProposals);
    }

    public void _testFindFieldOnGlobalObjectLiteral_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse : {} - {}", "eclipse2 : {} - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalObjectLiterals.html", 10, 4, expectedProposals);
    }

    public void _testFindFieldOnGlobalObjectLiteral_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse : {} - {}", "eclipse2 : {} - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalObjectLiterals.html", 10, 5, expectedProposals);
    }

    public void _testFindFunctionOnFieldOnGlobalObjectLiteral_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"fun() - {}", "crazy() - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalOjectLiterals.html", 12, 12, expectedProposals);
    }

    public void testFindDuplicateGlobalObjectLiteral_Expression_0() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "GlobalObjectLiterals.html", 6, 0);
    }

    public void testFindDuplicateGlobalObjectLiteral_Expression_1() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "GlobalObjectLiterals.html", 8, 1);
    }

    public void testFindDuplicateFieldOnGlobalObjectLiteral_Expression_2() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "GlobalObjectLiterals.html", 10, 4);
    }

    public void testFindDuplicateFieldOnGlobalObjectLiteral_0() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "GlobalObjectLiterals.html", 10, 5);
    }

    public void testFindDuplicateFunctionOnFieldOnGlobalObjectLiteral_1() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "GlobalObjectLiterals.html", 12, 12);
    }
}

