/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import org.eclipse.jst.pagedesigner.css2.layout.CompositeBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.TextFragmentBox;
import org.eclipse.jst.pagedesigner.css2.layout.WidgetBox;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.swt.graphics.FontMetrics;

public class LineBox
extends CompositeBox {
    private static final int BASELINE = 0;
    private static final int MIDDLE = 1;
    private static final int SUB = 2;
    private static final int SUPER = 3;
    private static final int TEXT_TOP = 4;
    private static final int TEXT_BOTTOM = 5;
    private static final int TOP = 6;
    private static final int BOTTOM = 7;
    private static final int LENGTH = 8;
    private int _ascent = 0;
    private int _descent = 0;
    private int _fontAscent = 0;
    private int _fontDescent = 0;
    private int _fontLeading = 0;
    private Object _horizonalData = null;
    private Object _htmlInitData = null;
    private int _accumlatedWidth = 0;

    @Override
    public void clear() {
        super.clear();
        this._horizonalData = null;
        this._htmlInitData = null;
    }

    public void commit() {
        int baseline = this.getBaseline();
        int xLocation = this._x;
        int i = 0;
        while (i < this._fragments.size()) {
            TextFragmentBox textBox;
            FlowBox block = (FlowBox)this._fragments.get(i);
            block._x = xLocation + block.getMarginInsets().left;
            xLocation = block._x + block._width + block.getMarginInsets().right;
            if (this._fragments.size() > 1 && block instanceof TextFragmentBox && (textBox = (TextFragmentBox)block).getTextData().length() == 0) {
                textBox._height = this._fontAscent + this._fontDescent + this._fontLeading;
                textBox.setAscent(this._fontAscent + this._fontLeading);
                block._y = this._y;
            } else {
                switch (this.getVerticalAlignType(block)) {
                    case 6: {
                        block._y = this._y;
                        break;
                    }
                    case 7: {
                        block._y = this.getBaseline() - (block.getHeight() - this._descent);
                        break;
                    }
                    case 1: {
                        int halfXHeight = this.getHalfXHeight();
                        block._y = this.getBaseline() - halfXHeight - (block.getHeight() + 1) / 2;
                        break;
                    }
                    case 4: {
                        block._y = this.getBaseline() - this._fontAscent - this._fontLeading;
                        break;
                    }
                    case 5: {
                        block._y = this.getBaseline() - (block._height - this._fontDescent);
                        break;
                    }
                    case 8: {
                        block._y = this.getBaseline() + this.getIncrement(block);
                        break;
                    }
                    case 3: {
                        block._y = this.getBaseline() - this.getHalfXHeight() * 2 - block._height;
                        break;
                    }
                    case 2: {
                        block._y = this.getBaseline() - block._height * this._fontLeading / this.getFontHeight();
                        break;
                    }
                    default: {
                        block.makeBaseline(baseline);
                    }
                }
                if (block instanceof LineBox) {
                    ((LineBox)block).commit();
                }
            }
            ++i;
        }
    }

    private int getVerticalAlignType(FlowBox box) {
        Object data = box.getVerticalAlignData();
        if (data != null) {
            if (data instanceof Length) {
                return 8;
            }
            if ("baseline".equals(data)) {
                return 0;
            }
            if ("middle".equals(data)) {
                return 1;
            }
            if ("sub".equals(data)) {
                return 2;
            }
            if ("super".equals(data)) {
                return 3;
            }
            if ("text-top".equals(data)) {
                return 4;
            }
            if ("text-bottom".equals(data)) {
                return 5;
            }
            if ("top".equals(data)) {
                return 6;
            }
            if ("bottom".equals(data)) {
                return 7;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getAscent() {
        if (this._ascent == 0 && this._fragments.isEmpty()) {
            return this.getHeight();
        }
        return this._ascent;
    }

    public int getAvailableWidth() {
        if (this._recommendedWidth < 0) {
            return Integer.MAX_VALUE;
        }
        int availableWidth = this._recommendedWidth - this._accumlatedWidth;
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        return availableWidth;
    }

    public int getBaseline() {
        return this._y + this.getAscent();
    }

    @Override
    protected void resetInfo() {
        super.resetInfo();
        this._accumlatedWidth = 0;
        this._ascent = 0;
    }

    @Override
    protected void unionInfo(FlowBox blockInfo) {
        int valign;
        if (blockInfo instanceof TextFragmentBox && ((TextFragmentBox)blockInfo).getTextData().length() == 0) {
            return;
        }
        if (this._fragments == null || this._fragments.isEmpty()) {
            this._ascent = 0;
            this._descent = 0;
            this._height = 0;
        }
        if ((valign = this.getVerticalAlignType(blockInfo)) == 0) {
            this._ascent = Math.max(this._ascent, blockInfo.getAscent());
            this._descent = blockInfo instanceof WidgetBox ? 0 : Math.max(this._descent, blockInfo.getDescent());
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else if (valign == 1) {
            int halfXHeight = this.getHalfXHeight();
            this._ascent = Math.max(this._ascent, (blockInfo.getHeight() + 1) / 2 + halfXHeight);
            this._descent = Math.max(this._descent, blockInfo.getHeight() / 2 - halfXHeight);
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else if (valign == 4) {
            this._ascent = Math.max(this._ascent, this._fontAscent + this._fontLeading);
            this._descent = Math.max(this._descent, blockInfo.getHeight() - this._fontAscent - this._fontLeading);
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else if (valign == 5) {
            this._ascent = Math.max(this._ascent, blockInfo.getHeight() - this._fontDescent);
            this._descent = Math.max(this._descent, this._fontDescent);
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else if (valign == 2) {
            int blockTop = blockInfo._height * this._fontLeading / this.getFontHeight();
            this._ascent = Math.max(this._ascent, blockTop);
            this._descent = Math.max(this._descent, blockInfo.getHeight() - blockTop);
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else if (valign == 3) {
            int blockTop = blockInfo._height;
            this._ascent = Math.max(this._ascent, this.getHalfXHeight() * 2 + blockTop);
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else if (valign == 8) {
            int increment = this.getIncrement(blockInfo);
            this._ascent = Math.max(this._ascent, blockInfo.getAscent() + increment);
            this._descent = Math.max(this._descent, blockInfo.getDescent() - increment);
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else if (valign == 6) {
            this._descent = Math.max(this._descent, blockInfo.getHeight() - this._ascent);
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else if (valign == 7) {
            this._ascent = Math.max(this._ascent, blockInfo.getHeight() - this._descent);
            this._height = Math.max(this._height, this._ascent + this._descent);
        } else {
            this._ascent = Math.max(this._ascent, blockInfo.getAscent());
            this._descent = Math.max(this._descent, blockInfo.getDescent());
            this._height = Math.max(this._height, blockInfo.getHeight());
        }
        this._accumlatedWidth += blockInfo._width + blockInfo.getMarginInsets().getWidth();
        if (this._accumlatedWidth > this._width) {
            this._width = this._accumlatedWidth;
        }
    }

    private int getIncrement(FlowBox blockInfo) {
        int valign = this.getVerticalAlignType(blockInfo);
        if (valign == 8) {
            int increment = 0;
            Length length = (Length)blockInfo.getVerticalAlignData();
            increment = length.isPercentage() ? length.getValue() * this.getFontHeight() / 100 : length.getValue();
            return increment;
        }
        return 0;
    }

    public boolean isOccupied() {
        if (this._width > 0) {
            return true;
        }
        return !this._fragments.isEmpty();
    }

    public boolean isEmptyStringLine() {
        FlowBox box;
        return this._fragments.size() == 1 && (box = (FlowBox)this._fragments.get(0)) instanceof TextFragmentBox && box instanceof TextFragmentBox && ((TextFragmentBox)box).getTextData().length() == 0;
    }

    public void setFontMetrics(FontMetrics fontMetrics) {
        if (fontMetrics != null) {
            this._fontAscent = fontMetrics.getAscent();
            this._fontDescent = fontMetrics.getDescent();
            this._fontLeading = fontMetrics.getLeading();
        } else {
            this._fontAscent = 0;
            this._fontDescent = 0;
            this._fontLeading = 0;
        }
    }

    private int getHalfXHeight() {
        return (this._fontAscent + this._fontDescent + this._fontLeading) / 5;
    }

    private int getFontHeight() {
        return this._fontAscent + this._fontDescent + this._fontLeading;
    }

    public Object getHorizonalData() {
        return this._horizonalData;
    }

    public void setHorizonalData(Object horizonalData) {
        this._horizonalData = horizonalData;
    }

    public Object getHtmlInitData() {
        return this._htmlInitData;
    }

    public void setHtmlInitData(Object htmlInitData) {
        this._htmlInitData = htmlInitData;
    }

    @Override
    public void setY(int y) {
        super.setY(y);
    }
}

