/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.binding;

import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.core.dom.binding.DeclarationBase;
import org.eclipse.wst.jsdt.internal.core.dom.binding.IDeclaration;
import org.eclipse.wst.jsdt.internal.core.dom.binding.Scope;

public class VariableDeclaration
extends DeclarationBase {
    private final VariableKind variableKind;

    VariableDeclaration(SimpleName node, Scope scope, int index, VariableKind variableKind) {
        super(node, scope, index, IDeclaration.Kind.VARIABLE);
        this.variableKind = variableKind;
    }

    public String toString() {
        return "VD " + this.getName();
    }

    public boolean isVar() {
        return this.variableKind == VariableKind.VAR;
    }

    public boolean isCatch() {
        return this.variableKind == VariableKind.CATCH;
    }

    public boolean isLet() {
        return this.variableKind == VariableKind.LET;
    }

    public boolean isConst() {
        return this.variableKind == VariableKind.CONST;
    }

    boolean isArguments() {
        return this.variableKind == VariableKind.ARGUMENTS;
    }

    public static VariableDeclaration createArgumentsDeclaration(Scope scope) {
        return new ArgumentsDeclaration(scope);
    }

    static class ArgumentsDeclaration
    extends VariableDeclaration {
        ArgumentsDeclaration(Scope scope) {
            super(null, scope, -1, VariableKind.ARGUMENTS);
        }

        @Override
        public String getName() {
            return "arguments";
        }

        @Override
        public int hashCode() {
            return this.scope.getRootNode().hashCode();
        }
    }

    public static enum VariableKind {
        VAR,
        LET,
        CONST,
        CATCH,
        ARGUMENTS;

    }
}

