/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.UpdateServerJob;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerToolTip;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.cnf.ServerDecorator;
import org.eclipse.wst.server.ui.internal.cnf.ServerDecoratorsHandler;
import org.eclipse.wst.server.ui.internal.viewers.DefaultViewerSorter;
import org.eclipse.wst.server.ui.internal.wizard.NewServerWizard;

public class ServersView2
extends CommonNavigator {
    private static final String SERVERS_VIEW_CONTEXT = "org.eclipse.ui.serverViewScope";
    protected CommonViewer tableViewer;
    private Control mainPage;
    private Control noServersPage;
    PageBook book;
    protected IServerLifecycleListener serverResourceListener;
    protected IPublishListener publishListener;
    protected IServerListener serverListener;
    protected static Set<String> publishing = new HashSet<String>(4);
    protected static Set<String> starting = new HashSet<String>(4);
    protected boolean animationActive = false;
    protected boolean stopAnimation = false;

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.book = new PageBook(parent, 0);
        super.createPartControl((Composite)this.book);
        this.mainPage = this.getCommonViewer().getControl();
        this.getCommonViewer().setSorter((ViewerSorter)new DefaultViewerSorter());
        this.noServersPage = this.createDefaultPage(toolkit);
        this.book.showPage(this.mainPage);
        IContextService contextSupport = (IContextService)this.getSite().getService(IContextService.class);
        contextSupport.activateContext(SERVERS_VIEW_CONTEXT);
        this.deferInitialization();
    }

    private Control createDefaultPage(FormToolkit kit) {
        Form form = kit.createForm((Composite)this.book);
        Composite body = form.getBody();
        GridLayout layout = new GridLayout(2, false);
        body.setLayout((Layout)layout);
        Link hlink = new Link(body, 0);
        hlink.setText(Messages.ServersView2_noServers);
        hlink.setBackground(this.book.getDisplay().getSystemColor(25));
        GridData gd = new GridData(16384, 4, true, false);
        hlink.setLayoutData((Object)gd);
        hlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewServerWizard wizard = new NewServerWizard();
                WizardDialog wd = new WizardDialog(ServersView2.this.book.getShell(), (IWizard)wizard);
                if (wd.open() == 0) {
                    ServersView2.this.toggleDefaultPage();
                }
            }
        });
        final CommonViewer commonViewer = this.getCommonViewer();
        if (commonViewer != null) {
            ICommonViewerWorkbenchSite commonViewerSite = CommonViewerSiteFactory.createCommonViewerSite((IViewSite)this.getViewSite());
            if (commonViewerSite != null) {
                final NavigatorActionService actionService = new NavigatorActionService((ICommonViewerSite)commonViewerSite, (StructuredViewer)commonViewer, commonViewer.getNavigatorContentService());
                MenuManager menuManager = new MenuManager("#PopupMenu");
                menuManager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager mgr) {
                        ISelection selection = commonViewer.getSelection();
                        actionService.setContext(new ActionContext(selection));
                        actionService.fillContextMenu(mgr);
                    }
                });
                Menu menu = menuManager.createContextMenu((Control)body);
                body.setMenu(menu);
                hlink.setMenu(menu);
            } else if (Trace.FINEST) {
                Trace.trace("/finest", "The commonViewerSite is null");
            }
        } else if (Trace.FINEST) {
            Trace.trace("/finest", "The commonViewer is null");
        }
        return form;
    }

    void toggleDefaultPage() {
        if (this.tableViewer.getTree().getItemCount() < 1) {
            this.book.showPage(this.noServersPage);
        } else {
            this.book.showPage(this.mainPage);
        }
    }

    private void deferInitialization() {
        Job job = new Job(Messages.jobInitializingServersView){

            public IStatus run(IProgressMonitor monitor) {
                IServer[] servers = ServerCore.getServers();
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    ((Server)servers[i]).getAllModules().iterator();
                    ++i;
                }
                ServersView2.this.deferredInitialize();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void deferredInitialize() {
        this.addListener();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ServersView2.this.tableViewer = ServersView2.this.getCommonViewer();
                    ServersView2.this.getSite().setSelectionProvider((ISelectionProvider)ServersView2.this.tableViewer);
                    ServerToolTip toolTip = new ServerToolTip(ServersView2.this.tableViewer.getTree());
                    toolTip.setShift(new Point(10, 3));
                    toolTip.setPopupDelay(400);
                    toolTip.setHideOnMouseDown(true);
                    toolTip.activate();
                }
                catch (Exception exception) {}
            }
        });
        UpdateServerJob job = new UpdateServerJob(ServerCore.getServers());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            try {
                                if ((this).ServersView2.this.tableViewer.getTree().getItemCount() > 0) {
                                    Object obj = (this).ServersView2.this.tableViewer.getTree().getItem(0).getData();
                                    (this).ServersView2.this.tableViewer.setSelection((ISelection)new StructuredSelection(obj));
                                } else {
                                    ServersView2.this.toggleDefaultPage();
                                }
                            }
                            catch (Exception e) {
                                if (!Trace.WARNING) break block4;
                                Trace.trace("/warning", "Failed to update the server view.", e);
                            }
                        }
                    }
                });
            }
        });
        job.schedule();
    }

    protected void handlePublishChange(IServer server, boolean isPublishing) {
        String serverId = server.getId();
        if (isPublishing) {
            publishing.add(serverId);
        } else {
            publishing.remove(serverId);
        }
        this.refreshServerState(server);
    }

    protected void refreshServer(IServer server) {
        if (Trace.FINEST) {
            Trace.trace("/finest", "Refreshing UI for server=" + server);
        }
        ServerDecoratorsHandler.refresh(this.tableViewer);
    }

    protected void refreshServerContent(final IServer server) {
        if (Trace.FINEST) {
            Trace.trace("/finest", "Refreshing Content for server=" + server);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ServersView2.this.tableViewer.getTree().isDisposed()) {
                    ServersView2.this.tableViewer.refresh((Object)server, true);
                }
            }
        });
    }

    protected void refreshServerState(IServer server) {
        if (Trace.FINEST) {
            Trace.trace("/finest", "Refreshing UI for server=" + server);
        }
        ServerDecoratorsHandler.refresh(this.tableViewer);
    }

    protected void addListener() {
        this.serverResourceListener = new IServerLifecycleListener(){

            public void serverAdded(IServer server) {
                ServersView2.this.addServer(server);
                server.addServerListener(ServersView2.this.serverListener);
                ((Server)server).addPublishListener(ServersView2.this.publishListener);
            }

            public void serverChanged(IServer server) {
                ServersView2.this.refreshServerContent(server);
            }

            public void serverRemoved(IServer server) {
                ServersView2.this.removeServer(server);
                server.removeServerListener(ServersView2.this.serverListener);
                ((Server)server).removePublishListener(ServersView2.this.publishListener);
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        this.publishListener = new PublishAdapter(){

            public void publishStarted(IServer server) {
                ServersView2.this.handlePublishChange(server, true);
            }

            public void publishFinished(IServer server, IStatus status) {
                ServersView2.this.handlePublishChange(server, false);
            }
        };
        this.serverListener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                if (event == null) {
                    return;
                }
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if ((eventKind & 0x10) != 0) {
                    if ((eventKind & 1) != 0) {
                        int state = event.getState();
                        String id = server.getId();
                        if (state == 1 || state == 3) {
                            boolean startThread = false;
                            Set<String> set = starting;
                            synchronized (set) {
                                if (!starting.contains(id)) {
                                    if (starting.isEmpty()) {
                                        startThread = true;
                                    }
                                    starting.add(id);
                                }
                            }
                            if (startThread) {
                                ServersView2.this.startThread();
                            }
                        } else {
                            boolean stopThread = false;
                            Set<String> set = starting;
                            synchronized (set) {
                                if (starting.contains(id)) {
                                    starting.remove(id);
                                    if (starting.isEmpty()) {
                                        stopThread = true;
                                    }
                                }
                            }
                            if (stopThread) {
                                ServersView2.this.stopThread();
                            }
                        }
                        ServersView2.this.refreshServerState(server);
                        ServersView2.this.refreshServerContent(server);
                    } else if ((eventKind & 2) != 0 || (eventKind & 8) != 0) {
                        ServersView2.this.refreshServerState(server);
                    }
                } else if ((eventKind & 0x20) != 0 && ((eventKind & 1) != 0 || (eventKind & 2) != 0 || (eventKind & 8) != 0)) {
                    ServersView2.this.refreshServerContent(server);
                }
            }
        };
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].addServerListener(this.serverListener);
                ((Server)servers[i]).addPublishListener(this.publishListener);
                ++i;
            }
        }
    }

    protected void addServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServersView2.this.tableViewer.add(ServersView2.this.tableViewer.getInput(), (Object)server);
                ServersView2.this.toggleDefaultPage();
            }
        });
    }

    protected void removeServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServersView2.this.tableViewer.remove((Object)server);
                ServersView2.this.toggleDefaultPage();
            }
        });
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].removeServerListener(this.serverListener);
                ((Server)servers[i]).removePublishListener(this.publishListener);
                ++i;
            }
        }
        super.dispose();
    }

    protected void startThread() {
        Runnable[] animator;
        if (this.animationActive) {
            return;
        }
        this.stopAnimation = false;
        final Display display = this.tableViewer == null ? Display.getDefault() : this.tableViewer.getControl().getDisplay();
        animator = new Runnable[]{new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!ServersView2.this.stopAnimation) {
                    block8: {
                        try {
                            String[] servers;
                            int size = 0;
                            Set<String> set = starting;
                            synchronized (set) {
                                size = starting.size();
                                servers = new String[size];
                                starting.toArray(servers);
                            }
                            int i = 0;
                            while (i < size) {
                                IServer server = ServerCore.findServer((String)servers[i]);
                                if (server != null) {
                                    ServerDecorator.animate();
                                    ServersView2.this.tableViewer.update((Object)server, new String[]{"ICON"});
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            if (!Trace.FINEST) break block8;
                            Trace.trace("/finest", "Error in Servers view animation", e);
                        }
                    }
                    display.timerExec(200, animator[0]);
                }
            }
        }};
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                display.timerExec(200, animator[0]);
            }
        });
    }

    protected void stopThread() {
        this.stopAnimation = true;
    }
}

