/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class StructuredModelUtil {
    public static IFile getFileFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IFile file = root.getFile((IPath)new Path(path));
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IProject getProjectFor(IStructuredModel model) {
        IProject project = null;
        IFile file = StructuredModelUtil.getFileFor(model);
        if (file != null) {
            project = file.getProject();
        }
        return project;
    }
}

