/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.swt.widgets.TableTools;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.JoinTableAttributes;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AddJoinColumnDlg;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JoinPropertiesPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class JoinColumnsAnnotationEditor {
    private ResourceManager resourceManager;
    private EntityRefPropertyElem refElem;
    private boolean isInverseJoin;
    private org.eclipse.jpt.jpa.db.Table table;
    private org.eclipse.jpt.jpa.db.Table refTable;
    private JoinPropertiesPage joinPropsPage;
    private Label noJoinLabel;
    private Hyperlink actionLink;

    public JoinColumnsAnnotationEditor(ResourceManager resourceManager, EntityRefPropertyElem refElem, boolean isInverseJoin, org.eclipse.jpt.jpa.db.Table table, org.eclipse.jpt.jpa.db.Table refTable, JoinPropertiesPage joinPropsPage) {
        this.resourceManager = resourceManager;
        assert (refElem != null);
        this.isInverseJoin = isInverseJoin;
        this.refElem = refElem;
        this.table = table;
        this.refTable = refTable;
        this.joinPropsPage = joinPropsPage;
    }

    private List<ColumnAttributes> getEntityJoinColumns() {
        ArrayList<ColumnAttributes> joinColumns = new ArrayList<ColumnAttributes>();
        List srcJoinColumns = null;
        JoinTableAttributes joinTable = this.refElem.getJoinTable();
        srcJoinColumns = joinTable != null ? (this.isInverseJoin ? joinTable.getInverseJoinColumns() : joinTable.getJoinColumns()) : this.refElem.getJoinColumns();
        for (ColumnAttributes srcColAttrs : srcJoinColumns) {
            joinColumns.add(new ColumnAttributes(srcColAttrs));
        }
        return joinColumns;
    }

    public Control createJoinColumnsControl(Composite parent) {
        boolean add;
        String actionLabel;
        if (this.table == null) {
            return null;
        }
        if (this.refTable == null) {
            if (this.refElem.isManyToMany()) {
                return null;
            }
            Label label = new Label(parent, 0);
            label.setText(JptJpaUiMakePersistentMessages.REF_TABLE_NOT_SPECIFIED);
            return label;
        }
        final Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        List<ColumnAttributes> joinColumns = this.getEntityJoinColumns();
        if (joinColumns == null || joinColumns.isEmpty()) {
            this.noJoinLabel = new Label(composite, 0);
            String desc = String.format(JptJpaUiMakePersistentMessages.NO_JOIN_COLUMN_LABEL, this.table.getName(), this.refTable.getName());
            this.noJoinLabel.setText(desc);
            actionLabel = JptJpaUiMakePersistentMessages.ADD_JOIN_COLUMN;
            add = true;
        } else {
            Label joinColumnTableLabel = new Label(composite, 0);
            String tableDesc = String.format(JptJpaUiMakePersistentMessages.JOIN_COLUMN_TABLE_DESC, this.table.getName(), this.refTable.getName());
            joinColumnTableLabel.setText(tableDesc);
            actionLabel = JptJpaUiMakePersistentMessages.EDIT_JOIN_COLUMNS;
            TableViewer joinColumnsTable = this.createJoinColumnTable(composite, joinColumns, 170);
            add = false;
            GridData gd2 = new GridData(768);
            if (joinColumns.size() > 2) {
                // empty if block
            }
            gd2.heightHint = 60;
            joinColumnsTable.getTable().setLayoutData((Object)gd2);
        }
        this.actionLink = new Hyperlink(composite, 0);
        this.actionLink.setForeground(ColorConstants.blue);
        this.actionLink.setText(actionLabel);
        this.actionLink.setUnderlined(true);
        this.actionLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                Display display = Display.getDefault();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (add) {
                            JoinColumnsAnnotationEditor.this.addJoinColumn();
                        } else {
                            JoinColumnsAnnotationEditor.this.editJoinColumns();
                        }
                    }
                });
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control[] children;
                Control[] controlArray = children = composite.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    ++n2;
                }
            }
        });
        return composite;
    }

    public void setEnable(boolean enabled) {
        if (this.actionLink != null) {
            this.actionLink.setEnabled(enabled);
            if (enabled) {
                this.actionLink.setForeground(ColorConstants.blue);
            } else {
                this.actionLink.setForeground(ColorConstants.gray);
            }
        }
        if (this.noJoinLabel != null) {
            this.noJoinLabel.setEnabled(enabled);
        }
    }

    private TableViewer createJoinColumnTable(Composite parent, List<ColumnAttributes> joinColumns, int colWidth) {
        Table joinColumnsTable = new Table(parent, 68100);
        joinColumnsTable.setLinesVisible(true);
        joinColumnsTable.setHeaderVisible(true);
        TableColumn colNameCol = new TableColumn(joinColumnsTable, 0);
        colNameCol.setWidth(colWidth);
        colNameCol.setText(this.table.getName());
        colNameCol.setResizable(true);
        TableColumn refColNameCol = new TableColumn(joinColumnsTable, 0);
        refColNameCol.setWidth(colWidth);
        refColNameCol.setText(this.refTable.getName());
        refColNameCol.setResizable(true);
        TableViewer tableViewer = new TableViewer(joinColumnsTable);
        tableViewer.setContentProvider((IContentProvider)new JoinColumnsContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new JoinColumnsLabelProvider());
        tableViewer.setInput((Object)joinColumns.toArray(new ColumnAttributes[0]));
        return tableViewer;
    }

    private void addJoinColumn() {
        AddJoinColumnDlg dlg = new AddJoinColumnDlg(Display.getDefault().getActiveShell(), this.resourceManager, this.table, this.refTable, this.refElem);
        if (dlg.open() == 0) {
            ColumnAttributes joinCol = dlg.getNewJoinColumn();
            JoinTableAttributes joinTable = this.refElem.getJoinTable();
            if (joinTable != null) {
                if (this.isInverseJoin) {
                    joinTable.addInverseJoinColumn(joinCol);
                } else {
                    joinTable.addJoinColumn(joinCol);
                }
            } else {
                this.refElem.addJoinColumn(joinCol);
            }
            this.joinPropsPage.refreshJoinProperties();
        }
    }

    private void editJoinColumns() {
        List<ColumnAttributes> joinCols = this.getEntityJoinColumns();
        EditJoinColumnsDialog dlg = new EditJoinColumnsDialog(Display.getDefault().getActiveShell(), this.table, this.refTable, joinCols);
        if (dlg.open() == 0) {
            joinCols = dlg.getJoinColumns();
            JoinTableAttributes joinTable = this.refElem.getJoinTable();
            if (joinTable != null) {
                if (this.isInverseJoin) {
                    joinTable.setInverseJoinColumns(joinCols);
                } else {
                    joinTable.setJoinColumns(joinCols);
                }
            } else {
                this.refElem.setJoinColumns(joinCols);
            }
            this.joinPropsPage.refreshJoinProperties();
        }
    }

    private class EditJoinColumnsDialog
    extends Dialog {
        private org.eclipse.jpt.jpa.db.Table table;
        private org.eclipse.jpt.jpa.db.Table refTable;
        private List<ColumnAttributes> joinColumns;
        private TableViewer joinColumnTable;
        private Button addButton;
        private Button removeButton;

        public EditJoinColumnsDialog(Shell shell, org.eclipse.jpt.jpa.db.Table table, org.eclipse.jpt.jpa.db.Table refTable, List<ColumnAttributes> joinColumns) {
            super(shell);
            this.table = table;
            this.refTable = refTable;
            this.joinColumns = new ArrayList<ColumnAttributes>();
            if (joinColumns != null) {
                this.joinColumns.addAll(joinColumns);
            }
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(JptJpaUiMakePersistentMessages.EDIT_JOIN_COLUMNS);
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout gl = new GridLayout(2, false);
            gl.marginWidth = 10;
            gl.marginHeight = 10;
            gl.verticalSpacing = 10;
            composite.setLayout((Layout)gl);
            Label label = new Label(composite, 0);
            String desc = String.format(JptJpaUiMakePersistentMessages.EDIT_JOIN_COLUMNS_DESC, this.table.getName(), this.refTable.getName());
            label.setText(desc);
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            this.joinColumnTable = JoinColumnsAnnotationEditor.this.createJoinColumnTable(composite, this.joinColumns, 200);
            GridData gd2 = new GridData(768);
            gd2.heightHint = TableTools.calculateHeightHint((Table)this.joinColumnTable.getTable(), (int)5);
            this.joinColumnTable.getTable().setLayoutData((Object)gd2);
            this.joinColumnTable.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EditJoinColumnsDialog.this.updateButtons();
                }
            });
            this.createAddRemoveButtonComposite(composite);
            this.updateButtons();
            return composite;
        }

        protected boolean isResizable() {
            return true;
        }

        public List<ColumnAttributes> getJoinColumns() {
            return this.joinColumns;
        }

        private void createAddRemoveButtonComposite(Composite parent) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)data);
            this.addButton = new Button(buttonComposite, 8);
            this.addButton.setText(JptJpaUiMakePersistentMessages.ADD);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this.addButton.setLayoutData((Object)gridData);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddJoinColumnDlg dlg = new AddJoinColumnDlg(Display.getDefault().getActiveShell(), JoinColumnsAnnotationEditor.this.resourceManager, EditJoinColumnsDialog.this.table, EditJoinColumnsDialog.this.refTable, JoinColumnsAnnotationEditor.this.refElem);
                    if (dlg.open() == 0) {
                        ColumnAttributes joinCol = dlg.getNewJoinColumn();
                        EditJoinColumnsDialog.this.joinColumns.add(joinCol);
                        EditJoinColumnsDialog.this.joinColumnTable.add((Object)joinCol);
                    }
                }
            });
            this.removeButton = new Button(buttonComposite, 8);
            this.removeButton.setText(JptJpaUiMakePersistentMessages.REMOVE);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this.removeButton.setLayoutData((Object)gridData);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StructuredSelection selection = (StructuredSelection)EditJoinColumnsDialog.this.joinColumnTable.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    ColumnAttributes selectedCol = (ColumnAttributes)selection.getFirstElement();
                    EditJoinColumnsDialog.this.joinColumns.remove(selectedCol);
                    EditJoinColumnsDialog.this.joinColumnTable.remove((Object)selectedCol);
                }
            });
            this.addButton.setFocus();
        }

        private void updateButtons() {
            if (this.joinColumnTable.getSelection().isEmpty()) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
            }
        }
    }

    private final class JoinColumnsContentProvider
    implements IStructuredContentProvider {
        private JoinColumnsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ColumnAttributes[]) {
                return (ColumnAttributes[])inputElement;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class JoinColumnsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private JoinColumnsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ColumnAttributes colAttrs = (ColumnAttributes)element;
            String colText = null;
            switch (columnIndex) {
                case 0: {
                    colText = colAttrs.getName();
                    break;
                }
                case 1: {
                    colText = colAttrs.getReferencedColumnName();
                }
            }
            return colText;
        }
    }
}

