/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaElementReference;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractAccessor;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.PersistentPropertyValidator;

public class PropertyAccessor
extends AbstractAccessor {
    private final JavaResourceMethod resourceGetter;
    private final JavaResourceMethod resourceSetter;

    public PropertyAccessor(PersistentAttribute parent, JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        super(parent);
        this.resourceGetter = resourceGetter;
        this.resourceSetter = resourceSetter;
    }

    public JavaResourceMethod getResourceAttribute() {
        return this.resourceGetter != null ? this.resourceGetter : this.resourceSetter;
    }

    @Override
    public boolean isFor(JavaResourceField field) {
        return false;
    }

    @Override
    public boolean isFor(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        return this.resourceGetter == getterMethod && this.resourceSetter == setterMethod;
    }

    @Override
    public AccessType getDefaultAccess() {
        return AccessType.PROPERTY;
    }

    public JavaResourceMethod getResourceGetter() {
        return this.resourceGetter;
    }

    public JavaResourceMethod getResourceSetter() {
        return this.resourceSetter;
    }

    @Override
    public JavaSpecifiedPersistentAttribute buildUnannotatedJavaAttribute(PersistentType type) {
        return this.buildJavaAttribute(type, this.buildUnannotatedJavaResourceGetter(), this.buildUnannotatedJavaResourceSetter());
    }

    protected JavaResourceMethod buildUnannotatedJavaResourceGetter() {
        return new UnannotatedJavaResourceMethod(this.resourceGetter);
    }

    protected JavaResourceMethod buildUnannotatedJavaResourceSetter() {
        return new UnannotatedJavaResourceMethod(this.resourceSetter);
    }

    protected JavaSpecifiedPersistentAttribute buildJavaAttribute(PersistentType type, JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        return this.getJpaFactory().buildJavaPersistentProperty(type, getterMethod, setterMethod);
    }

    @Override
    public JpaValidator buildAttributeValidator(SpecifiedPersistentAttribute persistentAttribute) {
        return new PersistentPropertyValidator(persistentAttribute, this);
    }

    @Override
    public IJavaElement getJavaElement() {
        JavaResourceMethod method;
        IType jdtType;
        PersistentType persistentType = this.getAttribute().getDeclaringPersistentType();
        if (persistentType instanceof JavaElementReference && (jdtType = (IType)((JavaElementReference)((Object)persistentType)).getJavaElement()) != null && (method = this.getResourceAttribute()) != null) {
            String[] parmTypeNames = (String[])ArrayTools.array((Iterable)method.getParameterTypeNames(), (Object[])new String[method.getParametersSize()]);
            return jdtType.getMethod(method.getMethodName(), parmTypeNames);
        }
        return null;
    }

    protected class UnannotatedJavaResourceMethod
    extends AbstractAccessor.UnannotatedJavaResourceAttribute<JavaResourceMethod>
    implements JavaResourceMethod {
        protected UnannotatedJavaResourceMethod(JavaResourceMethod method) {
            super((AbstractAccessor)PropertyAccessor.this, (JavaResourceAttribute)method);
        }

        public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
            return JavaResourceAnnotatedElement.AstNodeType.METHOD;
        }

        public String getMethodName() {
            return ((JavaResourceMethod)this.member).getMethodName();
        }

        public ListIterable<String> getParameterTypeNames() {
            return ((JavaResourceMethod)this.member).getParameterTypeNames();
        }

        public String getParameterTypeName(int index) {
            return ((JavaResourceMethod)this.member).getParameterTypeName(index);
        }

        public int getParametersSize() {
            return ((JavaResourceMethod)this.member).getParametersSize();
        }

        public boolean isConstructor() {
            return ((JavaResourceMethod)this.member).isConstructor();
        }

        public boolean isFor(MethodSignature methodSignature, int occurrence) {
            return ((JavaResourceMethod)this.member).isFor(methodSignature, occurrence);
        }

        public void synchronizeWith(MethodDeclaration methodDeclaration) {
        }
    }
}

