/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.translation;

import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.sse.core.internal.util.DocumentInputStream;

public class JSTranslationEditorInput
implements IStorageEditorInput {
    private JSTranslationStorage fStorage;

    public JSTranslationEditorInput(IJsTranslation translation, String baseLocation) {
        this.fStorage = new JSTranslationStorage(translation, baseLocation);
    }

    public boolean exists() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fStorage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        return this.fStorage;
    }

    public String getToolTipText() {
        return this.fStorage.fBaseLocation;
    }

    private class JSTranslationStorage
    implements IStorage {
        private final IJsTranslation fTranslation;
        final String fBaseLocation;

        public JSTranslationStorage(IJsTranslation translation, String baseLocation) {
            this.fTranslation = translation;
            this.fBaseLocation = baseLocation;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            return new DocumentInputStream((IDocument)new Document(this.fTranslation.getJsText()));
        }

        public IPath getFullPath() {
            return new Path(String.valueOf(this.fBaseLocation) + ".js");
        }

        public String getName() {
            return new Path(String.valueOf(this.fBaseLocation) + ".js").lastSegment();
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

