/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import java.util.ArrayList;
import javax.jws.WebService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class AddAnnotationToTypeTest
extends AbstractAnnotationTest {
    @Override
    public String getPackageName() {
        return "com.example";
    }

    @Override
    public String getClassName() {
        return "Calculator.java";
    }

    @Override
    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("public class Calculator {\n\n\tpublic int add(int i, int k) {");
        classContents.append("\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    @Override
    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"name", (String)"Calculator");
        MemberValuePair targetNamespaceValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"targetNamespace", (String)JDTUtils.getTargetNamespaceFromPackageName((String)this.getPackageName()));
        MemberValuePair portNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"portName", (String)"CalculatorPort");
        MemberValuePair serviceNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"serviceName", (String)"CalculatorService");
        memberValuePairs.add(nameValuePair);
        memberValuePairs.add(targetNamespaceValuePair);
        memberValuePairs.add(portNameValuePair);
        memberValuePairs.add(serviceNameValuePair);
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)WebService.class.getSimpleName(), memberValuePairs);
    }

    public void testAddAnnotationToType() {
        try {
            AddAnnotationToTypeTest.assertNotNull((Object)this.annotation);
            AddAnnotationToTypeTest.assertEquals((String)WebService.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)this.source.findPrimaryType(), (String)WebService.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)this.source.findPrimaryType(), (Annotation)this.annotation));
            AddAnnotationToTypeTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AddAnnotationToTypeTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            AddAnnotationToTypeTest.assertTrue((boolean)this.source.getImport(WebService.class.getCanonicalName()).exists());
        }
        catch (CoreException ce) {
            AddAnnotationToTypeTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

