/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.utils;

public class TestRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Throwable originalException;

    public TestRuntimeException() {
    }

    public TestRuntimeException(String s) {
        super(s);
    }

    public TestRuntimeException(Throwable t) {
        this.originalException = t;
    }

    public TestRuntimeException(Throwable t, String s) {
        super(s);
        this.originalException = t;
    }

    @Override
    public String getMessage() {
        String result = super.getMessage();
        if (result != null && !result.endsWith(".")) {
            result = String.valueOf(result) + ".";
        }
        if (this.originalException != null) {
            String embeddedMessage = this.originalException.getMessage();
            String originalError = "Original error:";
            result = embeddedMessage != null ? String.valueOf(result) + "  " + originalError + " " + embeddedMessage : String.valueOf(result) + "  " + originalError + " " + this.originalException.toString();
        }
        return result;
    }

    public Throwable getOriginalException() {
        return this.originalException;
    }

    @Override
    public String toString() {
        String message = this.getMessage();
        return message != null ? message : super.toString();
    }
}

