/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.io;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.io.StringBufferWriter;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class StringBufferWriterTests
extends TestCase {
    private StringBufferWriter writer;

    public StringBufferWriterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.writer = new StringBufferWriter();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testWriteInt() throws Exception {
        this.writer.write(97);
        this.writer.write(98);
        this.writer.write(99);
        StringBufferWriterTests.assertEquals((int)3, (int)this.writer.getBuffer().length());
        StringBufferWriterTests.assertEquals((String)"abc", (String)this.writer.toString());
    }

    public void testWriteCharArray() throws Exception {
        this.writer.write(new char[]{'a', 'b', 'c'});
        this.writer.write(new char[]{'a', 'b', 'c'});
        StringBufferWriterTests.assertEquals((int)6, (int)this.writer.getBuffer().length());
        StringBufferWriterTests.assertEquals((String)"abcabc", (String)this.writer.toString());
    }

    public void testWriteString() throws Exception {
        this.writer.write("abc");
        this.writer.write("abc");
        StringBufferWriterTests.assertEquals((int)6, (int)this.writer.getBuffer().length());
        StringBufferWriterTests.assertEquals((String)"abcabc", (String)this.writer.toString());
    }

    public void testWriteStringIntInt() throws Exception {
        this.writer.write("abc", 1, 2);
        this.writer.write("abc", 2, 1);
        StringBufferWriterTests.assertEquals((int)3, (int)this.writer.getBuffer().length());
        StringBufferWriterTests.assertEquals((String)"bcc", (String)this.writer.toString());
    }
}

