/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.DisabledPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class FilteringIteratorTests
extends TestCase {
    private static final String PREFIX = "prefix";

    public FilteringIteratorTests(String name) {
        super(name);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            String string = stream.next();
            if (!string.equals("prefix3")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        FilteringIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildAcceptIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        FilteringIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testAcceptHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testAcceptNext() {
        Iterator<String> stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)stream.next().startsWith(PREFIX));
        }
    }

    public void testAcceptNext_super() {
        Iterator<String> stream = this.buildSuperAcceptIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)stream.next().startsWith(PREFIX));
        }
    }

    public void testRejectHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildRejectIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)2, (int)i);
    }

    public void testRejectNext() {
        Iterator<String> stream = this.buildRejectIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertFalse((String)"bogus reject", (boolean)stream.next().startsWith(PREFIX));
        }
    }

    private Iterator<String> buildFilteredIterator(Iterator<String> nestedIterator, Predicate<String> filter) {
        return IteratorTools.filter(nestedIterator, filter);
    }

    private Iterator<String> buildSuperFilteredIterator(Iterator<String> nestedIterator, Predicate<Object> filter) {
        return IteratorTools.filter(nestedIterator, filter);
    }

    String getPrefix() {
        return PREFIX;
    }

    private Iterator<String> buildNestedIterator() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("prefix1");
        c.add("prefix2");
        c.add("prefix3");
        c.add("4");
        c.add("prefix5");
        c.add("prefix6");
        c.add("prefix7");
        c.add("8");
        return c.iterator();
    }

    private Iterator<String> buildAcceptIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildStringStartsWith(PREFIX));
    }

    private Iterator<String> buildSuperAcceptIterator() {
        return this.buildSuperFilteredIterator(this.buildNestedIterator(), this.buildObjectStartsWith(PREFIX));
    }

    private Predicate<String> buildStringStartsWith(String prefix) {
        return new StringStartsWith(prefix);
    }

    private Predicate<Object> buildObjectStartsWith(String prefix) {
        return new ObjectToStringStartsWith(prefix);
    }

    private Iterator<String> buildRejectIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildRejectFilter(PREFIX));
    }

    private Predicate<String> buildRejectFilter(String prefix) {
        return PredicateTools.not(this.buildStringStartsWith(prefix));
    }

    public void testInvalidFilteringIterator() {
        boolean exCaught = false;
        try {
            Iterator iterator = IteratorTools.filter(this.buildNestedIterator(), (Predicate)DisabledPredicate.instance());
            String s = (String)iterator.next();
            FilteringIteratorTests.fail((String)("invalid string: " + s));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        FilteringIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    class ObjectToStringStartsWith
    extends CriterionPredicate<Object, String> {
        ObjectToStringStartsWith(String criterion) {
            super((Object)criterion);
        }

        public boolean evaluate(Object o) {
            return o.toString().startsWith((String)this.criterion);
        }
    }

    class StringStartsWith
    extends CriterionPredicate<String, String> {
        StringStartsWith(String criterion) {
            super((Object)criterion);
        }

        public boolean evaluate(String s) {
            return s.startsWith((String)this.criterion);
        }
    }
}

