/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views.model.jsp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.ITagResolvingStrategy;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

final class TestUtil
extends Assert {
    TestUtil() {
    }

    public static TLDDocument getDocument(ITaglibRecord record) {
        CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
        TLDDocument doc = (TLDDocument)factory.createCMDocument(record);
        return doc;
    }

    public static TLDElementDeclaration getTag(ITaglibRecord record, String name) {
        TLDDocument doc = TestUtil.getDocument(record);
        TestUtil.assertNotNull((Object)doc);
        CMNode cmNode = doc.getElements().getNamedItem(name);
        TestUtil.assertTrue((boolean)(cmNode instanceof TLDElementDeclaration));
        return (TLDElementDeclaration)cmNode;
    }

    public static List<TLDElementDeclaration> getTags(ITaglibRecord record) {
        TLDDocument doc = TestUtil.getDocument(record);
        TestUtil.assertNotNull((Object)doc);
        CMNamedNodeMap nodes = doc.getElements();
        ArrayList<TLDElementDeclaration> tags = new ArrayList<TLDElementDeclaration>();
        for (CMNode cmNode : nodes) {
            TestUtil.assertTrue((boolean)(cmNode instanceof TLDElementDeclaration));
            tags.add((TLDElementDeclaration)cmNode);
        }
        return tags;
    }

    public static Map<String, ITagElement> constructTagElements(Collection<? extends ITagElement> elements) {
        HashMap<String, ITagElement> map = new HashMap<String, ITagElement>();
        for (ITagElement iTagElement : elements) {
            map.put(iTagElement.getName(), iTagElement);
        }
        return map;
    }

    public static Map<String, ITagElement> constructTagElements(List<TLDElementDeclaration> tlds, ITagResolvingStrategy<TLDElementDeclaration, String> strategy) {
        HashMap<String, ITagElement> tagElements = new HashMap<String, ITagElement>();
        for (TLDElementDeclaration tld : tlds) {
            ITagElement tagElement = strategy.resolve((Object)tld);
            if (tagElement == null) continue;
            TestUtil.assertNotNull((Object)tagElement.getName());
            tagElements.put(tagElement.getName(), tagElement);
        }
        return tagElements;
    }
}

