/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.DataWithRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.LoadableString;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.SubpropertiesMirror;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

class FakeValueLoader
extends ValueLoader {
    private int cacheState = 1;
    private final Map<Long, ValueData> valueDataMap = new HashMap<Long, ValueData>();

    FakeValueLoader() {
    }

    void addValueDataRecursive(ValueData data) {
        Long ref = data.getRef();
        if (ref < 0L) {
            return;
        }
        if (!this.valueDataMap.containsKey(ref)) {
            this.valueDataMap.put(ref, data);
            ObjectData asObject = data.asObjectData();
            if (asObject != null) {
                for (ValueData valueData : asObject.getProperties().values()) {
                    this.addValueDataRecursive(valueData);
                }
            }
        }
    }

    public void clearCaches() {
        ++this.cacheState;
    }

    int getCurrentCacheState() {
        return this.cacheState;
    }

    public SubpropertiesMirror getOrLoadSubproperties(Long ref) {
        ValueData data = (ValueData)BasicUtil.getSafe(this.valueDataMap, (Object)ref);
        ObjectData asObject = data.asObjectData();
        if (asObject == null) {
            return SubpropertiesMirror.EMPTY;
        }
        return FakeValueLoader.createSubpropertiesMirror(asObject);
    }

    public List<ValueMirror> getOrLoadValueFromRefs(List<? extends PropertyReference> propertyRefs) {
        ArrayList<ValueMirror> result = new ArrayList<ValueMirror>();
        for (PropertyReference propertyReference : propertyRefs) {
            Long ref = propertyReference.getRef();
            ValueData data = (ValueData)BasicUtil.getSafe(this.valueDataMap, (Object)ref);
            ValueMirror mirror = FakeValueLoader.createMirrorFromData(data, false);
            result.add(mirror);
        }
        return result;
    }

    public InternalContext getInternalContext() {
        throw new UnsupportedOperationException();
    }

    static SubpropertiesMirror createSubpropertiesMirror(ObjectData objectData) {
        ArrayList<PropertyReference> list = new ArrayList<PropertyReference>();
        for (Map.Entry<String, ? extends ValueData> en : objectData.getProperties().entrySet()) {
            list.add(new PropertyReference((Object)en.getKey(), DataWithRef.fromLong((long)en.getValue().getRef())));
        }
        return new SubpropertiesMirror.ListBased(list);
    }

    static ValueMirror createMirrorFromData(ValueData data, boolean includeProperties) {
        ObjectData asObject;
        SubpropertiesMirror subpropertiesMirror = includeProperties ? ((asObject = data.asObjectData()) == null ? SubpropertiesMirror.EMPTY : FakeValueLoader.createSubpropertiesMirror(asObject)) : null;
        return ValueMirror.create((Long)data.getRef(), (JsValue.Type)data.getType(), (String)data.getClassName(), (LoadableString)data.getString(), (SubpropertiesMirror)subpropertiesMirror);
    }

    static interface ObjectData {
        public Map<String, ? extends ValueData> getProperties();
    }

    static interface ValueData {
        public Long getRef();

        public JsValue.Type getType();

        public String getClassName();

        public LoadableString getString();

        public ObjectData asObjectData();
    }
}

