/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestCatalogContentModels
extends TestCase {
    private static final String contentTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE html ${METHOD} ${PUBLIC} ${SYSTEM}>\n<html>\n<head>\n<title>Insert title here</title>\n</head>\n<body>\n</body>\n</html>";

    public TestCatalogContentModels() {
        this("HTML Content Models from XML Catalog");
    }

    public TestCatalogContentModels(String string) {
        super(string);
    }

    private void assertIsNotXHTMLContentModel(IDOMModel htmlModel) {
        Element html = htmlModel.getDocument().getDocumentElement();
        CMDocument correspondingCMDocument = ModelQueryUtil.getModelQuery((IStructuredModel)htmlModel).getCorrespondingCMDocument((Node)html);
        TestCatalogContentModels.assertNotNull((String)"content model document not found", (Object)correspondingCMDocument);
        TestCatalogContentModels.assertTrue((String)"document is unexpectedly XHTML", (boolean)correspondingCMDocument.supports("isXHTML"));
    }

    private void assertIsXHTMLContentModel(IDOMModel htmlModel) {
        Element html = htmlModel.getDocument().getDocumentElement();
        CMDocument correspondingCMDocument = ModelQueryUtil.getModelQuery((IStructuredModel)htmlModel).getCorrespondingCMDocument((Node)html);
        TestCatalogContentModels.assertNotNull((String)"content model document not found", (Object)correspondingCMDocument);
        TestCatalogContentModels.assertTrue((String)"document is not XHTML", (boolean)correspondingCMDocument.supports("isXHTML"));
    }

    private IDOMModel createHTMLModel(String publicId, String systemId) {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForHTML.ContentTypeID_HTML);
        String source = this.createTestContents(publicId, systemId);
        model.getStructuredDocument().set(source);
        return model;
    }

    private String createTestContents(String publicId, String systemId) {
        String result = null;
        result = systemId != null ? StringUtils.replace((String)contentTemplate, (String)"${SYSTEM}", (String)("\"" + systemId + "\"")) : StringUtils.replace((String)contentTemplate, (String)"${SYSTEM}", (String)"");
        result = publicId != null ? StringUtils.replace((String)contentTemplate, (String)"${PUBLIC}", (String)("\"" + publicId + "\"")) : StringUtils.replace((String)contentTemplate, (String)"${PUBLIC}", (String)"");
        result = publicId != null && systemId != null ? StringUtils.replace((String)contentTemplate, (String)"${METHOD}", (String)"PUBLIC") : (publicId == null && systemId != null ? StringUtils.replace((String)contentTemplate, (String)"${METHOD}", (String)"SYSTEM") : StringUtils.replace((String)contentTemplate, (String)"${METHOD}", (String)""));
        return result;
    }

    public void testCHTMLdraft() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD Compact HTML 1.0 Draft//EN", null);
        this.assertIsNotXHTMLContentModel(htmlModel);
    }

    public void testHTML401Frameset() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd");
        this.assertIsNotXHTMLContentModel(htmlModel);
    }

    public void testHTML401Strict() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd");
        this.assertIsNotXHTMLContentModel(htmlModel);
    }

    public void testHTML401Transitional() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd");
        this.assertIsNotXHTMLContentModel(htmlModel);
    }

    public void testWML11() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//WAPFORUM//DTD WML 1.1//EN", null);
        this.assertIsXHTMLContentModel(htmlModel);
    }

    public void testWML13() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//WAPFORUM//DTD WML 1.3//EN", "http://www.wapforum.org/DTD/wml13.dtd");
        this.assertIsXHTMLContentModel(htmlModel);
    }

    public void testXHTML10Basic() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD XHTML Basic 1.0//EN", "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd");
        this.assertIsXHTMLContentModel(htmlModel);
    }

    public void testXHTML10Frameset() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
        this.assertIsXHTMLContentModel(htmlModel);
    }

    public void testXHTML10Mobile() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//WAPFORUM//DTD XHTML Mobile 1.0//EN", "http://www.wapforum.org/DTD/xhtml-mobile10.dtd");
        this.assertIsXHTMLContentModel(htmlModel);
    }

    public void testXHTML10Strict() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        this.assertIsXHTMLContentModel(htmlModel);
    }

    public void testXHTML10Transitional() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        this.assertIsXHTMLContentModel(htmlModel);
    }

    public void testXHTML11() throws Exception {
        IDOMModel htmlModel = this.createHTMLModel("-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        this.assertIsXHTMLContentModel(htmlModel);
    }
}

