/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.parser;

import org.eclipse.wst.html.core.tests.parser.ModelTest;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.document.SourceValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SourceTest
extends ModelTest {
    public SourceTest(String name) {
        super(name);
    }

    public SourceTest() {
    }

    public static void main(String[] args) {
        new SourceTest().testModel();
    }

    @Override
    public void testModel() {
        IDOMModel model = SourceTest.createHTMLModel();
        try {
            IDOMDocument document = model.getDocument();
            Text t = document.createTextNode("t");
            document.appendChild(t);
            SourceValidator validator = new SourceValidator((Node)t);
            String source = null;
            String result = null;
            source = "aaa<bbb>ccc";
            this.fOutputWriter.writeln("source: " + source);
            try {
                validator.validateSource(source);
            }
            catch (InvalidCharacterException ex) {
                this.fOutputWriter.writeln(ex.getMessage());
            }
            result = validator.convertSource(source);
            this.fOutputWriter.writeln("result: " + result);
            source = "aaa&amp;\"'bbb&gt;&lt;ccc&quot;&#64;";
            this.fOutputWriter.writeln("source: " + source);
            try {
                validator.validateSource(source);
            }
            catch (InvalidCharacterException ex) {
                this.fOutputWriter.writeln(ex.getMessage());
            }
            result = validator.convertSource(source);
            this.fOutputWriter.writeln("result: " + result);
            source = "&amp;&&";
            this.fOutputWriter.writeln("source: " + source);
            try {
                validator.validateSource(source);
            }
            catch (InvalidCharacterException ex) {
                this.fOutputWriter.writeln(ex.getMessage());
            }
            result = validator.convertSource(source);
            this.fOutputWriter.writeln("result: " + result);
            source = "&bbb&<>ccc";
            this.fOutputWriter.writeln("source: " + source);
            try {
                validator.validateSource(source);
            }
            catch (InvalidCharacterException ex) {
                this.fOutputWriter.writeln(ex.getMessage());
            }
            result = validator.convertSource(source);
            this.fOutputWriter.writeln("result: " + result);
            source = "&unk;&unk";
            this.fOutputWriter.writeln("source: " + source);
            try {
                validator.validateSource(source);
            }
            catch (InvalidCharacterException ex) {
                this.fOutputWriter.writeln(ex.getMessage());
            }
            result = validator.convertSource(source);
            this.fOutputWriter.writeln("result: " + result);
            this.saveAndCompareTestResults();
        }
        finally {
            model.releaseFromEdit();
        }
    }
}

