/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.wst.xml.core.contentmodel.modelquery.IExternalSchemaLocationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ExternalSchemaLocationProviderRegistry;

public class ExternalSchemaTest
extends TestCase {
    private static final String EXTERNAL_SCHEMA_LOCATION = "file://external/schema/foo.xsd";

    public void testExternalLocations() throws Exception {
        org.eclipse.wst.xml.core.internal.contentmodel.modelquery.IExternalSchemaLocationProvider[] providers = ExternalSchemaLocationProviderRegistry.getInstance().getProviders();
        ExternalSchemaTest.assertTrue((providers.length > 0 ? 1 : 0) != 0);
        URI resource = new URI("file://uninterested/path/file.xml");
        int i = 0;
        while (i < providers.length) {
            Map locations = providers[i].getExternalSchemaLocation(resource);
            ExternalSchemaTest.assertTrue((String)("[" + resource + "] should have no external schemas."), (locations == null || locations.isEmpty() ? 1 : 0) != 0);
            ++i;
        }
        resource = new URI("file://interested/path/file.xml");
        boolean foundCorrectSchema = false;
        int i2 = 0;
        while (i2 < providers.length) {
            String location;
            Map locations = providers[i2].getExternalSchemaLocation(resource);
            if (locations != null && EXTERNAL_SCHEMA_LOCATION.equals(location = (String)locations.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation"))) {
                foundCorrectSchema = true;
            }
            ExternalSchemaTest.assertTrue((String)("[" + resource + "] should have an external schema."), (boolean)foundCorrectSchema);
            ++i2;
        }
    }

    public static class ExternalSchemaLocationProvider
    implements IExternalSchemaLocationProvider {
        private static URI INTERESTED_RESOURCE = null;

        public ExternalSchemaLocationProvider() {
            try {
                INTERESTED_RESOURCE = new URI("file://interested/path/file.xml");
            }
            catch (Exception exception) {}
        }

        public Map getExternalSchemaLocation(URI fileURI) {
            HashMap<String, String> map = new HashMap<String, String>(1);
            if (fileURI != null && fileURI.equals(INTERESTED_RESOURCE)) {
                map.put("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", ExternalSchemaTest.EXTERNAL_SCHEMA_LOCATION);
            }
            return map;
        }
    }
}

