/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import org.eclipse.jst.pagedesigner.commands.range.RangeModeCommand;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Text;

public class ContentCommand
extends RangeModeCommand {
    private String _content;

    public ContentCommand(IHTMLGraphicalViewer viewer, String content) {
        super("", viewer);
        this._content = content;
    }

    public ContentCommand(IHTMLGraphicalViewer viewer, char c) {
        super("", viewer);
        this._content = String.valueOf(c);
    }

    @Override
    protected DOMRange doRangeExecute(DOMRange range) {
        if (range == null) {
            return null;
        }
        IDOMPosition position = DOMPositionHelper.removeRange(range);
        position = this.doContent(position);
        return new DOMRange(position, position);
    }

    protected IDOMPosition doContent(IDOMPosition position) {
        if ((position = DOMPositionHelper.mergeIntoText(position)).getContainerNode() instanceof Text) {
            Text text = (Text)position.getContainerNode();
            String data = text.getData();
            int offset = position.getOffset();
            String newData = String.valueOf(data.substring(0, offset)) + this._content + data.substring(offset);
            text.setData(newData);
            return new DOMPosition(text, offset + this._content.length());
        }
        Text text = this.getDocument().createTextNode(this._content);
        position.getContainerNode().insertBefore(text, position.getNextSiblingNode());
        return new DOMRefPosition(text, true);
    }
}

